/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.Column;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Order;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.impl.BaseOrdering;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQuery;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommandType;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommandType;
import org.alfresco.repo.search.impl.querymodel.impl.db.PropertySupport;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class DBOrdering
extends BaseOrdering
implements DBQueryBuilderComponent {
    DBQueryBuilderComponent builderSupport;

    public DBOrdering(Column column, Order order) {
        super(column, order);
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public void prepare(NamespaceService namespaceService, DictionaryService dictionaryService, QNameDAO qnameDAO, NodeDAO nodeDAO, TenantService tenantService, Set<String> selectors, Map<String, Argument> functionArgs, FunctionEvaluationContext functionContext) {
        if (this.getColumn().getFunction().getName().equals("PropertyAccessor")) {
            PropertyArgument property = (PropertyArgument)this.getColumn().getFunctionArguments().get("Property");
            if (property == null) {
                throw new QueryModelException("No property to order ");
            }
            if (property.getPropertyName().equals("cmis:parentId")) {
                throw new QueryModelException("Ordering is not supported for cmis:parentId");
            }
            if (property.getPropertyName().equals("cmis:objectId")) {
                throw new QueryModelException("Ordering is not supported for cmis:objectId");
            }
            if (property.getPropertyName().equals("cmis:objectTypeId")) {
                throw new QueryModelException("Ordering is not supported for cmis:objectTypeId");
            }
            if (property.getPropertyName().equals("cmis:baseTypeId")) {
                throw new QueryModelException("Ordering is not supported for cmis:baseTypeId");
            }
            if (property.getPropertyName().equals("cmis:contentStreamMimeType")) {
                PropertySupport propertySupport = new PropertySupport();
                if (this.getOrder() == Order.ASCENDING) {
                    propertySupport.setValue("ASC");
                } else if (this.getOrder() == Order.DESCENDING) {
                    propertySupport.setValue("DESC");
                }
                QName basePropertyQName = QName.createQName((String)DBQuery.expandQName(functionContext.getAlfrescoPropertyName(property.getPropertyName()), (NamespacePrefixResolver)namespaceService));
                propertySupport.setPropertyQName(basePropertyQName);
                propertySupport.setPair(qnameDAO.getQName(basePropertyQName));
                propertySupport.setJoinCommandType(DBQueryBuilderJoinCommandType.CONTENT_MIMETYPE);
                propertySupport.setFieldName("mimetype_str");
                propertySupport.setCommandType(DBQueryBuilderPredicatePartCommandType.ORDER);
                propertySupport.setLeftOuter(true);
                this.builderSupport = propertySupport;
            } else if (property.getPropertyName().equals("cmis:contentStreamLength")) {
                PropertySupport propertySupport = new PropertySupport();
                if (this.getOrder() == Order.ASCENDING) {
                    propertySupport.setValue("ASC");
                } else if (this.getOrder() == Order.DESCENDING) {
                    propertySupport.setValue("DESC");
                }
                QName basePropertyQName = QName.createQName((String)DBQuery.expandQName(functionContext.getAlfrescoPropertyName(property.getPropertyName()), (NamespacePrefixResolver)namespaceService));
                propertySupport.setPropertyQName(basePropertyQName);
                propertySupport.setPair(qnameDAO.getQName(basePropertyQName));
                propertySupport.setJoinCommandType(DBQueryBuilderJoinCommandType.CONTENT_URL);
                propertySupport.setFieldName("content_size");
                propertySupport.setCommandType(DBQueryBuilderPredicatePartCommandType.ORDER);
                propertySupport.setLeftOuter(true);
                this.builderSupport = propertySupport;
            } else {
                PropertySupport propertySupport = new PropertySupport();
                if (this.getOrder() == Order.ASCENDING) {
                    propertySupport.setValue("ASC");
                } else if (this.getOrder() == Order.DESCENDING) {
                    propertySupport.setValue("DESC");
                }
                QName propertyQName = QName.createQName((String)DBQuery.expandQName(functionContext.getAlfrescoPropertyName(property.getPropertyName()), (NamespacePrefixResolver)namespaceService));
                propertySupport.setPropertyQName(propertyQName);
                propertySupport.setPair(qnameDAO.getQName(propertyQName));
                propertySupport.setJoinCommandType(DBQuery.getJoinCommandType(propertyQName));
                propertySupport.setFieldName(DBQuery.getFieldName(dictionaryService, propertyQName));
                propertySupport.setCommandType(DBQueryBuilderPredicatePartCommandType.ORDER);
                propertySupport.setLeftOuter(true);
                this.builderSupport = propertySupport;
            }
        } else {
            if (this.getColumn().getFunction().getName().equals("Score")) {
                throw new QueryModelException("Ordering on score() is not supported");
            }
            throw new QueryModelException("Ordering not supported " + this.getColumn().getFunction().getName());
        }
    }

    @Override
    public void buildJoins(Map<QName, DBQueryBuilderJoinCommand> singleJoins, List<DBQueryBuilderJoinCommand> multiJoins) {
        this.builderSupport.buildJoins(singleJoins, multiJoins);
    }

    @Override
    public void buildPredicateCommands(List<DBQueryBuilderPredicatePartCommand> predicatePartCommands) {
        this.builderSupport.buildPredicateCommands(predicatePartCommands);
    }
}

