/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.Column;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Ordering;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.Selector;
import org.alfresco.repo.search.impl.querymodel.Source;
import org.alfresco.repo.search.impl.querymodel.impl.BaseQuery;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommandType;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommandType;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class DBQuery
extends BaseQuery
implements DBQueryBuilderComponent {
    private Long storeId;
    private Long sysDeletedType;
    Set<String> selectorGroup;

    public DBQuery(List<Column> columns, Source source, Constraint constraint, List<Ordering> orderings) {
        super(columns, source, constraint, orderings);
    }

    public Long getStoreId() {
        return this.storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public Long getSysDeletedType() {
        return this.sysDeletedType;
    }

    public void setSysDeletedType(Long sysDeletedType) {
        this.sysDeletedType = sysDeletedType;
    }

    public List<DBQueryBuilderJoinCommand> getJoins() {
        HashMap<QName, DBQueryBuilderJoinCommand> singleJoins = new HashMap<QName, DBQueryBuilderJoinCommand>();
        ArrayList<DBQueryBuilderJoinCommand> multipleJoins = new ArrayList<DBQueryBuilderJoinCommand>();
        this.buildJoins(singleJoins, multipleJoins);
        ArrayList<DBQueryBuilderJoinCommand> allJoins = new ArrayList<DBQueryBuilderJoinCommand>();
        allJoins.addAll(singleJoins.values());
        allJoins.addAll(multipleJoins);
        return allJoins;
    }

    public boolean getHasPredicate() {
        return this.getConstraint() != null || this.getSource().getSelectors().size() > 0;
    }

    public boolean getHasOrderBy() {
        return this.getOrderings() != null && this.getOrderings().size() > 0;
    }

    public List<DBQueryBuilderPredicatePartCommand> getPredicateParts() {
        ArrayList<DBQueryBuilderPredicatePartCommand> predicatePartCommands = new ArrayList<DBQueryBuilderPredicatePartCommand>();
        this.buildPredicateCommands(predicatePartCommands);
        return predicatePartCommands;
    }

    @Override
    public boolean isSupported() {
        if (this.getConstraint() instanceof DBQueryBuilderComponent) {
            return ((DBQueryBuilderComponent)this.getConstraint()).isSupported();
        }
        return false;
    }

    @Override
    public void prepare(NamespaceService namespaceService, DictionaryService dictionaryService, QNameDAO qnameDAO, NodeDAO nodeDAO, TenantService tenantService, Set<String> selectors, Map<String, Argument> functionArgs, FunctionEvaluationContext functionContext) {
        this.selectorGroup = selectors;
        if (this.selectorGroup != null) {
            for (String selector : this.selectorGroup) {
                Selector current = this.getSource().getSelector(selector);
                if (current instanceof DBQueryBuilderComponent) {
                    ((DBQueryBuilderComponent)current).prepare(namespaceService, dictionaryService, qnameDAO, nodeDAO, tenantService, this.selectorGroup, functionArgs, functionContext);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
        if (this.getConstraint() != null) {
            if (this.getConstraint() instanceof DBQueryBuilderComponent) {
                ((DBQueryBuilderComponent)this.getConstraint()).prepare(namespaceService, dictionaryService, qnameDAO, nodeDAO, tenantService, this.selectorGroup, functionArgs, functionContext);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        if (this.getOrderings() != null) {
            for (Ordering ordering : this.getOrderings()) {
                if (ordering instanceof DBQueryBuilderComponent) {
                    ((DBQueryBuilderComponent)ordering).prepare(namespaceService, dictionaryService, qnameDAO, nodeDAO, tenantService, this.selectorGroup, functionArgs, functionContext);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void buildJoins(Map<QName, DBQueryBuilderJoinCommand> singleJoins, List<DBQueryBuilderJoinCommand> multiJoins) {
        if (this.selectorGroup != null) {
            for (String selector : this.selectorGroup) {
                Selector current = this.getSource().getSelector(selector);
                if (current instanceof DBQueryBuilderComponent) {
                    ((DBQueryBuilderComponent)current).buildJoins(singleJoins, multiJoins);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
        if (this.getConstraint() != null) {
            if (this.getConstraint() instanceof DBQueryBuilderComponent) {
                ((DBQueryBuilderComponent)this.getConstraint()).buildJoins(singleJoins, multiJoins);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        if (this.getOrderings() != null) {
            for (Ordering ordering : this.getOrderings()) {
                if (ordering instanceof DBQueryBuilderComponent) {
                    ((DBQueryBuilderComponent)ordering).buildJoins(singleJoins, multiJoins);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void buildPredicateCommands(List<DBQueryBuilderPredicatePartCommand> predicatePartCommands) {
        boolean requiresAnd = false;
        if (this.selectorGroup != null) {
            for (String selector : this.selectorGroup) {
                Selector current = this.getSource().getSelector(selector);
                if (current instanceof DBQueryBuilderComponent) {
                    if (requiresAnd) {
                        DBQueryBuilderPredicatePartCommand and = new DBQueryBuilderPredicatePartCommand();
                        and.setType(DBQueryBuilderPredicatePartCommandType.AND);
                        predicatePartCommands.add(and);
                    }
                    ((DBQueryBuilderComponent)current).buildPredicateCommands(predicatePartCommands);
                    requiresAnd = true;
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
        if (this.getConstraint() != null) {
            if (this.getConstraint() instanceof DBQueryBuilderComponent) {
                if (requiresAnd) {
                    DBQueryBuilderPredicatePartCommand and = new DBQueryBuilderPredicatePartCommand();
                    and.setType(DBQueryBuilderPredicatePartCommandType.AND);
                    predicatePartCommands.add(and);
                }
                ((DBQueryBuilderComponent)this.getConstraint()).buildPredicateCommands(predicatePartCommands);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        if (this.getOrderings() != null) {
            for (Ordering ordering : this.getOrderings()) {
                if (ordering instanceof DBQueryBuilderComponent) {
                    ((DBQueryBuilderComponent)ordering).buildPredicateCommands(predicatePartCommands);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
    }

    public static String[] getUUIDs(String[] source) {
        String[] uuids = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            uuids[i] = DBQuery.getUUID(source[i]);
        }
        return uuids;
    }

    public static String getUUID(String source) {
        String ref;
        String versionLabel = null;
        String[] split = source.split(";");
        if (split.length == 1) {
            ref = source;
        } else {
            if (split[1].equalsIgnoreCase("PWC")) {
                throw new UnsupportedOperationException("Query for PWC is not supported");
            }
            ref = split[0];
            versionLabel = split[1];
        }
        if (NodeRef.isNodeRef((String)ref)) {
            NodeRef nodeRef = new NodeRef(ref);
            return nodeRef.getId();
        }
        return ref;
    }

    public static Long getDbid(String source, NodeDAO nodeDAO, TenantService tenantService) {
        String ref;
        String versionLabel = null;
        String[] split = source.split(";");
        if (split.length == 1) {
            ref = source;
        } else {
            if (split[1].equalsIgnoreCase("PWC")) {
                throw new UnsupportedOperationException("Query for PWC is not supported");
            }
            ref = split[0];
            versionLabel = split[1];
        }
        if (NodeRef.isNodeRef((String)ref)) {
            NodeRef nodeRef = tenantService.getName(new NodeRef(ref));
            Pair<Long, NodeRef> pair = nodeDAO.getNodePair(nodeRef);
            if (pair == null) {
                throw new QueryModelException("Invalid Object Id " + ref);
            }
            return (Long)pair.getFirst();
        }
        NodeRef nodeRef = new NodeRef(tenantService.getName(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), ref);
        Pair<Long, NodeRef> pair = nodeDAO.getNodePair(nodeRef);
        if (pair == null) {
            throw new QueryModelException("Invalid Object Id " + ref);
        }
        return (Long)pair.getFirst();
    }

    public static List<Long> findTypeIds(String type, NamespaceService namespaceService, DictionaryService dictionaryService, QNameDAO qnameDAO, boolean exact) {
        ArrayList<Long> qnameIds = new ArrayList<Long>();
        TypeDefinition target = DBQuery.matchTypeDefinition(type, (NamespacePrefixResolver)namespaceService, dictionaryService);
        if (target == null) {
            throw new QueryModelException("Invalid type: " + type);
        }
        if (exact) {
            Pair<Long, QName> pair = qnameDAO.getQName(target.getName());
            if (pair != null) {
                Long qnameId = (Long)pair.getFirst();
                qnameIds.add(qnameId);
            }
        } else {
            Collection subclasses = dictionaryService.getSubTypes(target.getName(), true);
            for (QName qname : subclasses) {
                Pair<Long, QName> pair;
                TypeDefinition current = dictionaryService.getType(qname);
                if (!target.getName().equals((Object)current.getName()) && !current.getIncludedInSuperTypeQuery().booleanValue() || (pair = qnameDAO.getQName(qname)) == null) continue;
                Long qnameId = (Long)pair.getFirst();
                qnameIds.add(qnameId);
            }
        }
        return qnameIds;
    }

    public static List<Long> findAspectIds(String aspect, NamespaceService namespaceService, DictionaryService dictionaryService, QNameDAO qnameDAO, boolean exact) {
        ArrayList<Long> qnameIds = new ArrayList<Long>();
        AspectDefinition target = DBQuery.matchAspectDefinition(aspect, (NamespacePrefixResolver)namespaceService, dictionaryService);
        if (target == null) {
            throw new QueryModelException("Invalid aspect: " + aspect);
        }
        if (exact) {
            Pair<Long, QName> pair = qnameDAO.getQName(target.getName());
            if (pair != null) {
                Long qnameId = (Long)pair.getFirst();
                qnameIds.add(qnameId);
            }
        } else {
            Collection subaspects = dictionaryService.getSubAspects(target.getName(), true);
            for (QName qname : subaspects) {
                Pair<Long, QName> pair;
                AspectDefinition current = dictionaryService.getAspect(qname);
                if (!target.getName().equals((Object)current.getName()) && !current.getIncludedInSuperTypeQuery().booleanValue() || (pair = qnameDAO.getQName(qname)) == null) continue;
                Long qnameId = (Long)pair.getFirst();
                qnameIds.add(qnameId);
            }
        }
        return qnameIds;
    }

    public static String[] toStringValues(Collection<?> objects) {
        String[] answer = new String[objects.size()];
        int i = 0;
        Iterator<?> it = objects.iterator();
        while (it.hasNext()) {
            answer[i++] = it.next().toString();
        }
        return answer;
    }

    public static String[] toStringValues(Object[] objects) {
        String[] answer = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            answer[i] = objects[i].toString();
        }
        return answer;
    }

    public static String expandQName(String toStrip, NamespacePrefixResolver namespacePrefixResolver) {
        String qnameString = toStrip.endsWith(".size") ? toStrip.substring(0, toStrip.length() - 5) : (toStrip.endsWith(".mimetype") ? toStrip.substring(0, toStrip.length() - 9) : toStrip);
        String fieldName = qnameString;
        if (fieldName.startsWith("@")) {
            fieldName = fieldName.substring(1);
        }
        if (fieldName.charAt(0) != '{') {
            String prefix;
            String uri;
            int colonPosition = fieldName.indexOf(58);
            fieldName = colonPosition == -1 ? "{http://www.alfresco.org/model/content/1.0}" + fieldName : ((uri = DBQuery.matchURI(prefix = fieldName.substring(0, colonPosition), namespacePrefixResolver)) == null ? "{http://www.alfresco.org/model/content/1.0}" + fieldName : "{" + uri + "}" + fieldName.substring(colonPosition + 1));
        }
        return fieldName;
    }

    public static String matchURI(String prefix, NamespacePrefixResolver namespacePrefixResolver) {
        HashSet prefixes = new HashSet(namespacePrefixResolver.getPrefixes());
        if (prefixes.contains(prefix)) {
            return namespacePrefixResolver.getNamespaceURI(prefix);
        }
        String match = null;
        for (String candidate : prefixes) {
            if (!candidate.equalsIgnoreCase(prefix)) continue;
            if (match == null) {
                match = candidate;
                continue;
            }
            throw new QueryModelException("Ambiguous namespace prefix " + prefix);
        }
        if (match == null) {
            return null;
        }
        return namespacePrefixResolver.getNamespaceURI(match);
    }

    public static TypeDefinition matchTypeDefinition(String string, NamespacePrefixResolver namespacePrefixResolver, DictionaryService dictionaryService) {
        QName search = QName.createQName((String)DBQuery.expandQName(string, namespacePrefixResolver));
        TypeDefinition typeDefinition = dictionaryService.getType(search);
        QName match = null;
        if (typeDefinition == null) {
            for (QName definition : dictionaryService.getAllTypes()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new QueryModelException("Ambiguous data datype " + string);
            }
        } else {
            return typeDefinition;
        }
        if (match == null) {
            return null;
        }
        return dictionaryService.getType(match);
    }

    public static AspectDefinition matchAspectDefinition(String string, NamespacePrefixResolver namespacePrefixResolver, DictionaryService dictionaryService) {
        QName search = QName.createQName((String)DBQuery.expandQName(string, namespacePrefixResolver));
        AspectDefinition aspectDefinition = dictionaryService.getAspect(search);
        QName match = null;
        if (aspectDefinition == null) {
            for (QName definition : dictionaryService.getAllAspects()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new QueryModelException("Ambiguous data datype " + string);
            }
        } else {
            return aspectDefinition;
        }
        if (match == null) {
            return null;
        }
        return dictionaryService.getAspect(match);
    }

    public static DBQueryBuilderJoinCommandType getJoinCommandType(QName propertyQName) {
        if (propertyQName.equals((Object)ContentModel.PROP_CREATED) || propertyQName.equals((Object)ContentModel.PROP_CREATOR) || propertyQName.equals((Object)ContentModel.PROP_MODIFIED) || propertyQName.equals((Object)ContentModel.PROP_MODIFIER)) {
            return DBQueryBuilderJoinCommandType.NODE;
        }
        if (propertyQName.toString().endsWith(".mimetype")) {
            return DBQueryBuilderJoinCommandType.CONTENT_MIMETYPE;
        }
        if (propertyQName.toString().endsWith(".size")) {
            return DBQueryBuilderJoinCommandType.CONTENT_URL;
        }
        return DBQueryBuilderJoinCommandType.PROPERTY;
    }

    public static String getFieldName(DictionaryService dictionaryService, QName propertyQName) {
        if (propertyQName.equals((Object)ContentModel.PROP_CREATED)) {
            return "audit_created";
        }
        if (propertyQName.equals((Object)ContentModel.PROP_CREATOR)) {
            return "audit_creator";
        }
        if (propertyQName.equals((Object)ContentModel.PROP_MODIFIED)) {
            return "audit_modified";
        }
        if (propertyQName.equals((Object)ContentModel.PROP_MODIFIER)) {
            return "audit_modifier";
        }
        PropertyDefinition propDef = dictionaryService.getProperty(propertyQName);
        if (propDef == null) {
            throw new QueryModelException("Unknown property " + propertyQName);
        }
        DataTypeDefinition dataType = propDef.getDataType();
        if (dataType.getName().equals((Object)DataTypeDefinition.ASSOC_REF)) {
            return "string_value";
        }
        if (dataType.getName().equals((Object)DataTypeDefinition.CATEGORY)) {
            return "string_value";
        }
        if (dataType.getName().equals((Object)DataTypeDefinition.DATE)) {
            return "string_value";
        }
        if (dataType.getName().equals((Object)DataTypeDefinition.DATETIME)) {
            return "string_value";
        }
        if (dataType.getName().equals((Object)DataTypeDefinition.INT)) {
            return "long_value";
        }
        if (dataType.getName().equals((Object)DataTypeDefinition.LOCALE)) {
            return "string_value";
        }
        if (dataType.getName().equals((Object)DataTypeDefinition.LONG)) {
            return "long_value";
        }
        if (dataType.getName().equals((Object)DataTypeDefinition.MLTEXT)) {
            return "string_value";
        }
        if (dataType.getName().equals((Object)DataTypeDefinition.NODE_REF)) {
            return "string_value";
        }
        if (dataType.getName().equals((Object)DataTypeDefinition.PERIOD)) {
            return "string_value";
        }
        if (dataType.getName().equals((Object)DataTypeDefinition.QNAME)) {
            return "string_value";
        }
        if (dataType.getName().equals((Object)DataTypeDefinition.TEXT)) {
            return "string_value";
        }
        throw new QueryModelException("Unsupported property type " + dataType.getName());
    }

    public static DataTypeDefinition getDataTypeDefinition(DictionaryService dictionaryService, QName propertyQname) {
        if (propertyQname == null) {
            return null;
        }
        PropertyDefinition propDef = dictionaryService.getProperty(propertyQname);
        if (propDef == null) {
            return null;
        }
        return propDef.getDataType();
    }

    public static Long[] getDbids(String[] stringValues, NodeDAO nodeDAO, TenantService tenantService) {
        Long[] dbids = new Long[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            dbids[i] = DBQuery.getDbid(stringValues[i], nodeDAO, tenantService);
        }
        return dbids;
    }
}

