/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.search.AbstractResultSet;
import org.alfresco.repo.search.SimpleResultSetMetaData;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBResultSetRow;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBResultSetRowIterator;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;

public class DBResultSet
extends AbstractResultSet {
    private List<Long> dbids;
    private NodeRef[] nodeRefs;
    private NodeDAO nodeDao;
    private NodeService nodeService;
    private SimpleResultSetMetaData resultSetMetaData;
    private BitSet prefetch;

    public DBResultSet(SearchParameters searchParameters, List<Long> dbids, NodeDAO nodeDao, NodeService nodeService, int maximumResultsFromUnlimitedQuery) {
        LimitBy limitBy;
        this.nodeDao = nodeDao;
        this.dbids = dbids;
        this.nodeService = nodeService;
        this.prefetch = new BitSet(dbids.size());
        this.nodeRefs = new NodeRef[dbids.size()];
        int maxResults = -1;
        if (searchParameters.getMaxItems() >= 0) {
            maxResults = searchParameters.getMaxItems();
            limitBy = LimitBy.FINAL_SIZE;
        } else if (searchParameters.getLimitBy() == LimitBy.FINAL_SIZE && searchParameters.getLimit() >= 0) {
            maxResults = searchParameters.getLimit();
            limitBy = LimitBy.FINAL_SIZE;
        } else {
            maxResults = searchParameters.getMaxPermissionChecks();
            if (maxResults < 0) {
                maxResults = maximumResultsFromUnlimitedQuery;
            }
            limitBy = LimitBy.NUMBER_OF_PERMISSION_EVALUATIONS;
        }
        this.resultSetMetaData = new SimpleResultSetMetaData(maxResults > 0 && dbids.size() < maxResults ? LimitBy.UNLIMITED : limitBy, PermissionEvaluationMode.EAGER, searchParameters);
    }

    public int length() {
        return this.dbids.size();
    }

    public long getNumberFound() {
        return this.dbids.size();
    }

    public NodeRef getNodeRef(int n) {
        this.prefetch(n);
        return this.nodeRefs[n];
    }

    public ResultSetRow getRow(int i) {
        return new DBResultSetRow(this, i);
    }

    public ChildAssociationRef getChildAssocRef(int n) {
        ChildAssociationRef primaryParentAssoc = this.nodeService.getPrimaryParent(this.getNodeRef(n));
        if (primaryParentAssoc != null) {
            return primaryParentAssoc;
        }
        return null;
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public int getStart() {
        return 0;
    }

    public boolean hasMore() {
        return false;
    }

    public Iterator<ResultSetRow> iterator() {
        return new DBResultSetRowIterator(this);
    }

    private void prefetch(int n) {
        int next;
        int i;
        if (this.prefetch.get(n)) {
            return;
        }
        int bulkFetchSize = this.getBulkFetchSize();
        if (bulkFetchSize < 1) {
            this.nodeRefs[n] = (NodeRef)this.nodeDao.getNodePair(this.dbids.get(n)).getSecond();
            return;
        }
        ArrayList<Long> fetchList = new ArrayList<Long>(bulkFetchSize);
        BitSet done = new BitSet(bulkFetchSize);
        int totalHits = this.dbids.size();
        for (i = 0; i < bulkFetchSize && (next = n + i) < totalHits; ++i) {
            if (this.prefetch.get(next)) continue;
            this.prefetch.set(next);
            fetchList.add(this.dbids.get(next));
            done.set(next);
        }
        if (fetchList.size() > 1) {
            this.nodeDao.cacheNodesById(fetchList);
            i = done.nextSetBit(0);
            while (i >= 0) {
                this.nodeRefs[n + i] = (NodeRef)this.nodeDao.getNodePair((Long)fetchList.get(i)).getSecond();
                i = done.nextSetBit(i + 1);
            }
        }
    }
}

