/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db.functions;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQuery;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommandType;
import org.alfresco.repo.search.impl.querymodel.impl.db.ParentSupport;
import org.alfresco.repo.search.impl.querymodel.impl.functions.Child;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class DBChild
extends Child
implements DBQueryBuilderComponent {
    DBQueryBuilderComponent builderSupport;

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public void prepare(NamespaceService namespaceService, DictionaryService dictionaryService, QNameDAO qnameDAO, NodeDAO nodeDAO, TenantService tenantService, Set<String> selectors, Map<String, Argument> functionArgs, FunctionEvaluationContext functionContext) {
        Argument argument = functionArgs.get("Parent");
        String id = (String)((Object)argument.getValue(functionContext));
        argument = functionArgs.get("Selector");
        if (argument != null) {
            String selector = (String)((Object)argument.getValue(functionContext));
            if (!selectors.contains(selector)) {
                throw new QueryModelException("Unkown selector " + selector);
            }
        } else if (selectors.size() > 1) {
            throw new QueryModelException("Selector must be specified for child constraint (IN_FOLDER) and join");
        }
        ParentSupport parentSupport = new ParentSupport();
        parentSupport.setDbid(DBQuery.getDbid(id, nodeDAO, tenantService));
        parentSupport.setCommandType(DBQueryBuilderPredicatePartCommandType.EQUALS);
        this.builderSupport = parentSupport;
    }

    @Override
    public void buildJoins(Map<QName, DBQueryBuilderJoinCommand> singleJoins, List<DBQueryBuilderJoinCommand> multiJoins) {
        this.builderSupport.buildJoins(singleJoins, multiJoins);
    }

    @Override
    public void buildPredicateCommands(List<DBQueryBuilderPredicatePartCommand> predicatePartCommands) {
        this.builderSupport.buildPredicateCommands(predicatePartCommands);
    }
}

