/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParserException;
import org.alfresco.repo.search.impl.solr.SolrAdminHTTPClient;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;

public class SolrChildApplicationContextFactory
extends ChildApplicationContextFactory {
    private static String ALFRESCO_ACTIVE = "tracker.alfresco.active";
    private static String ALFRESCO_LAG = "tracker.alfresco.lag";
    private static String ALFRESCO_LAG_DURATION = "tracker.alfresco.lag.duration";
    private static String ALFRESCO_LAST_INDEXED_TXN = "tracker.alfresco.last.indexed.txn";
    private static String ALFRESCO_APPROX_TXNS_REMAINING = "tracker.alfresco.approx.txns.remaining";
    private static String ALFRESCO_APPROX_INDEXING_TIME_REMAINING = "tracker.alfresco.approx.indexing.time.remaining";
    private static String ALFRESCO_DISK = "tracker.alfresco.disk";
    private static String ALFRESCO_MEMORY = "tracker.alfresco.memory";
    private static String ARCHIVE_ACTIVE = "tracker.archive.active";
    private static String ARCHIVE_LAG = "tracker.archive.lag";
    private static String ARCHIVE_LAG_DURATION = "tracker.archive.lag.duration";
    private static String ARCHIVE_LAST_INDEXED_TXN = "tracker.archive.last.indexed.txn";
    private static String ARCHIVE_APPROX_TXNS_REMAINING = "tracker.archive.approx.txns.remaining";
    private static String ARCHIVE_APPROX_INDEXING_TIME_REMAINING = "tracker.archive.approx.indexing.time.remaining";
    private static String ARCHIVE_DISK = "tracker.archive.disk";
    private static String ARCHIVE_MEMORY = "tracker.archive.memory";

    @Override
    public boolean isUpdateable(String name) {
        return super.isUpdateable(name) && !name.equals(ALFRESCO_ACTIVE) && !name.equals(ALFRESCO_LAG) && !name.equals(ALFRESCO_LAG_DURATION) && !name.equals(ALFRESCO_LAST_INDEXED_TXN) && !name.equals(ALFRESCO_APPROX_TXNS_REMAINING) && !name.equals(ALFRESCO_APPROX_INDEXING_TIME_REMAINING) && !name.equals(ALFRESCO_DISK) && !name.equals(ALFRESCO_MEMORY) && !name.equals(ARCHIVE_ACTIVE) && !name.equals(ARCHIVE_LAG) && !name.equals(ARCHIVE_LAG_DURATION) && !name.equals(ARCHIVE_APPROX_TXNS_REMAINING) && !name.equals(ARCHIVE_APPROX_INDEXING_TIME_REMAINING) && !name.equals(ARCHIVE_LAST_INDEXED_TXN) && !name.equals(ARCHIVE_DISK) && !name.equals(ARCHIVE_MEMORY);
    }

    @Override
    public String getProperty(String name) {
        if (!this.isUpdateable(name) && ((ChildApplicationContextFactory.ApplicationContextState)this.getState(false)).getApplicationContext(false) != null) {
            try {
                ApplicationContext ctx = this.getApplicationContext();
                SolrAdminHTTPClient adminClient = (SolrAdminHTTPClient)ctx.getBean("search.solrAdminHTTPCLient");
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("action", "SUMMARY");
                args.put("wt", "json");
                JSONObject json = adminClient.execute(args);
                JSONObject summary = json.getJSONObject("Summary");
                Date now = new Date();
                JSONObject alfresco = summary.getJSONObject("alfresco");
                String alfrescoLag = alfresco.getString("TX Lag");
                String alfrescoActive = alfresco.getString("Active");
                String alfrescoDuration = alfresco.getString("TX Duration");
                String alfrescoLastIndexedTxn = alfresco.getString("Id for last TX in index");
                String alfrescoApproxTxnsReminaing = alfresco.getString("Approx transactions remaining");
                String alfrescoApproxIndexingTimeReminaing = alfresco.getString("Approx transaction indexing time remaining");
                String alfrescoDisk = alfresco.getString("On disk (GB)");
                String alfrescoMemory = alfresco.getString("Total Searcher Cache (GB)");
                JSONObject archive = summary.getJSONObject("archive");
                String archiveLag = archive.getString("TX Lag");
                String archiveActive = archive.getString("Active");
                String archiveDuration = archive.getString("TX Duration");
                String archiveLastIndexedTxn = archive.getString("Id for last TX in index");
                String archiveApproxTxnsReminaing = archive.getString("Approx transactions remaining");
                String archiveApproxIndexingTimeReminaing = archive.getString("Approx transaction indexing time remaining");
                String archiveDisk = archive.getString("On disk (GB)");
                String archiveMemory = archive.getString("Total Searcher Cache (GB)");
                if (name.equals(ALFRESCO_ACTIVE)) {
                    if (alfrescoActive == null || alfrescoActive.isEmpty()) {
                        return "false";
                    }
                    return alfrescoActive;
                }
                if (name.equals(ALFRESCO_LAG)) {
                    return alfrescoLag;
                }
                if (name.equals(ALFRESCO_LAG_DURATION)) {
                    return alfrescoDuration;
                }
                if (name.equals(ALFRESCO_LAST_INDEXED_TXN)) {
                    return alfrescoLastIndexedTxn;
                }
                if (name.equals(ALFRESCO_APPROX_TXNS_REMAINING)) {
                    return alfrescoApproxTxnsReminaing;
                }
                if (name.equals(ALFRESCO_APPROX_INDEXING_TIME_REMAINING)) {
                    return alfrescoApproxIndexingTimeReminaing;
                }
                if (name.equals(ALFRESCO_DISK)) {
                    return alfrescoDisk;
                }
                if (name.equals(ALFRESCO_MEMORY)) {
                    return alfrescoMemory;
                }
                if (name.equals(ARCHIVE_ACTIVE)) {
                    return archiveActive;
                }
                if (name.equals(ARCHIVE_LAG)) {
                    return archiveLag;
                }
                if (name.equals(ARCHIVE_LAG_DURATION)) {
                    return archiveDuration;
                }
                if (name.equals(ARCHIVE_LAST_INDEXED_TXN)) {
                    return archiveLastIndexedTxn;
                }
                if (name.equals(ARCHIVE_APPROX_TXNS_REMAINING)) {
                    return archiveApproxTxnsReminaing;
                }
                if (name.equals(ARCHIVE_APPROX_INDEXING_TIME_REMAINING)) {
                    return archiveApproxIndexingTimeReminaing;
                }
                if (name.equals(ARCHIVE_DISK)) {
                    return archiveDisk;
                }
                if (name.equals(ARCHIVE_MEMORY)) {
                    return archiveMemory;
                }
                return "Unavailable";
            }
            catch (LuceneQueryParserException lqe) {
                return "Unavailable: " + lqe.getMessage();
            }
            catch (JSONException e) {
                return "Unavailable: " + e.getMessage();
            }
        }
        if (name.equals(ALFRESCO_ACTIVE)) {
            return "";
        }
        if (name.equals(ARCHIVE_ACTIVE)) {
            return "";
        }
        if (name.equals(ALFRESCO_LAG)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ALFRESCO_LAG_DURATION)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ALFRESCO_LAST_INDEXED_TXN)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ALFRESCO_APPROX_TXNS_REMAINING)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ALFRESCO_APPROX_INDEXING_TIME_REMAINING)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ALFRESCO_DISK)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ALFRESCO_MEMORY)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ARCHIVE_LAG)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ARCHIVE_LAG_DURATION)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ARCHIVE_LAST_INDEXED_TXN)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ARCHIVE_APPROX_TXNS_REMAINING)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ARCHIVE_APPROX_INDEXING_TIME_REMAINING)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ARCHIVE_DISK)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ARCHIVE_MEMORY)) {
            return "Unavailable: solr subsystem not started";
        }
        return super.getProperty(name);
    }

    @Override
    public Set<String> getPropertyNames() {
        TreeSet<String> result = new TreeSet<String>();
        result.add(ALFRESCO_ACTIVE);
        result.add(ALFRESCO_LAG);
        result.add(ALFRESCO_LAG_DURATION);
        result.add(ALFRESCO_LAST_INDEXED_TXN);
        result.add(ALFRESCO_APPROX_TXNS_REMAINING);
        result.add(ALFRESCO_APPROX_INDEXING_TIME_REMAINING);
        result.add(ALFRESCO_DISK);
        result.add(ALFRESCO_MEMORY);
        result.add(ARCHIVE_ACTIVE);
        result.add(ARCHIVE_LAG);
        result.add(ARCHIVE_LAG_DURATION);
        result.add(ARCHIVE_LAST_INDEXED_TXN);
        result.add(ARCHIVE_APPROX_TXNS_REMAINING);
        result.add(ARCHIVE_APPROX_INDEXING_TIME_REMAINING);
        result.add(ARCHIVE_DISK);
        result.add(ARCHIVE_MEMORY);
        result.addAll(super.getPropertyNames());
        return result;
    }

    @Override
    public void setProperty(String name, String value) {
        if (!this.isUpdateable(name)) {
            throw new IllegalStateException("Illegal write to property \"" + name + "\"");
        }
        super.setProperty(name, value);
    }
}

