/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import net.sf.acegisecurity.Authentication;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationDiagnostic;
import org.alfresco.repo.security.authentication.AuthenticationException;

public abstract class AbstractChainingAuthenticationComponent
extends AbstractAuthenticationComponent {
    protected abstract AuthenticationComponent getAuthenticationComponent(String var1);

    protected abstract Collection<AuthenticationComponent> getUsableAuthenticationComponents();

    @Override
    protected void authenticateImpl(String userName, char[] password) {
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            try {
                authComponent.authenticate(userName, password);
                return;
            }
            catch (AuthenticationException e) {
            }
        }
        throw new AuthenticationException("Failed to authenticate");
    }

    public void testAuthenticate(String authenticatorName, String userName, char[] password) {
        AuthenticationComponent authenticationComponent = this.getAuthenticationComponent(authenticatorName);
        if (authenticationComponent != null) {
            if (authenticationComponent instanceof ActivateableBean && !((ActivateableBean)((Object)authenticationComponent)).isActive()) {
                AuthenticationDiagnostic diagnostic = new AuthenticationDiagnostic();
                Object[] args = new Object[]{authenticatorName};
                diagnostic.addStep("authentication.ldap.validation.authenticator.notactive", false, args);
                throw new AuthenticationException("authentication.err.validation.authenticator.notactive", args, diagnostic);
            }
            authenticationComponent.authenticate(userName, password);
            return;
        }
        AuthenticationDiagnostic diagnostic = new AuthenticationDiagnostic();
        Object[] args = new Object[]{authenticatorName};
        diagnostic.addStep("authentication.ldap.validation.authenticator.notfound", false, args);
        throw new AuthenticationException("authentication.err.validation.authenticator.notfound", args, diagnostic);
    }

    @Override
    protected boolean implementationAllowsGuestLogin() {
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            if (!authComponent.guestUserAuthenticationAllowed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Authentication setCurrentUser(String userName, AuthenticationComponent.UserNameValidationMode validationMode) {
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            try {
                return authComponent.setCurrentUser(userName, validationMode);
            }
            catch (AuthenticationException e) {
            }
        }
        throw new AuthenticationException("Failed to set current user " + userName);
    }

    @Override
    public Authentication setCurrentUser(String userName) {
        AuthenticationException last = null;
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            try {
                return authComponent.setCurrentUser(userName);
            }
            catch (AuthenticationException e) {
                last = e;
            }
        }
        throw new AuthenticationException("Failed to set current user " + userName, (Throwable)last);
    }

    @Override
    public Set<String> getDefaultAdministratorUserNames() {
        TreeSet<String> defaultAdministratorUserNames = new TreeSet<String>();
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            defaultAdministratorUserNames.addAll(authComponent.getDefaultAdministratorUserNames());
        }
        return defaultAdministratorUserNames;
    }

    @Override
    public Set<String> getDefaultGuestUserNames() {
        TreeSet<String> defaultGuestUserNames = new TreeSet<String>();
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            defaultGuestUserNames.addAll(authComponent.getDefaultGuestUserNames());
        }
        return defaultGuestUserNames;
    }
}

