/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ldap;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationDiagnostic;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.ldap.LDAPInitialDirContextFactory;
import org.alfresco.repo.security.sync.ldap.LDAPNameResolver;
import org.springframework.beans.factory.InitializingBean;

public class LDAPAuthenticationComponentImpl
extends AbstractAuthenticationComponent
implements InitializingBean,
ActivateableBean {
    private boolean escapeCommasInBind = false;
    private boolean escapeCommasInUid = false;
    private boolean active = true;
    private String userNameFormat;
    private LDAPNameResolver ldapNameResolver;
    private LDAPInitialDirContextFactory ldapInitialContextFactory;
    private String id = "default";

    public void setLDAPInitialDirContextFactory(LDAPInitialDirContextFactory ldapInitialDirContextFactory) {
        this.ldapInitialContextFactory = ldapInitialDirContextFactory;
    }

    public void setUserNameFormat(String userNameFormat) {
        this.userNameFormat = userNameFormat == null || userNameFormat.length() == 0 ? null : userNameFormat;
    }

    public void setLdapNameResolver(LDAPNameResolver ldapNameResolver) {
        this.ldapNameResolver = ldapNameResolver;
    }

    public void setEscapeCommasInBind(boolean escapeCommasInBind) {
        this.escapeCommasInBind = escapeCommasInBind;
    }

    public void setEscapeCommasInUid(boolean escapeCommasInUid) {
        this.escapeCommasInUid = escapeCommasInUid;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.ldapNameResolver == null && this.userNameFormat == null) {
            throw new IllegalStateException("At least one of ldapNameResolver and userNameFormat must be set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void authenticateImpl(String userName, char[] password) throws AuthenticationException {
        Object[] params;
        String userDN;
        AuthenticationDiagnostic diagnostic = new AuthenticationDiagnostic();
        if (this.userNameFormat == null) {
            userDN = this.ldapNameResolver.resolveDistinguishedName(userName, diagnostic);
            params = new Object[]{userName, userDN};
            diagnostic.addStep("authentication.step.ldap.lookedup", true, params);
        } else {
            if (!userName.equals(userName.trim())) {
                throw new AuthenticationException("Invalid user ID with leading or trailing whitespace");
            }
            userDN = String.format(this.userNameFormat, LDAPAuthenticationComponentImpl.escapeUserName(userName, this.escapeCommasInBind));
            params = new Object[]{userName, userDN, this.userNameFormat};
            diagnostic.addStep("authentication.step.ldap.format.user", true, params);
        }
        InitialContext ctx = null;
        try {
            ctx = this.ldapInitialContextFactory.getInitialDirContext(userDN, new String(password), diagnostic);
            this.setCurrentUser(LDAPAuthenticationComponentImpl.escapeUserName(userName, this.escapeCommasInUid));
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    this.clearCurrentSecurityContext();
                    throw new AuthenticationException("Failed to close connection", (Throwable)e);
                }
            }
        }
    }

    private static String escapeUserName(String userName, boolean escape) {
        if (escape) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < userName.length(); ++i) {
                char c = userName.charAt(i);
                if (c == ',') {
                    sb.append('\\');
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return userName;
    }

    @Override
    protected boolean implementationAllowsGuestLogin() {
        return true;
    }

    public void setId(String id) {
        this.id = id;
    }

    String getId() {
        return this.id;
    }
}

