/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ldap;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.alfresco.repo.security.authentication.AuthenticationDiagnostic;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.ldap.LDAPInitialDirContextFactory;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;

public class LDAPInitialDirContextFactoryImpl
implements LDAPInitialDirContextFactory,
InitializingBean {
    private static final Log logger = LogFactory.getLog(LDAPInitialDirContextFactoryImpl.class);
    private static Set<Map<String, String>> checkedEnvs = Collections.synchronizedSet(new HashSet(11));
    private Map<String, String> defaultEnvironment = Collections.emptyMap();
    private Map<String, String> authenticatedEnvironment = Collections.emptyMap();

    @Override
    public void setInitialDirContextEnvironment(Map<String, String> initialDirContextEnvironment) {
        this.authenticatedEnvironment = initialDirContextEnvironment;
    }

    public Map<String, String> getInitialDirContextEnvironment() {
        return this.authenticatedEnvironment;
    }

    public void setDefaultIntialDirContextEnvironment(Map<String, String> defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    @Override
    public InitialDirContext getDefaultIntialDirContext() throws AuthenticationException {
        return this.getDefaultIntialDirContext(0, new AuthenticationDiagnostic());
    }

    @Override
    public InitialDirContext getDefaultIntialDirContext(int pageSize) throws AuthenticationException {
        return this.getDefaultIntialDirContext(pageSize, new AuthenticationDiagnostic());
    }

    @Override
    public InitialDirContext getDefaultIntialDirContext(AuthenticationDiagnostic diagnostic) throws AuthenticationException {
        return this.getDefaultIntialDirContext(0, diagnostic);
    }

    @Override
    public InitialDirContext getDefaultIntialDirContext(int pageSize, AuthenticationDiagnostic diagnostic) throws AuthenticationException {
        Hashtable<String, String> env = new Hashtable<String, String>(this.defaultEnvironment.size());
        env.putAll(this.defaultEnvironment);
        return this.buildInitialDirContext(env, pageSize, diagnostic);
    }

    private InitialDirContext buildInitialDirContext(Hashtable<String, String> env, int pageSize, AuthenticationDiagnostic diagnostic) throws AuthenticationException {
        String securityPrincipal = env.get("java.naming.security.principal");
        String providerURL = env.get("java.naming.provider.url");
        if (diagnostic == null) {
            diagnostic = new AuthenticationDiagnostic();
        }
        try {
            if (pageSize > 0) {
                InitialLdapContext ctx = new InitialLdapContext(env, null);
                ctx.setRequestControls(new Control[]{new PagedResultsControl(pageSize, true)});
                return ctx;
            }
            InitialDirContext ret = new InitialDirContext(env);
            Object[] args = new Object[]{providerURL, securityPrincipal};
            diagnostic.addStep("authentication.step.ldap.connected", true, args);
            return ret;
        }
        catch (javax.naming.AuthenticationException ax) {
            Object[] args1 = new Object[]{securityPrincipal};
            Object[] args = new Object[]{providerURL, securityPrincipal};
            diagnostic.addStep("authentication.step.ldap.connected", true, args);
            diagnostic.addStep("authentication.step.ldap.authentication", false, args1);
            Object[] args2 = new Object[]{securityPrincipal, ax.getLocalizedMessage()};
            throw new AuthenticationException("authentication.err.authentication", diagnostic, args2, (Throwable)ax);
        }
        catch (CommunicationException ce) {
            Throwable cause;
            Object[] args1 = new Object[]{providerURL};
            diagnostic.addStep("authentication.step.ldap.connecting", false, args1);
            StringBuffer message = new StringBuffer();
            message.append(ce.getClass().getName() + ", " + ce.getMessage());
            for (cause = ce.getCause(); cause != null; cause = cause.getCause()) {
                message.append(", ");
                message.append(cause.getClass().getName() + ", " + cause.getMessage());
            }
            Object[] args = new Object[]{providerURL, message.toString()};
            throw new AuthenticationException("authentication.err.communication", diagnostic, args, cause);
        }
        catch (NamingException nx) {
            Object[] args = new Object[]{providerURL};
            diagnostic.addStep("authentication.step.ldap.connecting", false, args);
            StringBuffer message = new StringBuffer();
            message.append(nx.getClass().getName() + ", " + nx.getMessage());
            for (Throwable cause = nx.getCause(); cause != null; cause = cause.getCause()) {
                message.append(", ");
                message.append(cause.getClass().getName() + ", " + cause.getMessage());
            }
            Object[] args1 = new Object[]{providerURL, message.toString()};
            throw new AuthenticationException("authentication.err.connection", diagnostic, args1, (Throwable)nx);
        }
        catch (IOException e) {
            Object[] args = new Object[]{providerURL, securityPrincipal};
            diagnostic.addStep("authentication.step.ldap.connected", true, args);
            throw new AuthenticationException("Unable to encode LDAP v3 request controls", (Throwable)e);
        }
    }

    @Override
    public boolean hasNextPage(DirContext ctx, int pageSize) {
        if (pageSize > 0) {
            try {
                LdapContext ldapContext = (LdapContext)ctx;
                Control[] controls = ldapContext.getResponseControls();
                if (controls != null) {
                    for (Control control : controls) {
                        byte[] cookie;
                        if (!(control instanceof PagedResultsResponseControl) || (cookie = ((PagedResultsResponseControl)control).getCookie()) == null) continue;
                        ldapContext.setRequestControls(new Control[]{new PagedResultsControl(pageSize, cookie, true)});
                        return true;
                    }
                }
            }
            catch (NamingException nx) {
                throw new AuthenticationException("Unable to connect to LDAP Server; check LDAP configuration", (Throwable)nx);
            }
            catch (IOException e) {
                throw new AuthenticationException("Unable to encode LDAP v3 request controls; check LDAP configuration", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public InitialDirContext getInitialDirContext(String principal, String credentials) throws AuthenticationException {
        return this.getInitialDirContext(principal, credentials, null);
    }

    @Override
    public InitialDirContext getInitialDirContext(String principal, String credentials, AuthenticationDiagnostic diagnostic) throws AuthenticationException {
        if (diagnostic == null) {
            diagnostic = new AuthenticationDiagnostic();
        }
        if (principal == null) {
            diagnostic.addStep("authentication.step.ldap.validation", false, null);
            throw new AuthenticationException("Null user name provided.", diagnostic);
        }
        if (principal.length() == 0) {
            diagnostic.addStep("authentication.step.ldap.validation", false, null);
            throw new AuthenticationException("Empty user name provided.", diagnostic);
        }
        if (credentials == null) {
            diagnostic.addStep("authentication.step.ldap.validation", false, null);
            throw new AuthenticationException("No credentials provided.", diagnostic);
        }
        if (credentials.length() == 0) {
            diagnostic.addStep("authentication.step.ldap.validation", false, null);
            throw new AuthenticationException("Empty credentials provided.", diagnostic);
        }
        diagnostic.addStep("authentication.step.ldap.validation", true, null);
        Hashtable<String, String> env = new Hashtable<String, String>(this.authenticatedEnvironment.size());
        env.putAll(this.authenticatedEnvironment);
        env.put("java.naming.security.principal", principal);
        env.put("java.naming.security.credentials", credentials);
        return this.buildInitialDirContext(env, 0, diagnostic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int userMembers = Integer.parseInt(args[3]);
        ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
        LDAPInitialDirContextFactory factory = (LDAPInitialDirContextFactory)applicationContext.getBean("ldapInitialDirContextFactory");
        InitialContext ctx = null;
        try {
            ctx = factory.getInitialDirContext("cn=" + args[0] + "," + args[2], args[1]);
            BasicAttribute objClasses = new BasicAttribute("objectclass");
            objClasses.add("top");
            objClasses.add("person");
            objClasses.add("organizationalPerson");
            objClasses.add("inetOrgPerson");
            for (int i = 0; i < userMembers; ++i) {
                BasicAttribute cn = new BasicAttribute("cn", "User" + i + " TestUser");
                BasicAttribute sn = new BasicAttribute("sn", "TestUser");
                BasicAttribute givenNames = new BasicAttribute("givenName", "User" + i);
                BasicAttribute telephoneNumber = new BasicAttribute("telephoneNumber", "123");
                BasicAttribute uid = new BasicAttribute("uid", "User" + i);
                BasicAttribute mail = new BasicAttribute("mail", "woof@woof");
                BasicAttribute o = new BasicAttribute("o", "Alfresco");
                BasicAttribute userPassword = new BasicAttribute("userPassword", "bobbins");
                String dn = "cn=User" + i + " TestUser," + args[2];
                BasicAttributes orig = new BasicAttributes();
                orig.put(objClasses);
                orig.put(cn);
                orig.put(sn);
                orig.put(givenNames);
                orig.put(telephoneNumber);
                orig.put(uid);
                orig.put(mail);
                orig.put(o);
                orig.put(userPassword);
                try {
                    ctx.destroySubcontext(dn);
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
                ((InitialDirContext)ctx).createSubcontext(dn, orig);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        logger.debug((Object)"after Properties Set");
        Hashtable<String, String> env = new Hashtable<String, String>(this.authenticatedEnvironment.size());
        env.putAll(this.authenticatedEnvironment);
        env.remove("java.naming.security.principal");
        env.remove("java.naming.security.credentials");
        try {
            new InitialDirContext(env);
            logger.warn((Object)("LDAP server supports anonymous bind " + (String)env.get("java.naming.provider.url")));
        }
        catch (javax.naming.AuthenticationException ax) {
        }
        catch (AuthenticationNotSupportedException e) {
        }
        catch (NamingException nx) {
            logger.error((Object)"Unable to connect to LDAP Server; check LDAP configuration", (Throwable)nx);
            return;
        }
        env = new Hashtable(this.authenticatedEnvironment.size());
        env.putAll(this.authenticatedEnvironment);
        env.put("java.naming.security.principal", "daftAsABrush");
        env.put("java.naming.security.credentials", "daftAsABrush");
        try {
            new InitialDirContext(env);
            throw new AuthenticationException("The ldap server at " + (String)env.get("java.naming.provider.url") + " falls back to use anonymous bind if invalid security credentials are presented. This is not supported.");
        }
        catch (javax.naming.AuthenticationException ax) {
            logger.info((Object)("LDAP server does not fall back to anonymous bind for a string uid and password at " + (String)env.get("java.naming.provider.url")));
        }
        catch (AuthenticationNotSupportedException e) {
            logger.info((Object)("LDAP server does not fall back to anonymous bind for a string uid and password at " + (String)env.get("java.naming.provider.url")));
        }
        catch (NamingException nx) {
            logger.info((Object)("LDAP server does not support simple string user ids and invalid credentials at " + (String)env.get("java.naming.provider.url")));
        }
        env = new Hashtable(this.authenticatedEnvironment.size());
        env.putAll(this.authenticatedEnvironment);
        env.put("java.naming.security.principal", "cn=daftAsABrush,dc=woof");
        env.put("java.naming.security.credentials", "daftAsABrush");
        try {
            new InitialDirContext(env);
            throw new AuthenticationException("The ldap server at " + (String)env.get("java.naming.provider.url") + " falls back to use anonymous bind if invalid security credentials are presented. This is not supported.");
        }
        catch (javax.naming.AuthenticationException ax) {
            logger.info((Object)("LDAP server does not fall back to anonymous bind for a simple dn and password at " + (String)env.get("java.naming.provider.url")));
        }
        catch (AuthenticationNotSupportedException e) {
            logger.info((Object)("LDAP server does not fall back to anonymous bind for a simple dn and password at " + (String)env.get("java.naming.provider.url")));
        }
        catch (NamingException nx) {
            logger.info((Object)("LDAP server does not support simple DN and invalid password at " + (String)env.get("java.naming.provider.url")));
        }
        String principal = this.defaultEnvironment.get("java.naming.security.principal");
        if (principal != null) {
            env = new Hashtable(this.authenticatedEnvironment.size());
            env.putAll(this.authenticatedEnvironment);
            env.put("java.naming.security.principal", principal);
            env.put("java.naming.security.credentials", "sdasdasdasdasd123123123");
            if (!checkedEnvs.contains(env)) {
                try {
                    new InitialDirContext(env);
                    throw new AuthenticationException("The ldap server at " + (String)env.get("java.naming.provider.url") + " falls back to use anonymous bind for a known principal if  invalid security credentials are presented. This is not supported.");
                }
                catch (javax.naming.AuthenticationException ax) {
                    logger.info((Object)("LDAP server does not fall back to anonymous bind for known principal and invalid credentials at " + (String)env.get("java.naming.provider.url")));
                }
                catch (AuthenticationNotSupportedException e) {
                    logger.info((Object)"LDAP server does not support the required authentication mechanism");
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                checkedEnvs.add(env);
            }
        }
    }

    static {
        System.setProperty("javax.security.auth.useSubjectCredentialsOnly", "false");
    }
}

