/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ldap;

import java.util.Date;
import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationStep;
import org.alfresco.repo.security.authentication.ldap.LDAPAuthenticationComponentImpl;
import org.alfresco.repo.security.sync.ChainingUserRegistrySynchronizerStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Monitor {
    LDAPAuthenticationComponentImpl component;
    ChainingUserRegistrySynchronizerStatus syncMonitor;
    String id;
    private static Log logger = LogFactory.getLog(Monitor.class);

    public void setLDAPAuthenticationComponent(LDAPAuthenticationComponentImpl component) {
        this.component = component;
    }

    public void setChainingUserRegistrySynchronizerStatus(ChainingUserRegistrySynchronizerStatus syncStatus) {
        this.syncMonitor = syncStatus;
    }

    public CompositeData testAuthenticate(String userName, String credentials) {
        String[] stepKeys = new String[]{"id", "stepMessage", "success"};
        String[] stepDescriptions = new String[]{"id", "stepMessage", "success"};
        OpenType[] stepTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.BOOLEAN};
        try {
            String[] key = new String[]{"id"};
            CompositeType sType = new CompositeType("Authentication Step", "Step", stepKeys, stepDescriptions, stepTypes);
            TabularType tType = new TabularType("Diagnostic", "Authentication Steps", sType, key);
            TabularDataSupport table = new TabularDataSupport(tType);
            String[] attributeKeys = new String[]{"authenticationMessage", "success", "diagnostic"};
            String[] attributeDescriptions = new String[]{"authenticationMessage", "success", "diagnostic"};
            OpenType[] attributeTypes = new OpenType[]{SimpleType.STRING, SimpleType.BOOLEAN, tType};
            try {
                this.component.authenticate(userName, credentials.toCharArray());
                CompositeType cType = new CompositeType("Authentication Result", "Result Success", attributeKeys, attributeDescriptions, attributeTypes);
                HashMap<String, Object> value = new HashMap<String, Object>();
                value.put("authenticationMessage", "Test Passed");
                value.put("success", true);
                value.put("diagnostic", table);
                CompositeDataSupport row = new CompositeDataSupport(cType, value);
                return row;
            }
            catch (AuthenticationException ae) {
                CompositeType cType = new CompositeType("Authentication Result", "Result Failed", attributeKeys, attributeDescriptions, attributeTypes);
                HashMap<String, Object> value = new HashMap<String, Object>();
                value.put("authenticationMessage", ae.getMessage());
                value.put("success", false);
                if (ae.getDiagnostic() != null) {
                    int i = 0;
                    for (AuthenticationStep step : ae.getDiagnostic().getSteps()) {
                        HashMap<String, Object> x = new HashMap<String, Object>();
                        x.put("id", i++);
                        x.put("stepMessage", step.getMessage());
                        x.put("success", step.isSuccess());
                        CompositeDataSupport row = new CompositeDataSupport(sType, x);
                        table.put(row);
                    }
                }
                value.put("diagnostic", table);
                CompositeDataSupport row = new CompositeDataSupport(cType, value);
                return row;
            }
        }
        catch (OpenDataException oe) {
            logger.error((Object)"", (Throwable)oe);
            return null;
        }
    }

    public int getNumberFailedAuthentications() {
        return this.component.getNumberFailedAuthentications();
    }

    public int getNumberSuccessfulAuthentications() {
        return this.component.getNumberSuccessfulAuthentications();
    }

    public String getSynchronizationStatus() {
        return this.syncMonitor.getSynchronizationStatus(this.getZone(this.component.getId()));
    }

    public String getSynchronizationLastError() {
        return this.syncMonitor.getSynchronizationLastError(this.getZone(this.component.getId()));
    }

    public String getSynchronizationSummary() {
        return this.syncMonitor.getSynchronizationSummary(this.getZone(this.component.getId()));
    }

    public String getLastRunOnServer() {
        return this.syncMonitor.getLastRunOnServer();
    }

    public Date getSyncStartTime() {
        return this.syncMonitor.getSyncStartTime();
    }

    public Date getSyncEndTime() {
        return this.syncMonitor.getSyncEndTime();
    }

    private String getZone(String id) {
        String s = id.replace("[", "");
        String s2 = s.replace("]", "");
        String[] ids = s2.split(",");
        String x = ids[ids.length - 1].trim();
        return x;
    }
}

