/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ntlm;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.auth.PassthruServerFactory;
import org.alfresco.jlan.server.auth.PasswordEncryptor;
import org.alfresco.jlan.server.auth.passthru.AuthSessionFactory;
import org.alfresco.jlan.server.auth.passthru.AuthenticateSession;
import org.alfresco.jlan.server.auth.passthru.PassthruServers;
import org.alfresco.jlan.smb.Protocol;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.alfresco.repo.security.authentication.ntlm.NLTMAuthenticator;
import org.alfresco.repo.security.authentication.ntlm.NTLMChallenge;
import org.alfresco.repo.security.authentication.ntlm.NTLMLocalToken;
import org.alfresco.repo.security.authentication.ntlm.NTLMPassthruToken;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class NTLMAuthenticationComponentImpl
extends AbstractAuthenticationComponent
implements NLTMAuthenticator,
InitializingBean {
    private static final Log logger = LogFactory.getLog(NTLMAuthenticationComponentImpl.class);
    public static final String NTLMAuthorityGuest = "Guest";
    public static final String NTLMAuthorityAdministrator = "Administrator";
    private static final long DefaultSessionTimeout = 60000L;
    private static final long MinimumSessionTimeout = 5000L;
    private PassthruServerFactory m_passthruServerFactory = new PassthruServerFactory();
    private PassthruServers m_passthruServers;
    private PasswordEncryptor m_encryptor = new PasswordEncryptor();
    private boolean m_allowGuest;
    private boolean m_allowAuthUserAsGuest;
    private Hashtable<NTLMPassthruToken, AuthenticateSession> m_passthruSessions = new Hashtable();
    private long m_passthruSessTmo = 60000L;
    private PassthruReaperThread m_reaperThread = new PassthruReaperThread();
    private boolean m_nullDomainUseAnyServer;

    public void afterPropertiesSet() throws Exception {
        if (this.m_passthruServers == null) {
            this.m_passthruServerFactory.afterPropertiesSet();
            this.m_passthruServers = (PassthruServers)this.m_passthruServerFactory.getObject();
        }
    }

    public final boolean allowsGuest() {
        return this.m_allowGuest;
    }

    public void setPassthruServers(PassthruServers servers) {
        this.m_passthruServers = servers;
    }

    public void setDomain(String domain) {
        if (domain.length() > 0) {
            this.m_passthruServerFactory.setDomain(domain);
        }
    }

    public void setServers(String servers) {
        if (servers.length() > 0) {
            this.m_passthruServerFactory.setServer(servers);
        }
    }

    public void setUseLocalServer(String useLocal) {
        this.m_passthruServerFactory.setLocalServer(Boolean.parseBoolean(useLocal));
    }

    public void setGuestAccess(String guest) {
        this.m_allowGuest = Boolean.parseBoolean(guest);
    }

    public void setAllowAuthUserAsGuest(String auth) {
        this.m_allowAuthUserAsGuest = Boolean.parseBoolean(auth);
    }

    public void setNullDomainUseAnyServer(String nullDomain) {
        this.m_nullDomainUseAnyServer = Boolean.parseBoolean(nullDomain);
        this.m_passthruServers.setNullDomainUseAnyServer(this.m_nullDomainUseAnyServer);
    }

    public void setJCEProvider(String providerClass) {
        block5: {
            try {
                Object jceObj = Class.forName(providerClass).newInstance();
                if (jceObj instanceof Provider) {
                    Provider jceProvider = (Provider)jceObj;
                    Security.addProvider(jceProvider);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using JCE provider " + providerClass));
                    }
                    break block5;
                }
                throw new AlfrescoRuntimeException("JCE provider class is not a valid Provider class:" + providerClass);
            }
            catch (ClassNotFoundException ex) {
                throw new AlfrescoRuntimeException("JCE provider class " + providerClass + " not found");
            }
            catch (Exception ex) {
                throw new AlfrescoRuntimeException("JCE provider class error", (Throwable)ex);
            }
        }
    }

    public void setSessionTimeout(String sessTmo) {
        try {
            long sessTmoMilli = Long.parseLong(sessTmo) * 1000L;
            if (sessTmoMilli < 5000L) {
                throw new AlfrescoRuntimeException("Authentication session timeout too low, " + sessTmo);
            }
            this.m_passthruSessTmo = sessTmoMilli;
            this.m_reaperThread.setWakeup(sessTmoMilli / 2L);
        }
        catch (NumberFormatException ex) {
            throw new AlfrescoRuntimeException("Invalid authenication session timeout value");
        }
    }

    public void setProtocolOrder(String protoOrder) {
        StringTokenizer tokens = new StringTokenizer(protoOrder, ",");
        int primaryProto = -1;
        int secondaryProto = -1;
        if (tokens.countTokens() > 2) {
            throw new AlfrescoRuntimeException("Invalid protocol order list, " + protoOrder);
        }
        if (tokens.hasMoreTokens()) {
            String primaryStr = tokens.nextToken();
            if (primaryStr.equalsIgnoreCase("TCPIP")) {
                primaryProto = 2;
            } else if (primaryStr.equalsIgnoreCase("NetBIOS")) {
                primaryProto = 1;
            } else {
                throw new AlfrescoRuntimeException("Invalid protocol type, " + primaryStr);
            }
            if (tokens.hasMoreTokens()) {
                String secondaryStr = tokens.nextToken();
                if (secondaryStr.equalsIgnoreCase("TCPIP") && primaryProto != 2) {
                    secondaryProto = 2;
                } else if (secondaryStr.equalsIgnoreCase("NetBIOS") && primaryProto != 1) {
                    secondaryProto = 1;
                } else {
                    throw new AlfrescoRuntimeException("Invalid secondary protocol, " + secondaryStr);
                }
            }
        }
        AuthSessionFactory.setProtocolOrder((int)primaryProto, (int)secondaryProto);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Protocol order primary=" + Protocol.asString((int)primaryProto) + ", secondary=" + Protocol.asString((int)secondaryProto)));
        }
    }

    private final long getSessionTimeout() {
        return this.m_passthruSessTmo;
    }

    @Override
    protected void authenticateImpl(String userName, char[] password) throws AuthenticationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authenticate user=" + userName + " via local credentials"));
        }
        NTLMLocalToken authToken = new NTLMLocalToken(userName, new String(password));
        this.authenticate((Authentication)authToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Authentication authenticate(Authentication auth) throws AuthenticationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authenticate " + auth + " via token"));
        }
        if (auth instanceof NTLMPassthruToken) {
            NTLMPassthruToken ntlmToken = (NTLMPassthruToken)auth;
            this.authenticatePassthru(ntlmToken);
        } else {
            if (auth instanceof NTLMLocalToken) {
                AuthenticateSession authSess = null;
                try {
                    NTLMLocalToken ntlmToken = (NTLMLocalToken)auth;
                    authSess = this.m_passthruServers.openSession();
                    if (authSess == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Failed to open passthru session, or no valid passthru server available for " + (Object)((Object)ntlmToken)));
                        }
                        throw new AuthenticationException("authentication.err.connection.passthru.server");
                    }
                    this.authenticateLocal(ntlmToken, authSess);
                }
                finally {
                    if (authSess != null) {
                        try {
                            authSess.CloseSession();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            throw new AuthenticationException("authentication.err.passthru.token.unsupported");
        }
        return this.getCurrentAuthentication();
    }

    @Override
    public NTLMMode getNTLMMode() {
        return NTLMMode.PASS_THROUGH;
    }

    @Override
    public String getMD4HashedPassword(String userName) {
        throw new AlfrescoRuntimeException("MD4 passwords not supported");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void authenticateLocal(NTLMLocalToken ntlmToken, AuthenticateSession authSess) {
        try {
            String username = (String)ntlmToken.getPrincipal();
            String plainPwd = (String)ntlmToken.getCredentials();
            byte[] ntlm1Pwd = this.m_encryptor.generateEncryptedPassword(plainPwd, authSess.getEncryptionKey(), 1, null, null);
            authSess.doSessionSetup(username, null, ntlm1Pwd);
            if (authSess.isGuest() || username.equalsIgnoreCase("GUEST")) {
                if (!this.allowsGuest()) throw new AuthenticationException("authentication.err.passthru.guest.notenabled");
                GrantedAuthority[] authorities = new GrantedAuthority[]{new GrantedAuthorityImpl(NTLMAuthorityGuest), new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
                ntlmToken.setAuthorities(authorities);
            } else {
                GrantedAuthority[] authorities = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
                ntlmToken.setAuthorities(authorities);
            }
            ntlmToken.setAuthenticated(true);
            this.clearCurrentSecurityContext();
            this.setCurrentUser(username);
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)("Authenticated token=" + (Object)((Object)ntlmToken)));
            return;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException("JCE provider error", (Throwable)ex);
        }
        catch (InvalidKeyException ex) {
            throw new AuthenticationException("Invalid key error", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new AuthenticationException("I/O error", (Throwable)ex);
        }
        catch (SMBException ex) {
            if (ex.getErrorClass() != 6) throw new AuthenticationException("Logon failure");
            AuthenticationException authEx = null;
            switch (ex.getErrorCode()) {
                case -1073741715: {
                    authEx = new AuthenticationException("Logon failure");
                    throw authEx;
                }
                case -1073741710: {
                    authEx = new AuthenticationException("authentication.err.passthru.user.disabled");
                    throw authEx;
                }
                default: {
                    authEx = new AuthenticationException("Logon failure");
                }
            }
            throw authEx;
        }
    }

    private void authenticatePassthru(NTLMPassthruToken ntlmToken) {
        block34: {
            AuthenticateSession authSess = this.m_passthruSessions.get((Object)ntlmToken);
            if (authSess == null) {
                if (ntlmToken.getChallenge() != null) {
                    throw new AuthenticationException("Authentication session expired");
                }
                authSess = this.m_passthruServers.openSession(false, ntlmToken.getClientDomain());
                if (authSess == null) {
                    throw new AuthenticationException("authentication.err.connection.passthru.server");
                }
                ntlmToken.setAuthenticationExpireTime(System.currentTimeMillis() + this.getSessionTimeout());
                ntlmToken.setChallenge(new NTLMChallenge(authSess.getEncryptionKey()));
                StringBuilder details = new StringBuilder();
                details.append(authSess.getDomain());
                details.append("\\");
                details.append(authSess.getPCShare().getNodeName());
                details.append(",");
                details.append(authSess.getSession().getProtocolName());
                ntlmToken.setDetails(details.toString());
                this.m_passthruSessions.put(ntlmToken, authSess);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Passthru stage 1 token " + (Object)((Object)ntlmToken)));
                }
            } else {
                try {
                    byte[] lmPwd = null;
                    byte[] ntlmPwd = null;
                    if (ntlmToken.getPasswordType() == 0) {
                        lmPwd = ntlmToken.getHashedPassword();
                    } else if (ntlmToken.getPasswordType() == 1) {
                        ntlmPwd = ntlmToken.getHashedPassword();
                    }
                    String username = (String)ntlmToken.getPrincipal();
                    authSess.doSessionSetup(username, lmPwd, ntlmPwd);
                    if (authSess.isGuest() || username.equalsIgnoreCase("GUEST")) {
                        if (this.allowsGuest()) {
                            GrantedAuthority[] authorities = new GrantedAuthority[]{new GrantedAuthorityImpl(NTLMAuthorityGuest)};
                            ntlmToken.setAuthorities(authorities);
                        } else {
                            throw new AuthenticationException("authentication.err.passthru.guest.notenabled");
                        }
                    }
                    ntlmToken.setAuthenticated(true);
                    RetryingTransactionHelper helper = this.getTransactionService().getRetryingTransactionHelper();
                    final String currentUser = username;
                    helper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws AuthenticationException {
                            NTLMAuthenticationComponentImpl.this.clearCurrentSecurityContext();
                            NTLMAuthenticationComponentImpl.this.setCurrentUser(currentUser);
                            return null;
                        }
                    });
                }
                catch (NoSuchPersonException ex) {
                    if (this.m_allowAuthUserAsGuest) {
                        GrantedAuthority[] authorities = new GrantedAuthority[]{new GrantedAuthorityImpl(NTLMAuthorityGuest)};
                        ntlmToken.setAuthorities(authorities);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Allow passthru authenticated user to logon as guest, user=" + ntlmToken.getName()));
                        }
                        break block34;
                    }
                    throw new AuthenticationException("authentication.err.passthru.user.notfound", (Throwable)((Object)ex));
                }
                catch (IOException ex) {
                    throw new AuthenticationException("Unable to connect to the authentication server", (Throwable)ex);
                }
                catch (SMBException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Passthru exception, " + (Object)((Object)ex)));
                    }
                    if (ex.getErrorClass() == 6) {
                        AuthenticationException authEx = null;
                        switch (ex.getErrorCode()) {
                            case -1073741715: {
                                authEx = new AuthenticationException("Logon failure");
                                break;
                            }
                            case -1073741710: {
                                authEx = new AuthenticationException("authentication.err.passthru.user.disabled");
                                break;
                            }
                            default: {
                                authEx = new AuthenticationException("Logon failure");
                            }
                        }
                        throw authEx;
                    }
                    throw new AuthenticationException("Logon failure");
                }
                finally {
                    if (authSess != null) {
                        try {
                            this.m_passthruSessions.remove((Object)ntlmToken);
                            authSess.CloseSession();
                        }
                        catch (Exception ex) {
                            logger.debug((Object)"unable to close session", (Throwable)ex);
                        }
                    }
                }
            }
        }
    }

    public boolean exists(String userName) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean implementationAllowsGuestLogin() {
        return this.allowsGuest();
    }

    class PassthruReaperThread
    extends Thread {
        private boolean m_ishutdown;
        private long m_wakeupInterval;

        PassthruReaperThread() {
            this.m_wakeupInterval = NTLMAuthenticationComponentImpl.this.m_passthruSessTmo / 2L;
            this.setDaemon(true);
            this.setName("PassthruReaper");
            this.start();
        }

        public final void setWakeup(long wakeup) {
            this.m_wakeupInterval = wakeup;
        }

        @Override
        public void run() {
            this.m_ishutdown = false;
            while (!this.m_ishutdown) {
                try {
                    PassthruReaperThread.sleep(this.m_wakeupInterval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (NTLMAuthenticationComponentImpl.this.m_passthruSessions.size() <= 0) continue;
                Enumeration tokenEnum = NTLMAuthenticationComponentImpl.this.m_passthruSessions.keys();
                long timeNow = System.currentTimeMillis();
                while (tokenEnum.hasMoreElements()) {
                    NTLMPassthruToken ntlmToken;
                    block8: {
                        ntlmToken = (NTLMPassthruToken)((Object)tokenEnum.nextElement());
                        if (ntlmToken == null || ntlmToken.getAuthenticationExpireTime() >= timeNow) continue;
                        AuthenticateSession authSess = (AuthenticateSession)NTLMAuthenticationComponentImpl.this.m_passthruSessions.get((Object)ntlmToken);
                        if (authSess != null) {
                            try {
                                authSess.CloseSession();
                            }
                            catch (Exception ex) {
                                if (!logger.isDebugEnabled()) break block8;
                                logger.debug((Object)"Error closing expired authentication session", (Throwable)ex);
                            }
                        }
                    }
                    NTLMAuthenticationComponentImpl.this.m_passthruSessions.remove((Object)ntlmToken);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Removed expired NTLM token " + (Object)((Object)ntlmToken)));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Passthru reaper thread shutdown");
            }
        }

        public final void shutdownRequest() {
            this.m_ishutdown = true;
            this.interrupt();
        }
    }
}

