/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.model.ContentModel;
import org.alfresco.query.AbstractCannedQuery;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.repo.site.SiteMembersCannedQueryParams;
import org.alfresco.repo.site.SiteMembership;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteRole;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.Pair;

public class SiteMembersCannedQuery
extends AbstractCannedQuery<SiteMembership> {
    private NodeService nodeService;
    private PersonService personService;
    private SiteService siteService;

    protected SiteMembersCannedQuery(SiteService siteService, PersonService personService, NodeService nodeService, CannedQueryParameters parameters) {
        super(parameters);
        this.personService = personService;
        this.nodeService = nodeService;
        this.siteService = siteService;
    }

    protected List<SiteMembership> queryAndFilter(CannedQueryParameters parameters) {
        SiteMembersCannedQueryParams paramBean = (SiteMembersCannedQueryParams)parameters.getParameterBean();
        String siteShortName = paramBean.getShortName();
        boolean collapseGroups = paramBean.isCollapseGroups();
        CannedQuerySortDetails sortDetails = parameters.getSortDetails();
        List sortPairs = sortDetails.getSortPairs();
        CQSiteMembersCallback callback = new CQSiteMembersCallback(siteShortName, sortPairs);
        this.siteService.listMembers(siteShortName, null, null, collapseGroups, callback);
        callback.done();
        return callback.getSiteMembers();
    }

    protected boolean isApplyPostQuerySorting() {
        return false;
    }

    private static class SiteMembershipComparator
    implements Comparator<SiteMembership> {
        private List<Pair<? extends Object, CannedQuerySortDetails.SortOrder>> sortPairs;
        private static Collator collator = Collator.getInstance();

        public SiteMembershipComparator(List<Pair<? extends Object, CannedQuerySortDetails.SortOrder>> sortPairs) {
            if (sortPairs.size() < 1) {
                throw new IllegalArgumentException("Must provide at least one sort criterion");
            }
            this.sortPairs = sortPairs;
        }

        private <T> int safeCompare(Comparable<T> o1, T o2) {
            int ret = 0;
            ret = o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : o1.compareTo(o2));
            return ret;
        }

        private int safeCompare(String s1, String s2) {
            int ret = 0;
            ret = s1 == null ? (s2 == null ? 0 : -1) : (s2 == null ? 1 : collator.compare(s1, s2));
            return ret;
        }

        @Override
        public int compare(SiteMembership o1, SiteMembership o2) {
            String personId1 = o1.getPersonId();
            String personId2 = o2.getPersonId();
            SiteInfo siteInfo1 = o1.getSiteInfo();
            SiteInfo siteInfo2 = o2.getSiteInfo();
            String shortName1 = siteInfo1.getShortName();
            String shortName2 = siteInfo2.getShortName();
            String firstName1 = o1.getFirstName();
            String firstName2 = o2.getFirstName();
            String lastName1 = o1.getLastName();
            String lastName2 = o2.getLastName();
            SiteRole siteRole1 = o1.getRole();
            SiteRole siteRole2 = o2.getRole();
            int personId = this.safeCompare(personId1, personId2);
            int firstName = this.safeCompare(firstName1, firstName2);
            int siteShortName = this.safeCompare(shortName1, shortName2);
            int lastName = this.safeCompare(lastName1, lastName2);
            int siteRole = this.safeCompare((Comparable)((Object)siteRole1), (Object)((Object)siteRole2));
            if (siteRole == 0 && siteShortName == 0 && personId == 0) {
                return 0;
            }
            int ret = 0;
            for (Pair<? extends Object, CannedQuerySortDetails.SortOrder> pair : this.sortPairs) {
                int multiplier;
                Object name = pair.getFirst();
                CannedQuerySortDetails.SortOrder sortOrder = (CannedQuerySortDetails.SortOrder)pair.getSecond();
                int n = multiplier = sortOrder.equals((Object)CannedQuerySortDetails.SortOrder.ASCENDING) ? 1 : -1;
                if (name.equals((Object)SiteService.SortFields.FirstName)) {
                    ret = firstName * multiplier;
                } else if (name.equals((Object)SiteService.SortFields.LastName)) {
                    if (lastName1 == null || lastName2 == null) continue;
                    ret = lastName * multiplier;
                } else if (name.equals((Object)SiteService.SortFields.Role)) {
                    if (siteRole1 == null || siteRole2 == null) continue;
                    ret = siteRole * multiplier;
                } else if (name.equals((Object)SiteService.SortFields.Username)) {
                    if (personId1 == null || personId2 == null) continue;
                    ret = personId * multiplier;
                }
                if (ret == 0) continue;
                break;
            }
            return ret;
        }
    }

    private class CQSiteMembersCallback
    implements SiteService.SiteMembersCallback {
        private String siteShortName;
        private SiteInfo siteInfo;
        private Set<SiteMembership> siteMembers;

        CQSiteMembersCallback(String siteShortName, List<Pair<? extends Object, CannedQuerySortDetails.SortOrder>> sortPairs) {
            this.siteShortName = siteShortName;
            this.siteInfo = SiteMembersCannedQuery.this.siteService.getSite(siteShortName);
            this.siteMembers = sortPairs != null && sortPairs.size() > 0 ? new TreeSet<SiteMembership>(new SiteMembershipComparator(sortPairs)) : new HashSet<SiteMembership>();
        }

        @Override
        public void siteMember(String authority, String permission) {
            String firstName = null;
            String lastName = null;
            if (SiteMembersCannedQuery.this.personService.personExists(authority)) {
                NodeRef nodeRef = SiteMembersCannedQuery.this.personService.getPerson(authority);
                firstName = (String)((Object)SiteMembersCannedQuery.this.nodeService.getProperty(nodeRef, ContentModel.PROP_FIRSTNAME));
                lastName = (String)((Object)SiteMembersCannedQuery.this.nodeService.getProperty(nodeRef, ContentModel.PROP_LASTNAME));
            }
            SiteMembership siteMember = new SiteMembership(this.siteInfo, authority, firstName, lastName, SiteRole.valueOf(permission));
            this.siteMembers.add(siteMember);
        }

        @Override
        public boolean isDone() {
            return false;
        }

        List<SiteMembership> getSiteMembers() {
            ArrayList<SiteMembership> siteMemberships = new ArrayList<SiteMembership>(this.siteMembers.size());
            Iterator<SiteMembership> it = this.siteMembers.iterator();
            while (it.hasNext()) {
                siteMemberships.add(it.next());
                it.remove();
            }
            return siteMemberships;
        }

        void done() {
        }
    }
}

