/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.solr;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.CRC32;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.solr.SOLRDAO;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.solr.Acl;
import org.alfresco.repo.solr.AclChangeSet;
import org.alfresco.repo.solr.AclReaders;
import org.alfresco.repo.solr.AlfrescoModel;
import org.alfresco.repo.solr.AlfrescoModelDiff;
import org.alfresco.repo.solr.MetaDataResultsFilter;
import org.alfresco.repo.solr.NodeMetaData;
import org.alfresco.repo.solr.NodeMetaDataParameters;
import org.alfresco.repo.solr.NodeParameters;
import org.alfresco.repo.solr.SOLRTrackingComponent;
import org.alfresco.repo.solr.Transaction;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;

public class SOLRTrackingComponentImpl
implements SOLRTrackingComponent {
    private NodeDAO nodeDAO;
    private QNameDAO qnameDAO;
    private SOLRDAO solrDAO;
    private DictionaryDAO dictionaryDAO;
    private PermissionService permissionService;
    private AclDAO aclDAO;
    private OwnableService ownableService;
    private TenantService tenantService;
    private DictionaryService dictionaryService;
    private boolean enabled = true;
    private boolean cacheAncestors = true;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCacheAncestors(boolean cacheAncestors) {
        this.cacheAncestors = cacheAncestors;
    }

    public void setSolrDAO(SOLRDAO solrDAO) {
        this.solrDAO = solrDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setAclDAO(AclDAO aclDAO) {
        this.aclDAO = aclDAO;
    }

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"solrDAO", (Object)this.solrDAO);
        PropertyCheck.mandatory((Object)this, (String)"nodeDAO", (Object)this.nodeDAO);
        PropertyCheck.mandatory((Object)this, (String)"qnameDAO", (Object)this.qnameDAO);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"ownableService", (Object)this.ownableService);
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryDAO", (Object)this.dictionaryDAO);
        PropertyCheck.mandatory((Object)this, (String)"aclDAO", (Object)this.aclDAO);
    }

    @Override
    public List<AclChangeSet> getAclChangeSets(Long minAclChangeSetId, Long fromCommitTime, Long maxAclChangeSetId, Long toCommitTime, int maxResults) {
        if (this.enabled) {
            List<AclChangeSet> changesets = this.solrDAO.getAclChangeSets(minAclChangeSetId, fromCommitTime, maxAclChangeSetId, toCommitTime, maxResults);
            return changesets;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Acl> getAcls(List<Long> aclChangeSetIds, Long minAclId, int maxResults) {
        if (this.enabled) {
            List<Acl> acls = this.solrDAO.getAcls(aclChangeSetIds, minAclId, maxResults);
            return acls;
        }
        return Collections.emptyList();
    }

    @Override
    public List<AclReaders> getAclsReaders(List<Long> aclIds) {
        if (this.enabled) {
            this.aclDAO.setCheckAclConsistency();
            HashMap<Long, String> aclChangeSetTenant = new HashMap<Long, String>(aclIds.size());
            ArrayList<AclReaders> aclsReaders = new ArrayList<AclReaders>(aclIds.size() * 10);
            for (Long aclId : aclIds) {
                Set readersSet = this.permissionService.getReaders(aclId);
                AclReaders readers = new AclReaders();
                readers.setAclId(aclId);
                readers.setReaders(readersSet);
                Long aclChangeSetId = this.aclDAO.getAccessControlList(aclId).getProperties().getAclChangeSetId();
                readers.setAclChangeSetId(aclChangeSetId);
                if (AuthenticationUtil.isMtEnabled()) {
                    String tenantDomain = (String)aclChangeSetTenant.get(aclChangeSetId);
                    if (tenantDomain == null) {
                        tenantDomain = this.getTenant(aclId, aclChangeSetId);
                        if (tenantDomain == null) continue;
                        aclChangeSetTenant.put(aclChangeSetId, tenantDomain);
                    }
                    readers.setTenantDomain(tenantDomain);
                }
                aclsReaders.add(readers);
            }
            return aclsReaders;
        }
        return Collections.emptyList();
    }

    private String getTenant(long aclId, long aclChangeSetId) {
        String tenantDomain = this.getAclTenant(aclId);
        if (tenantDomain == null) {
            Acl acl;
            ArrayList<Long> aclChangeSetIds = new ArrayList<Long>(1);
            aclChangeSetIds.add(aclChangeSetId);
            List<Acl> acls = this.solrDAO.getAcls(aclChangeSetIds, null, 1024);
            Iterator<Acl> i$ = acls.iterator();
            while (i$.hasNext() && (tenantDomain = this.getAclTenant((acl = i$.next()).getId())) == null) {
            }
            if (tenantDomain == null) {
                tenantDomain = null;
            }
        }
        return tenantDomain;
    }

    private String getAclTenant(long aclId) {
        List<Long> nodeIds = this.aclDAO.getADMNodesByAcl(aclId, 1);
        if (nodeIds.size() == 0) {
            return null;
        }
        this.nodeDAO.setCheckNodeConsistency();
        Pair<Long, NodeRef> nodePair = this.nodeDAO.getNodePair(nodeIds.get(0));
        if (nodePair == null) {
            return null;
        }
        return this.tenantService.getDomain(((NodeRef)nodePair.getSecond()).getStoreRef().getIdentifier());
    }

    @Override
    public List<Transaction> getTransactions(Long minTxnId, Long fromCommitTime, Long maxTxnId, Long toCommitTime, int maxResults) {
        if (this.enabled) {
            List<Transaction> txns = this.solrDAO.getTransactions(minTxnId, fromCommitTime, maxTxnId, toCommitTime, maxResults);
            return txns;
        }
        return Collections.emptyList();
    }

    @Override
    public void getNodes(NodeParameters nodeParameters, SOLRTrackingComponent.NodeQueryCallback callback) {
        if (this.enabled) {
            List<Node> nodes = this.solrDAO.getNodes(nodeParameters);
            for (Node node : nodes) {
                callback.handleNode(node);
            }
        }
    }

    private boolean isCategorised(AspectDefinition aspDef) {
        if (aspDef == null) {
            return false;
        }
        AspectDefinition current = aspDef;
        while (current != null) {
            if (current.getName().equals((Object)ContentModel.ASPECT_CLASSIFIABLE)) {
                return true;
            }
            QName parentName = current.getParentName();
            if (parentName == null) break;
            current = this.dictionaryService.getAspect(parentName);
        }
        return false;
    }

    private CategoryPaths getCategoryPaths(NodeRef nodeRef, Set<QName> aspects, Map<QName, Serializable> properties) {
        ArrayList<Pair<Path, QName>> categoryPaths = new ArrayList<Pair<Path, QName>>();
        ArrayList<ChildAssociationRef> categoryParents = new ArrayList<ChildAssociationRef>();
        this.nodeDAO.setCheckNodeConsistency();
        for (QName qName : aspects) {
            AspectDefinition aspDef = this.dictionaryService.getAspect(qName);
            if (!this.isCategorised(aspDef)) continue;
            LinkedList<Pair> aspectPaths = new LinkedList<Pair>();
            for (PropertyDefinition propDef : aspDef.getProperties().values()) {
                Serializable propVal;
                if (!propDef.getDataType().getName().equals((Object)DataTypeDefinition.CATEGORY) || (propVal = properties.get(propDef.getName())) == null) continue;
                for (NodeRef catRef : DefaultTypeConverter.INSTANCE.getCollection(NodeRef.class, (Object)propVal)) {
                    if (catRef == null) continue;
                    catRef = this.tenantService.getName(nodeRef, catRef);
                    try {
                        Pair<Long, NodeRef> pair = this.nodeDAO.getNodePair(catRef);
                        if (pair == null) continue;
                        for (Path path : this.nodeDAO.getPaths(pair, false)) {
                            aspectPaths.add(new Pair((Object)path, (Object)aspDef.getName()));
                        }
                    }
                    catch (InvalidNodeRefException e) {
                    }
                }
            }
            categoryPaths.addAll(aspectPaths);
        }
        for (Pair pair : categoryPaths) {
            if (!(((Path)pair.getFirst()).last() instanceof Path.ChildAssocElement)) continue;
            Path.ChildAssocElement cae = (Path.ChildAssocElement)((Path)pair.getFirst()).last();
            ChildAssociationRef assocRef = cae.getRef();
            ChildAssociationRef categoryParentRef = new ChildAssociationRef(assocRef.getTypeQName(), assocRef.getChildRef(), QName.createQName((String)"member"), nodeRef);
            ((Path)pair.getFirst()).append((Path.Element)new Path.ChildAssocElement(categoryParentRef));
            categoryParents.add(categoryParentRef);
        }
        return new CategoryPaths(categoryPaths, categoryParents);
    }

    private List<Long> preCacheNodes(NodeMetaDataParameters nodeMetaDataParameters) {
        int maxResults = nodeMetaDataParameters.getMaxResults();
        boolean isLimitSet = maxResults != 0 && maxResults != Integer.MAX_VALUE;
        List<Long> nodeIds = null;
        Iterable<Long> iterable = null;
        List<Long> allNodeIds = nodeMetaDataParameters.getNodeIds();
        if (allNodeIds != null) {
            int toIndex = maxResults > allNodeIds.size() ? allNodeIds.size() : maxResults;
            nodeIds = isLimitSet ? allNodeIds.subList(0, toIndex) : nodeMetaDataParameters.getNodeIds();
            iterable = nodeMetaDataParameters.getNodeIds();
        } else {
            Long fromNodeId = nodeMetaDataParameters.getFromNodeId();
            Long toNodeId = nodeMetaDataParameters.getToNodeId();
            nodeIds = new ArrayList<Long>(isLimitSet ? maxResults : 100);
            iterable = new SequenceIterator(fromNodeId, toNodeId, maxResults);
            int counter = 1;
            for (Long nodeId : iterable) {
                if (isLimitSet && counter++ > maxResults) break;
                nodeIds.add(nodeId);
            }
        }
        List<Long> ancestors = this.cacheAncestors ? this.cacheAncestors(nodeIds) : nodeIds;
        this.nodeDAO.setCheckNodeConsistency();
        this.nodeDAO.cacheNodesById(ancestors);
        return nodeIds;
    }

    private List<Long> cacheAncestors(List<Long> nodeIds) {
        Long nodeId;
        final LinkedList<Long> toVisit = new LinkedList<Long>(nodeIds);
        TreeSet<Long> visited = new TreeSet<Long>();
        this.nodeDAO.cacheNodesById(toVisit);
        Long lastCached = toVisit.peekLast();
        while ((nodeId = toVisit.pollFirst()) != null) {
            if (visited.add(nodeId) && this.nodeDAO.getNodeIdStatus(nodeId) != null && !this.nodeDAO.getNodeIdStatus(nodeId).isDeleted()) {
                this.nodeDAO.getParentAssocs(nodeId, null, null, null, new NodeDAO.ChildAssocRefQueryCallback(){

                    @Override
                    public boolean preLoadNodes() {
                        return false;
                    }

                    @Override
                    public boolean orderResults() {
                        return false;
                    }

                    @Override
                    public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                        toVisit.add(parentNodePair.getFirst());
                        return true;
                    }

                    @Override
                    public void done() {
                    }
                });
            }
            if (nodeId != lastCached || toVisit.isEmpty()) continue;
            this.nodeDAO.cacheNodesById(toVisit);
            lastCached = toVisit.peekLast();
        }
        return new ArrayList<Long>(visited);
    }

    protected Map<QName, Serializable> getProperties(Long nodeId) {
        HashMap<QName, Serializable> props = null;
        this.nodeDAO.setCheckNodeConsistency();
        Map<QName, Serializable> sourceProps = this.nodeDAO.getNodeProperties(nodeId);
        props = new HashMap<QName, Serializable>((int)((double)sourceProps.size() * 1.3));
        for (QName propertyQName : sourceProps.keySet()) {
            PropertyDefinition propDef = this.dictionaryService.getProperty(propertyQName);
            if (propDef == null) continue;
            props.put(propertyQName, sourceProps.get(propertyQName));
        }
        return props;
    }

    @Override
    public void getNodesMetadata(NodeMetaDataParameters nodeMetaDataParameters, MetaDataResultsFilter resultFilter, SOLRTrackingComponent.NodeMetaDataQueryCallback callback) {
        if (!this.enabled) {
            return;
        }
        NodeMetaDataQueryRowHandler rowHandler = new NodeMetaDataQueryRowHandler(callback);
        boolean includeType = resultFilter == null ? true : resultFilter.getIncludeType();
        boolean includeProperties = resultFilter == null ? true : resultFilter.getIncludeProperties();
        boolean includeAspects = resultFilter == null ? true : resultFilter.getIncludeAspects();
        boolean includePaths = resultFilter == null ? true : resultFilter.getIncludePaths();
        boolean includeNodeRef = resultFilter == null ? true : resultFilter.getIncludeNodeRef();
        boolean includeParentAssociations = resultFilter == null ? true : resultFilter.getIncludeParentAssociations();
        boolean includeChildAssociations = resultFilter == null ? true : resultFilter.getIncludeChildAssociations();
        boolean includeOwner = resultFilter == null ? true : resultFilter.getIncludeOwner();
        boolean includeChildIds = resultFilter == null ? true : resultFilter.getIncludeChildIds();
        boolean includeTxnId = resultFilter == null ? true : resultFilter.getIncludeTxnId();
        List<Long> nodeIds = this.preCacheNodes(nodeMetaDataParameters);
        for (Long nodeId : nodeIds) {
            NodeRef.Status status = this.nodeDAO.getNodeIdStatus(nodeId);
            if (status == null) continue;
            NodeRef nodeRef = status.getNodeRef();
            NodeMetaData nodeMetaData = new NodeMetaData();
            nodeMetaData.setNodeId(nodeId);
            if (includeNodeRef) {
                nodeMetaData.setNodeRef(this.tenantService.getBaseName(nodeRef, true));
            }
            if (includeTxnId) {
                nodeMetaData.setTxnId(status.getDbTxnId());
            }
            if (status.isDeleted()) {
                rowHandler.processResult(nodeMetaData);
                continue;
            }
            Map<QName, Serializable> props = null;
            HashSet<QName> aspects = null;
            nodeMetaData.setAclId(this.nodeDAO.getNodeAclId(nodeId));
            if (includeType) {
                QName nodeType = this.nodeDAO.getNodeType(nodeId);
                TypeDefinition type = this.dictionaryService.getType(nodeType);
                if (type != null) {
                    nodeMetaData.setNodeType(nodeType);
                } else {
                    throw new AlfrescoRuntimeException("Nodes with no type are ignored by SOLR");
                }
            }
            if (includeProperties) {
                if (props == null) {
                    props = this.getProperties(nodeId);
                }
                nodeMetaData.setProperties(props);
            } else {
                nodeMetaData.setProperties(Collections.emptyMap());
            }
            if (includeAspects || includePaths || includeParentAssociations) {
                aspects = new HashSet<QName>();
                Set<QName> sourceAspects = this.nodeDAO.getNodeAspects(nodeId);
                for (QName aspectQName : sourceAspects) {
                    AspectDefinition aspect = this.dictionaryService.getAspect(aspectQName);
                    if (aspect == null) continue;
                    aspects.add(aspectQName);
                }
            }
            nodeMetaData.setAspects(aspects);
            CategoryPaths categoryPaths = new CategoryPaths(new ArrayList<Pair<Path, QName>>(), new ArrayList<ChildAssociationRef>());
            if (includePaths || includeParentAssociations) {
                if (props == null) {
                    props = this.getProperties(nodeId);
                }
                categoryPaths = this.getCategoryPaths(status.getNodeRef(), aspects, props);
            }
            if (includePaths) {
                if (props == null) {
                    props = this.getProperties(nodeId);
                }
                List<Path> directPaths = this.nodeDAO.getPaths((Pair<Long, NodeRef>)new Pair((Object)nodeId, (Object)status.getNodeRef()), false);
                ArrayList<Pair<Path, QName>> paths = new ArrayList<Pair<Path, QName>>(directPaths.size() + categoryPaths.getPaths().size());
                for (Path path : directPaths) {
                    paths.add((Pair<Path, QName>)new Pair((Object)path.getBaseNamePath(this.tenantService), null));
                }
                for (Pair pair : categoryPaths.getPaths()) {
                    paths.add((Pair<Path, QName>)new Pair((Object)((Path)pair.getFirst()).getBaseNamePath(this.tenantService), pair.getSecond()));
                }
                nodeMetaData.setPaths(paths);
            }
            nodeMetaData.setTenantDomain(this.tenantService.getDomain(nodeRef.getStoreRef().getIdentifier()));
            if (includeChildAssociations) {
                final ArrayList<ChildAssociationRef> childAssocs = new ArrayList<ChildAssociationRef>(100);
                this.nodeDAO.getChildAssocs(nodeId, null, null, null, null, null, new NodeDAO.ChildAssocRefQueryCallback(){

                    @Override
                    public boolean preLoadNodes() {
                        return false;
                    }

                    @Override
                    public boolean orderResults() {
                        return false;
                    }

                    @Override
                    public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                        childAssocs.add(SOLRTrackingComponentImpl.this.tenantService.getBaseName((ChildAssociationRef)childAssocPair.getSecond(), true));
                        return true;
                    }

                    @Override
                    public void done() {
                    }
                });
                nodeMetaData.setChildAssocs(childAssocs);
            }
            if (includeChildIds) {
                final ArrayList<Long> childIds = new ArrayList<Long>(100);
                this.nodeDAO.getChildAssocs(nodeId, null, null, null, null, null, new NodeDAO.ChildAssocRefQueryCallback(){

                    @Override
                    public boolean preLoadNodes() {
                        return false;
                    }

                    @Override
                    public boolean orderResults() {
                        return false;
                    }

                    @Override
                    public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                        childIds.add(childNodePair.getFirst());
                        return true;
                    }

                    @Override
                    public void done() {
                    }
                });
                nodeMetaData.setChildIds(childIds);
            }
            if (includeParentAssociations) {
                final ArrayList<ChildAssociationRef> parentAssocs = new ArrayList<ChildAssociationRef>(100);
                this.nodeDAO.getParentAssocs(nodeId, null, null, null, new NodeDAO.ChildAssocRefQueryCallback(){

                    @Override
                    public boolean preLoadNodes() {
                        return false;
                    }

                    @Override
                    public boolean orderResults() {
                        return false;
                    }

                    @Override
                    public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                        parentAssocs.add(SOLRTrackingComponentImpl.this.tenantService.getBaseName((ChildAssociationRef)childAssocPair.getSecond(), true));
                        return true;
                    }

                    @Override
                    public void done() {
                    }
                });
                for (ChildAssociationRef ref : categoryPaths.getCategoryParents()) {
                    parentAssocs.add(this.tenantService.getBaseName(ref, true));
                }
                CRC32 crc = new CRC32();
                for (ChildAssociationRef childAssociationRef : parentAssocs) {
                    try {
                        crc.update(childAssociationRef.toString().getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("UTF-8 encoding is not supported");
                    }
                }
                nodeMetaData.setParentAssocs(parentAssocs, crc.getValue());
            }
            if (includeOwner) {
                nodeMetaData.setOwner(this.ownableService.getOwner(status.getNodeRef()));
            }
            rowHandler.processResult(nodeMetaData);
        }
    }

    @Override
    public AlfrescoModel getModel(QName modelName) {
        if (this.enabled) {
            ModelDefinition modelDef = this.dictionaryService.getModel(modelName);
            return modelDef != null ? new AlfrescoModel(modelDef) : null;
        }
        return null;
    }

    @Override
    public List<AlfrescoModelDiff> getModelDiffs(Map<QName, Long> models) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        ArrayList<AlfrescoModelDiff> diffs = new ArrayList<AlfrescoModelDiff>();
        Collection allModels = this.dictionaryService.getAllModels();
        for (QName modelName : models.keySet()) {
            if (allModels.contains(modelName)) {
                Long checksum = models.get(modelName);
                AlfrescoModel serverModel = this.getModel(modelName);
                if (serverModel.getChecksum() == checksum.longValue()) continue;
                diffs.add(new AlfrescoModelDiff(modelName, AlfrescoModelDiff.TYPE.CHANGED, checksum, (Long)serverModel.getChecksum()));
                continue;
            }
            diffs.add(new AlfrescoModelDiff(modelName, AlfrescoModelDiff.TYPE.REMOVED, null, null));
        }
        for (QName modelName : allModels) {
            if (models.containsKey(modelName)) continue;
            AlfrescoModel model = this.getModel(modelName);
            diffs.add(new AlfrescoModelDiff(modelName, AlfrescoModelDiff.TYPE.NEW, null, (Long)model.getChecksum()));
        }
        return diffs;
    }

    @Override
    public Long getMaxTxnCommitTime() {
        this.nodeDAO.setCheckNodeConsistency();
        return this.nodeDAO.getMaxTxnCommitTime();
    }

    @Override
    public Long getMaxTxnId() {
        long maxCommitTime = System.currentTimeMillis() + 1L;
        this.nodeDAO.setCheckNodeConsistency();
        return this.nodeDAO.getMaxTxnIdByCommitTime(maxCommitTime);
    }

    @Override
    public Long getMaxChangeSetCommitTime() {
        return this.aclDAO.getMaxChangeSetCommitTime();
    }

    @Override
    public Long getMaxChangeSetId() {
        long maxCommitTime = System.currentTimeMillis() + 1L;
        return this.aclDAO.getMaxChangeSetIdByCommitTime(maxCommitTime);
    }

    protected class NodeMetaDataQueryRowHandler {
        private final SOLRTrackingComponent.NodeMetaDataQueryCallback callback;
        private boolean more;

        private NodeMetaDataQueryRowHandler(SOLRTrackingComponent.NodeMetaDataQueryCallback callback) {
            this.callback = callback;
            this.more = true;
        }

        public void processResult(NodeMetaData row) {
            if (!this.more) {
                return;
            }
            this.more = this.callback.handleNodeMetaData(row);
        }
    }

    protected class NodeQueryRowHandler {
        private final SOLRTrackingComponent.NodeQueryCallback callback;
        private boolean more;

        private NodeQueryRowHandler(SOLRTrackingComponent.NodeQueryCallback callback) {
            this.callback = callback;
            this.more = true;
        }

        public void processResult(Node row) {
            if (!this.more) {
                return;
            }
            this.more = this.callback.handleNode(row);
        }
    }

    static class CategoryPaths {
        Collection<Pair<Path, QName>> paths;
        List<ChildAssociationRef> categoryParents;

        CategoryPaths(Collection<Pair<Path, QName>> paths, List<ChildAssociationRef> categoryParents) {
            this.paths = paths;
            this.categoryParents = categoryParents;
        }

        public Collection<Pair<Path, QName>> getPaths() {
            return this.paths;
        }

        public List<ChildAssociationRef> getCategoryParents() {
            return this.categoryParents;
        }
    }

    private static class SequenceIterator
    implements Iterable<Long>,
    Iterator<Long> {
        private long fromId;
        private long toId;
        private long counter;
        private int maxResults;
        private boolean inUse = false;

        SequenceIterator(Long fromId, Long toId, int maxResults) {
            this.fromId = fromId == null ? 1L : fromId;
            this.toId = toId == null ? Long.MAX_VALUE : toId;
            this.maxResults = maxResults;
            this.counter = this.fromId;
        }

        @Override
        public Iterator<Long> iterator() {
            if (this.inUse) {
                throw new IllegalStateException("Already in use");
            }
            this.counter = this.fromId;
            this.inUse = true;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.counter - this.fromId < (long)this.maxResults && this.counter <= this.toId;
        }

        @Override
        public Long next() {
            return this.counter++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

