/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging.script;

import java.util.List;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

public class ScriptTaggingService
extends BaseScopableProcessorExtension {
    private ServiceRegistry serviceRegistry;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public String[] getTags(String store) {
        StoreRef storeRef = new StoreRef(store);
        List<String> result = this.serviceRegistry.getTaggingService().getTags(storeRef);
        return result.toArray(new String[result.size()]);
    }

    public String[] getTags(String store, String filter) {
        StoreRef storeRef = new StoreRef(store);
        List<String> result = this.serviceRegistry.getTaggingService().getTags(storeRef, filter);
        return result.toArray(new String[result.size()]);
    }

    public ScriptNode getTag(String store, String tag) {
        StoreRef storeRef = new StoreRef(store);
        NodeRef result = this.serviceRegistry.getTaggingService().getTagNodeRef(storeRef, tag);
        if (result != null) {
            return new ScriptNode(result, this.serviceRegistry, this.getScope());
        }
        return null;
    }

    public ScriptNode createTag(String store, String tag) {
        StoreRef storeRef = new StoreRef(store);
        NodeRef result = this.serviceRegistry.getTaggingService().createTag(storeRef, tag);
        if (result != null) {
            return new ScriptNode(result, this.serviceRegistry);
        }
        return null;
    }

    public void deleteTag(String store, String tag) {
        StoreRef storeRef = new StoreRef(store);
        this.serviceRegistry.getTaggingService().deleteTag(storeRef, tag);
    }
}

