/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.template.AVMTemplateNode;
import org.alfresco.repo.template.AVMTemplateStore;
import org.alfresco.repo.template.BaseTemplateProcessorExtension;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.wcm.util.WCMUtil;
import org.springframework.extensions.surf.util.ParameterCheck;

public class AVM
extends BaseTemplateProcessorExtension {
    private ServiceRegistry services;

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
    }

    public List<AVMTemplateStore> getStores() {
        List<AVMStoreDescriptor> stores = this.services.getAVMService().getStores();
        ArrayList<AVMTemplateStore> results = new ArrayList<AVMTemplateStore>(stores.size());
        for (AVMStoreDescriptor store : stores) {
            results.add(new AVMTemplateStore(this.services, this.getTemplateImageResolver(), store));
        }
        return results;
    }

    public AVMTemplateStore lookupStore(String store) {
        ParameterCheck.mandatoryString((String)"Store", (String)store);
        AVMTemplateStore avmStore = null;
        AVMStoreDescriptor descriptor = this.services.getAVMService().getStore(store);
        if (descriptor != null) {
            avmStore = new AVMTemplateStore(this.services, this.getTemplateImageResolver(), descriptor);
        }
        return avmStore;
    }

    public AVMTemplateNode lookupStoreRoot(String store) {
        ParameterCheck.mandatoryString((String)"Store", (String)store);
        AVMTemplateNode root = null;
        AVMTemplateStore avmStore = this.lookupStore(store);
        if (avmStore != null) {
            root = avmStore.getLookupRoot();
        }
        return root;
    }

    public AVMTemplateNode lookupNode(String path) {
        ParameterCheck.mandatoryString((String)"AVM Path", (String)path);
        AVMTemplateNode node = null;
        AVMNodeDescriptor nodeDesc = this.services.getAVMService().lookup(-1, path);
        if (nodeDesc != null) {
            node = new AVMTemplateNode(path, -1, this.services, this.getTemplateImageResolver());
        }
        return node;
    }

    public List<AVMTemplateNode> getModifiedItems(String storeId, String username, String webapp) {
        ParameterCheck.mandatoryString((String)"Store ID", (String)storeId);
        ParameterCheck.mandatoryString((String)"Username", (String)username);
        ParameterCheck.mandatoryString((String)"Webapp", (String)webapp);
        SandboxService sbService = this.services.getSandboxService();
        String userStoreId = AVM.userSandboxStore(storeId, username);
        List<AssetInfo> assets = sbService.listChangedWebApp(userStoreId, webapp, false);
        ArrayList<AVMTemplateNode> items = new ArrayList<AVMTemplateNode>(assets.size());
        for (AssetInfo asset : assets) {
            items.add(new AVMTemplateNode(asset.getAvmPath(), -1, this.services, this.getTemplateImageResolver()));
        }
        return items;
    }

    public static String stagingStore(String storeId) {
        return WCMUtil.buildStagingStoreName(storeId);
    }

    public static String userSandboxStore(String storeId, String username) {
        return WCMUtil.buildUserMainStoreName(storeId, username);
    }

    public String websiteStagingUrl(String storeId) {
        return this.services.getPreviewURIService().getPreviewURI(storeId, null);
    }

    public String websiteUserSandboxUrl(String storeId, String username) {
        ParameterCheck.mandatoryString((String)"Store ID", (String)storeId);
        ParameterCheck.mandatoryString((String)"Username", (String)username);
        return this.websiteStagingUrl(AVM.userSandboxStore(storeId, username));
    }

    public String assetUrl(String storeId, String assetPath) {
        return this.services.getPreviewURIService().getPreviewURI(storeId, assetPath);
    }

    public String assetUrl(String avmPath) {
        ParameterCheck.mandatoryString((String)"AVM Path", (String)avmPath);
        String[] s = avmPath.split(":");
        if (s.length != 2) {
            throw new IllegalArgumentException("Expected exactly one ':' in " + avmPath);
        }
        return this.assetUrl(s[0], s[1]);
    }

    public static String getWebappsFolderPath() {
        return "/www/avm_webapps";
    }
}

