/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.alfresco.repo.template.BaseTemplateMap;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;

public abstract class BaseSearchResultsMap
extends BaseTemplateMap {
    public BaseSearchResultsMap(TemplateNode parent, ServiceRegistry services) {
        super(parent, services);
    }

    protected List<TemplateNode> query(String search) {
        List<TemplateNode> nodes = null;
        HashSet<NodeRef> nodeRefs = new HashSet<NodeRef>();
        if (search != null && search.length() != 0) {
            try (ResultSet results = null;){
                results = this.services.getSearchService().query(this.parent.getNodeRef().getStoreRef(), "lucene", search);
                if (results.length() != 0) {
                    NodeService nodeService = this.services.getNodeService();
                    nodes = new ArrayList<TemplateNode>(results.length());
                    for (ResultSetRow row : results) {
                        NodeRef nodeRef = row.getNodeRef();
                        if (nodeRefs.contains(nodeRef) || !nodeService.exists(nodeRef)) continue;
                        nodes.add(new TemplateNode(nodeRef, this.services, this.parent.getImageResolver()));
                        nodeRefs.add(nodeRef);
                    }
                }
            }
        }
        return nodes != null ? nodes : Collections.emptyList();
    }
}

