/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.content.AbstractRoutingContentStore;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.domain.tenant.TenantAdminDAO;
import org.alfresco.repo.domain.tenant.TenantEntity;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantRoutingContentStore;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractTenantRoutingContentStore
extends AbstractRoutingContentStore
implements ApplicationContextAware,
TenantRoutingContentStore {
    private static Log logger = LogFactory.getLog(AbstractTenantRoutingContentStore.class);
    private String defaultRootDirectory;
    private TenantAdminDAO tenantAdminDAO;
    protected TenantService tenantService;
    private ApplicationContext applicationContext;
    private final ReentrantReadWriteLock tenantContentStoreLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock tenantContentStoreWriteLock = this.tenantContentStoreLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock tenantContentStoreReadLock = this.tenantContentStoreLock.readLock();
    private SimpleCache<String, ContentStore> singletonCache;
    private final String KEY_CONTENT_STORE = "key.tenant.routing.content.store";

    public void setRootLocation(String defaultRootDirectory) {
        this.defaultRootDirectory = defaultRootDirectory;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setTenantAdminDAO(TenantAdminDAO tenantAdminDAO) {
        this.tenantAdminDAO = tenantAdminDAO;
    }

    public void setSingletonCache(SimpleCache<String, ContentStore> singletonCache) {
        this.singletonCache = singletonCache;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public String getRootLocation() {
        return this.defaultRootDirectory;
    }

    @Override
    protected ContentStore selectWriteStore(ContentContext ctx) {
        return this.getTenantContentStore();
    }

    @Override
    public List<ContentStore> getAllStores() {
        String currentUser;
        final ArrayList<ContentStore> allEnabledStores = new ArrayList<ContentStore>();
        if (this.tenantService.isEnabled() && ((currentUser = AuthenticationUtil.getFullyAuthenticatedUser()) == null || this.tenantService.getBaseNameUser(currentUser).equals(AuthenticationUtil.getSystemUserName()))) {
            List<TenantEntity> tenants = this.tenantAdminDAO.listTenants(false);
            for (TenantEntity tenant : tenants) {
                if (!tenant.getEnabled().booleanValue()) continue;
                String tenantDomain = tenant.getTenantDomain();
                TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        allEnabledStores.add(AbstractTenantRoutingContentStore.this.getTenantContentStore());
                        return null;
                    }
                }, (String)tenantDomain);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getAllStores called without tenant ctx (" + tenants.size() + " tenants)"));
            }
        }
        allEnabledStores.add(this.getTenantContentStore());
        return allEnabledStores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentStore getTenantContentStore() {
        ContentStore cs = null;
        this.tenantContentStoreReadLock.lock();
        try {
            cs = this.getTenantContentStoreImpl();
        }
        finally {
            this.tenantContentStoreReadLock.unlock();
        }
        if (cs == null) {
            AbstractTenantRoutingContentStore abstractTenantRoutingContentStore = this;
            synchronized (abstractTenantRoutingContentStore) {
                cs = this.getTenantContentStoreImpl();
                if (cs == null) {
                    this.init();
                    cs = this.getTenantContentStoreImpl();
                }
            }
        }
        return cs;
    }

    private ContentStore getTenantContentStoreImpl() {
        return (ContentStore)this.singletonCache.get((Serializable)((Object)"key.tenant.routing.content.store"));
    }

    private void putTenantContentStoreImpl(ContentStore contentStore) {
        this.singletonCache.put((Serializable)((Object)"key.tenant.routing.content.store"), (Object)contentStore);
    }

    private void removeTenantContentStoreImpl() {
        this.singletonCache.remove((Serializable)((Object)"key.tenant.routing.content.store"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.tenantContentStoreWriteLock.lock();
        try {
            String rootDir = this.getRootLocation();
            Tenant tenant = this.tenantService.getTenant(this.tenantService.getCurrentUserDomain());
            if (tenant != null && tenant.getRootContentStoreDir() != null) {
                rootDir = tenant.getRootContentStoreDir();
            }
            this.putTenantContentStoreImpl(this.initContentStore(this.applicationContext, rootDir));
        }
        finally {
            this.tenantContentStoreWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.tenantContentStoreWriteLock.lock();
        try {
            this.removeTenantContentStoreImpl();
        }
        finally {
            this.tenantContentStoreWriteLock.unlock();
        }
    }

    public void onEnableTenant() {
        this.init();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    @Override
    public long getSpaceFree() {
        ContentStore x = this.getTenantContentStore();
        if (x != null) {
            return x.getSpaceFree();
        }
        return -1L;
    }

    @Override
    public long getSpaceTotal() {
        ContentStore x = this.getTenantContentStore();
        if (x != null) {
            return x.getSpaceTotal();
        }
        return -1L;
    }

    protected abstract ContentStore initContentStore(ApplicationContext var1, String var2);
}

