/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import org.alfresco.repo.admin.BaseInterpreter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.extensions.surf.util.I18NUtil;

public class TenantInterpreter
extends BaseInterpreter
implements ApplicationContextAware,
InitializingBean {
    private static Log logger = LogFactory.getLog(TenantInterpreter.class);
    private ApplicationContext ctx;
    private TenantAdminService tenantAdminService;
    protected TenantService tenantService;
    private MutableAuthenticationService authenticationService;
    private String baseAdminUsername = null;
    private static final String WARN_MSG = "system.mt.warn.upgrade_mt_admin_context";

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setBaseAdminUsername(String baseAdminUsername) {
        this.baseAdminUsername = baseAdminUsername;
    }

    public String getBaseAdminUsername() {
        if (this.baseAdminUsername != null) {
            return this.baseAdminUsername;
        }
        return AuthenticationUtil.getAdminUserName();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }

    public static void main(String[] args) {
        TenantInterpreter.runMain("tenantInterpreter");
    }

    public void afterPropertiesSet() throws Exception {
        if (this.authorityService == null || this.baseAdminUsername == null) {
            logger.warn((Object)I18NUtil.getMessage((String)WARN_MSG));
        }
        if (this.authorityService == null) {
            this.authorityService = (AuthorityService)this.ctx.getBean("AuthorityService");
        }
        PropertyCheck.mandatory((Object)((Object)this), (String)"TransactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"TenantService", (Object)this.tenantService);
    }

    @Override
    protected boolean hasAuthority(String username) {
        return username != null && this.authorityService.isAdminAuthority(username) && !this.tenantService.isTenantUser(username);
    }

    @Override
    public String interpretCommand(final String line) throws IOException {
        String currentUserName = this.getCurrentUserName();
        if (this.hasAuthority(currentUserName)) {
            AuthenticationUtil.RunAsWork<String> executeWork = new AuthenticationUtil.RunAsWork<String>(){

                public String doWork() throws Exception {
                    RetryingTransactionHelper.RetryingTransactionCallback<String> txnWork = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                        @Override
                        public String execute() throws Exception {
                            return TenantInterpreter.this.executeCommand(line);
                        }
                    };
                    RetryingTransactionHelper txnHelper = TenantInterpreter.this.transactionService.getRetryingTransactionHelper();
                    txnHelper.setMaxRetries(1);
                    return txnHelper.doInTransaction(txnWork);
                }
            };
            return (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)executeWork, (String)"System");
        }
        return "Error: User '" + currentUserName + "' not authorised";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String executeCommand(String line) throws IOException {
        String newTenant;
        String tenantDomain;
        String[] command = line.split(" ");
        if (command.length == 0) {
            command = new String[]{line};
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bout);
        if (command[0].equals("r")) {
            if (this.lastCommand != null) return "repeating command " + this.lastCommand + "\n\n" + this.executeCommand(this.lastCommand);
            return "No command entered yet.";
        }
        this.lastCommand = line;
        if (command[0].equals("help")) {
            String helpFile = I18NUtil.getMessage((String)"tenant_console.help");
            ClassPathResource helpResource = new ClassPathResource(helpFile);
            byte[] helpBytes = new byte[500];
            try (InputStream helpStream = helpResource.getInputStream();){
                int read = helpStream.read(helpBytes);
                while (read != -1) {
                    bout.write(helpBytes, 0, read);
                    read = helpStream.read(helpBytes);
                }
            }
        } else if (command[0].equals("show")) {
            if (command.length < 2) {
                return "Syntax Error, try 'help'.\n";
            }
            if (command[1].equals("tenants")) {
                String contentRoot;
                List<Tenant> tenants = this.tenantAdminService.getAllTenants();
                for (Tenant tenant : tenants) {
                    if (!tenant.isEnabled()) continue;
                    contentRoot = tenant.getRootContentStoreDir();
                    out.println("Enabled  - Tenant: " + tenant.getTenantDomain() + " (" + contentRoot + ")");
                }
                out.println("");
                for (Tenant tenant : tenants) {
                    if (tenant.isEnabled()) continue;
                    contentRoot = tenant.getRootContentStoreDir();
                    out.println("Disabled - Tenant: " + tenant.getTenantDomain() + " (" + contentRoot + ")");
                }
            } else {
                if (!command[1].equals("tenant")) return "No such sub-command, try 'help'.\n";
                if (command.length != 3) {
                    return "Syntax Error, try 'help'.\n";
                }
                tenantDomain = new String(command[2]).toLowerCase();
                Tenant tenant = this.tenantAdminService.getTenant(tenantDomain);
                String contentRoot = tenant.getRootContentStoreDir();
                if (tenant.isEnabled()) {
                    out.println("Enabled - Tenant: " + tenant.getTenantDomain() + " (" + contentRoot + ")");
                } else {
                    out.println("Disabled - Tenant: " + tenant.getTenantDomain() + " (" + contentRoot + ")");
                }
            }
        } else if (command[0].equals("create")) {
            if (command.length < 3 || command.length > 5) {
                return "Syntax Error, try 'help'.\n";
            }
            newTenant = new String(command[1]).toLowerCase();
            char[] tenantAdminRawPassword = new String(command[2]).toCharArray();
            String contentRoot = null;
            if (command.length >= 4 && "null".equals(contentRoot = new String(command[3]))) {
                contentRoot = null;
            }
            String dbUrl = null;
            if (command.length >= 5 && "null".equals(dbUrl = new String(command[4]))) {
                dbUrl = null;
            }
            this.tenantAdminService.createTenant(newTenant, tenantAdminRawPassword, contentRoot, dbUrl);
            out.println("created tenant: " + newTenant);
        } else if (command[0].equals("import")) {
            if (command.length != 3 && command.length != 4) {
                return "Syntax Error, try 'help'.\n";
            }
            newTenant = new String(command[1]).toLowerCase();
            File directorySource = new File(command[2]);
            String contentRoot = null;
            if (command.length == 4) {
                contentRoot = new String(command[3]);
            }
            this.tenantAdminService.importTenant(newTenant, directorySource, contentRoot);
            out.println("imported tenant: " + newTenant);
        } else if (command[0].equals("export")) {
            if (command.length != 3) {
                return "Syntax Error, try 'help'.\n";
            }
            String tenant = new String(command[1]).toLowerCase();
            File directoryDestination = new File(command[2]);
            this.tenantAdminService.exportTenant(tenant, directoryDestination);
            out.println("exported tenant: " + tenant);
        } else if (command[0].equals("delete")) {
            if (command.length != 2) {
                return "Syntax Error, try 'help'.\n";
            }
            tenantDomain = new String(command[1]).toLowerCase();
            this.tenantAdminService.deleteTenant(tenantDomain);
            out.println("Deleted tenant: " + tenantDomain);
        } else if (command[0].equals("enable")) {
            if (command.length != 2) {
                return "Syntax Error, try 'help'.\n";
            }
            tenantDomain = new String(command[1]).toLowerCase();
            this.tenantAdminService.enableTenant(tenantDomain);
            out.println("Enabled tenant: " + tenantDomain);
        } else if (command[0].equals("disable")) {
            if (command.length != 2) {
                return "Syntax Error, try 'help'.\n";
            }
            tenantDomain = new String(command[1]).toLowerCase();
            this.tenantAdminService.disableTenant(tenantDomain);
            out.println("Disabled tenant: " + tenantDomain);
        } else {
            if (!command[0].equals("changeAdminPassword")) return "No such command, try 'help'.\n";
            if (command.length != 3) {
                return "Syntax Error, try 'help'.\n";
            }
            tenantDomain = new String(command[1]).toLowerCase();
            final String newPassword = new String(command[2]);
            final String tenantAdminUsername = this.tenantService.getDomainUser(this.getBaseAdminUsername(), tenantDomain);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    TenantInterpreter.this.authenticationService.setAuthentication(tenantAdminUsername, newPassword.toCharArray());
                    return null;
                }
            }, (String)tenantAdminUsername);
        }
        out.flush();
        String retVal = new String(bout.toByteArray());
        out.close();
        return retVal;
    }
}

