/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail.conditions;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.evaluator.ActionConditionEvaluatorAbstractBase;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.thumbnail.FailedThumbnailInfo;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeEligibleForRethumbnailingEvaluator
extends ActionConditionEvaluatorAbstractBase {
    private static Log logger = LogFactory.getLog(NodeEligibleForRethumbnailingEvaluator.class);
    public static final String NAME = "node-eligible-for-rethumbnailing-evaluator";
    public static final String PARAM_THUMBNAIL_DEFINITION_NAME = "thumbnail-definition-name";
    public static final String PARAM_RETRY_PERIOD = "retry-period";
    public static final String PARAM_RETRY_COUNT = "retry-count";
    public static final String PARAM_QUIET_PERIOD = "quiet-period";
    public static final String PARAM_QUIET_PERIOD_RETRIES_ENABLED = "quiet-period-retries-enabled";
    protected NodeService nodeService;
    protected ThumbnailService thumbnailService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_THUMBNAIL_DEFINITION_NAME, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_THUMBNAIL_DEFINITION_NAME)));
        paramList.add(new ParameterDefinitionImpl(PARAM_RETRY_PERIOD, DataTypeDefinition.LONG, true, this.getParamDisplayLabel(PARAM_RETRY_PERIOD)));
        paramList.add(new ParameterDefinitionImpl(PARAM_RETRY_COUNT, DataTypeDefinition.INT, true, this.getParamDisplayLabel(PARAM_RETRY_COUNT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_QUIET_PERIOD, DataTypeDefinition.LONG, true, this.getParamDisplayLabel(PARAM_QUIET_PERIOD)));
        paramList.add(new ParameterDefinitionImpl(PARAM_QUIET_PERIOD_RETRIES_ENABLED, DataTypeDefinition.BOOLEAN, true, this.getParamDisplayLabel(PARAM_QUIET_PERIOD_RETRIES_ENABLED)));
    }

    @Override
    public boolean evaluateImpl(ActionCondition actionCondition, NodeRef actionedUponNodeRef) {
        if (!this.nodeService.exists(actionedUponNodeRef)) {
            return false;
        }
        Serializable paramThumbnailDefnName = actionCondition.getParameterValue(PARAM_THUMBNAIL_DEFINITION_NAME);
        Serializable paramRetryPeriod = actionCondition.getParameterValue(PARAM_RETRY_PERIOD);
        Serializable paramRetryCount = actionCondition.getParameterValue(PARAM_RETRY_COUNT);
        Serializable paramQuietPeriod = actionCondition.getParameterValue(PARAM_QUIET_PERIOD);
        Serializable parameterValue = actionCondition.getParameterValue(PARAM_QUIET_PERIOD_RETRIES_ENABLED);
        Serializable paramQuietPeriodRetriesEnabled = parameterValue != null ? parameterValue : Boolean.valueOf(true);
        QName thumbnailDefnQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)((String)((Object)paramThumbnailDefnName)));
        Map<String, FailedThumbnailInfo> failures = this.thumbnailService.getFailedThumbnails(actionedUponNodeRef);
        if (failures.isEmpty() || !failures.containsKey(thumbnailDefnQName.getLocalName())) {
            if (logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Node ").append(actionedUponNodeRef).append(" has no matching ").append(ContentModel.ASSOC_FAILED_THUMBNAIL).append(" child.");
                logger.debug((Object)msg.toString());
            }
            return true;
        }
        FailedThumbnailInfo failedThumbnailInfo = failures.get(thumbnailDefnQName.getLocalName());
        if (failedThumbnailInfo.getMostRecentFailure() == null) {
            return true;
        }
        long nowMs = new Date().getTime();
        long failureTimeMs = failedThumbnailInfo.getMostRecentFailure().getTime();
        long timeSinceLastFailureMs = nowMs - failureTimeMs;
        int failureCount = failedThumbnailInfo.getFailureCount();
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Comparing failure time of ").append(failedThumbnailInfo.getMostRecentFailure()).append(" to now. Difference is ").append(timeSinceLastFailureMs).append(" ms. ").append(failureCount).append(" existing failures.");
            logger.debug((Object)msg.toString());
        }
        if (failureCount >= (Integer)paramRetryCount) {
            boolean quietPeriodRetriesEnabled = (Boolean)paramQuietPeriodRetriesEnabled;
            return quietPeriodRetriesEnabled && this.timeSinceFailureExceedsLimit(paramQuietPeriod, timeSinceLastFailureMs);
        }
        return this.timeSinceFailureExceedsLimit(paramRetryPeriod, timeSinceLastFailureMs);
    }

    private boolean timeSinceFailureExceedsLimit(Serializable failurePeriod, long timeSinceFailure) {
        Long offsetLong = (Long)failurePeriod;
        long absOffset = Math.abs(offsetLong);
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Offset is ").append(offsetLong).append(" ms.");
            logger.debug((Object)msg.toString());
        }
        return timeSinceFailure > absOffset;
    }
}

