/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.util.resource.MethodResourceManager;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class SingleEntryTransactionResourceInterceptor
implements MethodInterceptor {
    private ThreadLocal<Boolean> threadLocalReentryCheck;
    private List<MethodResourceManager> methodResourceManagers;
    private long elapsedTimeBeforeActivationMillis = 10000L;
    private long resourceManagerCallFrequencyMillis = 5000L;
    private volatile long lastCallMillis;
    private String resourceKey = "MethodStats" + super.toString();

    public SingleEntryTransactionResourceInterceptor() {
        this.threadLocalReentryCheck = new ThreadLocal();
    }

    public void setMethodResourceManagers(List<MethodResourceManager> methodResourceManagers) {
        this.methodResourceManagers = methodResourceManagers;
    }

    public void setElapsedTimeBeforeActivationMillis(long elapsedTimeBeforeActivationMillis) {
        this.elapsedTimeBeforeActivationMillis = elapsedTimeBeforeActivationMillis;
    }

    public void setResourceManagerCallFrequencyMillis(long resourceManagerCallFrequencyMillis) {
        this.resourceManagerCallFrequencyMillis = resourceManagerCallFrequencyMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.threadLocalReentryCheck.get() == Boolean.TRUE) {
            return invocation.proceed();
        }
        if (this.methodResourceManagers == null || this.methodResourceManagers.size() == 0) {
            return invocation.proceed();
        }
        try {
            this.threadLocalReentryCheck.set(Boolean.TRUE);
            Object object = this.invokeInternal(invocation);
            return object;
        }
        finally {
            this.threadLocalReentryCheck.set(null);
        }
    }

    private Object invokeInternal(MethodInvocation invocation) throws Throwable {
        MethodResourceManager.MethodStatistics calledMethodStats;
        long txnStartTime = AlfrescoTransactionSupport.getTransactionStartTime();
        if (txnStartTime < 0L) {
            return invocation.proceed();
        }
        long now = System.currentTimeMillis();
        long txnElapsedTime = now - txnStartTime;
        if (txnElapsedTime < this.elapsedTimeBeforeActivationMillis) {
            return invocation.proceed();
        }
        Method calledMethod = invocation.getMethod();
        long beforeNs = System.nanoTime();
        Object ret = invocation.proceed();
        long deltaNs = System.nanoTime() - beforeNs;
        HashMap<Method, MethodResourceManager.MethodStatistics> methodStatsByMethod = (HashMap<Method, MethodResourceManager.MethodStatistics>)AlfrescoTransactionSupport.getResource(this.resourceKey);
        if (methodStatsByMethod == null) {
            methodStatsByMethod = new HashMap<Method, MethodResourceManager.MethodStatistics>(11);
            AlfrescoTransactionSupport.bindResource(this.resourceKey, methodStatsByMethod);
        }
        if ((calledMethodStats = (MethodResourceManager.MethodStatistics)methodStatsByMethod.get(calledMethod)) == null) {
            calledMethodStats = new MethodResourceManager.MethodStatistics();
            methodStatsByMethod.put(calledMethod, calledMethodStats);
        }
        calledMethodStats.accumulateNs(deltaNs);
        if (now - this.lastCallMillis >= this.resourceManagerCallFrequencyMillis) {
            for (MethodResourceManager resourceManager : this.methodResourceManagers) {
                resourceManager.manageResources(methodStatsByMethod, txnElapsedTime, calledMethod);
            }
            this.lastCallMillis = now;
        }
        return ret;
    }

    public void performManualCheck(Method calledMethod, long deltaNs) {
        MethodResourceManager.MethodStatistics calledMethodStats;
        if (this.methodResourceManagers == null || this.methodResourceManagers.size() == 0) {
            return;
        }
        long txnStartTime = AlfrescoTransactionSupport.getTransactionStartTime();
        if (txnStartTime < 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        long txnElapsedTime = now - txnStartTime;
        if (txnElapsedTime < this.elapsedTimeBeforeActivationMillis) {
            return;
        }
        HashMap<Method, MethodResourceManager.MethodStatistics> methodStatsByMethod = (HashMap<Method, MethodResourceManager.MethodStatistics>)AlfrescoTransactionSupport.getResource(this.resourceKey);
        if (methodStatsByMethod == null) {
            methodStatsByMethod = new HashMap<Method, MethodResourceManager.MethodStatistics>(11);
            AlfrescoTransactionSupport.bindResource(this.resourceKey, methodStatsByMethod);
        }
        if ((calledMethodStats = (MethodResourceManager.MethodStatistics)methodStatsByMethod.get(calledMethod)) == null) {
            calledMethodStats = new MethodResourceManager.MethodStatistics();
            methodStatsByMethod.put(calledMethod, calledMethodStats);
        }
        calledMethodStats.accumulateNs(deltaNs);
        if (now - this.lastCallMillis >= this.resourceManagerCallFrequencyMillis) {
            for (MethodResourceManager resourceManager : this.methodResourceManagers) {
                resourceManager.manageResources(methodStatsByMethod, txnElapsedTime, calledMethod);
            }
            this.lastCallMillis = now;
        }
    }
}

