/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.workflow.TaskComponent;
import org.alfresco.repo.workflow.WorkflowComponent;
import org.alfresco.service.cmr.workflow.WorkflowAdminService;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Filter;
import org.alfresco.util.collections.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BPMEngineRegistry {
    private static final String ID_SEPERATOR = "$";
    private static final String ID_SEPERATOR_REGEX = "\\$";
    private static Log logger = LogFactory.getLog((String)"org.alfresco.repo.workflow");
    private WorkflowAdminService workflowAdminService;
    private Map<String, WorkflowComponent> workflowComponents = new HashMap<String, WorkflowComponent>();
    private Map<String, TaskComponent> taskComponents = new HashMap<String, TaskComponent>();

    public void setWorkflowAdminService(WorkflowAdminService workflowAdminService) {
        this.workflowAdminService = workflowAdminService;
    }

    public void registerWorkflowComponent(String engineId, WorkflowComponent engine) {
        if (this.workflowComponents.containsKey(engineId)) {
            throw new WorkflowException("Workflow Component already registered for engine id '" + engineId + "'");
        }
        this.workflowComponents.put(engineId, engine);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered Workflow Component '" + engineId + "' (" + engine.getClass() + ")"));
        }
    }

    public String[] getWorkflowComponents() {
        return this.getComponents(this.workflowComponents.keySet());
    }

    public WorkflowComponent getWorkflowComponent(String engineId) {
        if (!this.workflowAdminService.isEngineEnabled(engineId)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring disabled WorkflowComponent: " + engineId));
            }
            return null;
        }
        return this.workflowComponents.get(engineId);
    }

    public void registerTaskComponent(String engineId, TaskComponent engine) {
        if (this.taskComponents.containsKey(engineId)) {
            throw new WorkflowException("Task Component already registered for engine id '" + engineId + "'");
        }
        this.taskComponents.put(engineId, engine);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered Task Component '" + engineId + "' (" + engine.getClass() + ")"));
        }
    }

    public String[] getTaskComponents() {
        return this.getComponents(this.taskComponents.keySet());
    }

    private String[] getComponents(Set<String> components) {
        List filtered = CollectionUtils.filter(components, (Function)new Filter<String>(){

            public Boolean apply(String engineId) {
                return BPMEngineRegistry.this.workflowAdminService.isEngineEnabled(engineId);
            }
        });
        return filtered.toArray(new String[filtered.size()]);
    }

    public TaskComponent getTaskComponent(String engineId) {
        if (!this.workflowAdminService.isEngineEnabled(engineId)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring disabled TaskComponent: " + engineId));
            }
            return null;
        }
        return this.taskComponents.get(engineId);
    }

    public static String createGlobalId(String engineId, String localId) {
        return engineId + ID_SEPERATOR + localId;
    }

    public static String[] getGlobalIdParts(String globalId) {
        String[] parts = globalId.split(ID_SEPERATOR_REGEX);
        if (parts.length != 2) {
            throw new WorkflowException("Invalid Global Id '" + globalId + "'");
        }
        return parts;
    }

    public static String getEngineId(String globalId) {
        return BPMEngineRegistry.getGlobalIdParts(globalId)[0];
    }

    public static String getLocalId(String globalId) {
        return BPMEngineRegistry.getGlobalIdParts(globalId)[1];
    }

    public static boolean isGlobalId(String globalId, String engineId) {
        return globalId.startsWith(engineId + ID_SEPERATOR);
    }
}

