/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.workflow.NodeConverter;
import org.alfresco.repo.workflow.WorkflowObjectFactory;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

public class WorkflowPropertyConverter {
    public static final Object SKIP = new Object();
    private final WorkflowObjectFactory factory;
    private final NodeConverter converter;

    public WorkflowPropertyConverter(WorkflowObjectFactory factory, NodeConverter converter) {
        this.factory = factory;
        this.converter = converter;
    }

    public Map<String, Object> getStringProperties(TypeDefinition taskDef, Map<QName, Serializable> properties) {
        if (properties == null) {
            return null;
        }
        HashMap<String, Object> results = new HashMap<String, Object>(properties.size());
        Map taskProperties = taskDef.getProperties();
        Map taskAssocs = taskDef.getAssociations();
        for (Map.Entry<QName, Serializable> entry : properties.entrySet()) {
            QName key = entry.getKey();
            Serializable value = entry.getValue();
            Object actualValue = this.getValue(key, value, taskProperties, taskAssocs);
            String name = this.factory.mapQNameToName(key);
            results.put(name, actualValue);
        }
        return results;
    }

    private Object getValue(QName key, Serializable value, Map<QName, PropertyDefinition> taskProperties, Map<QName, AssociationDefinition> taskAssocs) {
        PropertyDefinition propDef = taskProperties.get(key);
        if (propDef != null) {
            return this.getPropertyValue(key, value, propDef);
        }
        AssociationDefinition assocDef = taskAssocs.get(key);
        if (assocDef != null) {
            return this.getAssociation(key, value, assocDef);
        }
        if (value instanceof NodeRef) {
            return this.convertNodeRefs(false, value);
        }
        return value;
    }

    private Object getAssociation(QName key, Serializable value, AssociationDefinition assocDef) {
        return this.convertNodeRefs(assocDef.isTargetMany(), value);
    }

    private Object getPropertyValue(QName key, Serializable value, PropertyDefinition propDef) {
        if (propDef.isProtected()) {
            return SKIP;
        }
        Object result = null;
        DataTypeDefinition dataTypeDef = propDef.getDataType();
        result = value instanceof Collection ? DefaultTypeConverter.INSTANCE.convert(dataTypeDef, (Collection)((Object)value)) : DefaultTypeConverter.INSTANCE.convert(dataTypeDef, (Object)value);
        if (dataTypeDef.getName().equals((Object)DataTypeDefinition.NODE_REF)) {
            result = this.convertNodeRefs(propDef.isMultiValued(), result);
        }
        return result;
    }

    private Object convertNodeRefs(boolean isMany, Object value) {
        if (value instanceof NodeRef) {
            NodeRef node = (NodeRef)value;
            if (isMany) {
                return this.converter.convertNodes(Collections.singletonList(node));
            }
            return this.converter.convertNode(node);
        }
        if (value instanceof Collection) {
            Collection nodes = (Collection)value;
            if (isMany) {
                this.converter.convertNodes(nodes);
            } else {
                NodeRef node = nodes.size() == 0 ? null : (NodeRef)nodes.iterator().next();
                this.converter.convertNode(node);
            }
        }
        return value;
    }
}

