/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.form.StartFormData;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.form.DefaultTaskFormHandler;
import org.activiti.engine.impl.form.TaskFormHandler;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.workflow.WorkflowObjectFactory;
import org.alfresco.repo.workflow.activiti.ActivitiUtil;
import org.alfresco.repo.workflow.activiti.properties.ActivitiPropertyConverter;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.collections.Function;

public class ActivitiTypeConverter {
    private static final String TRANSITION_SUFFIX = ".transition";
    private static final String DEFAULT_TRANSITION_KEY = "bpm_businessprocessmodel.transition";
    private final RuntimeService runtimeService;
    private final FormService formService;
    private final HistoryService historyService;
    private final ActivitiPropertyConverter propertyConverter;
    private final WorkflowObjectFactory factory;
    private final ActivitiUtil activitiUtil;

    public ActivitiTypeConverter(ProcessEngine processEngine, WorkflowObjectFactory factory, ActivitiPropertyConverter propertyConverter, boolean deployWorkflowsInTenant) {
        this.runtimeService = processEngine.getRuntimeService();
        this.formService = processEngine.getFormService();
        this.historyService = processEngine.getHistoryService();
        this.factory = factory;
        this.propertyConverter = propertyConverter;
        this.activitiUtil = new ActivitiUtil(processEngine, deployWorkflowsInTenant);
    }

    public <F, T> List<T> filterByDomainAndConvert(List<F> values, Function<F, String> processKeyGetter) {
        List<F> filtered = this.factory.filterByDomain(values, processKeyGetter);
        return this.convert(filtered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <F, T> List<T> doSpecialTenantFilterAndSafeConvert(List<F> values, Function<F, String> processKeyGetter) {
        List<F> filtered = this.factory.doSpecialTenantFilter(values, processKeyGetter);
        this.factory.setIgnoreTenantCheck(this.factory.isDefaultDomain());
        try {
            List<T> list = this.convert(filtered, true);
            return list;
        }
        finally {
            this.factory.setIgnoreTenantCheck(false);
        }
    }

    public WorkflowDeployment convert(Deployment deployment) {
        if (deployment == null) {
            return null;
        }
        ProcessDefinition processDef = this.activitiUtil.getProcessDefinitionForDeployment(deployment.getId());
        WorkflowDefinition wfDef = this.convert(processDef);
        return this.factory.createDeployment(wfDef, new String[0]);
    }

    public WorkflowDefinition convert(ProcessDefinition definition) {
        if (definition == null) {
            return null;
        }
        String defId = definition.getId();
        String defName = definition.getKey();
        int version = definition.getVersion();
        String defaultTitle = definition.getName();
        String startTaskName = null;
        StartFormData startFormData = this.getStartFormData(defId, defName);
        if (startFormData != null) {
            startTaskName = startFormData.getFormKey();
        }
        ReadOnlyProcessDefinition def = this.activitiUtil.getDeployedProcessDefinition(defId);
        PvmActivity startEvent = def.getInitial();
        WorkflowTaskDefinition startTask = this.getTaskDefinition(startEvent, startTaskName, definition.getKey(), true);
        return this.factory.createDefinition(defId, defName, version, defaultTitle, null, startTask);
    }

    private StartFormData getStartFormData(String definitionId, String processKey) {
        return this.formService.getStartFormData(definitionId);
    }

    public WorkflowTaskDefinition getTaskDefinition(PvmActivity activity, String taskFormKey, String processKey, boolean isStart) {
        WorkflowNode node = this.getNode(activity, processKey, true);
        String taskDefId = taskFormKey == null ? node.getName() : taskFormKey;
        return this.factory.createTaskDefinition(taskDefId, node, taskFormKey, isStart);
    }

    public WorkflowTaskDefinition getTaskDefinition(Task task) {
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        String taskDefId = null;
        if (taskFormData != null) {
            taskDefId = taskFormData.getFormKey();
        }
        ReadOnlyProcessDefinition procDef = this.activitiUtil.getDeployedProcessDefinition(task.getProcessDefinitionId());
        WorkflowNode node = this.convert(procDef.findActivity(task.getTaskDefinitionKey()), true);
        return this.factory.createTaskDefinition(taskDefId, node, taskDefId, false);
    }

    public WorkflowTaskDefinition getTaskDefinition(String taskDefinitionKey, String processDefinitionId) {
        ProcessDefinitionEntity procDef = (ProcessDefinitionEntity)this.activitiUtil.getDeployedProcessDefinition(processDefinitionId);
        Collection<PvmActivity> userTasks = this.findUserTasks((PvmActivity)procDef.getInitial());
        TaskDefinition taskDefinition = null;
        for (PvmActivity activity : userTasks) {
            taskDefinition = (TaskDefinition)procDef.getTaskDefinitions().get(activity.getId());
            if (!taskDefinitionKey.equals(taskDefinition.getKey())) continue;
            String formKey = this.getFormKey(taskDefinition);
            WorkflowNode node = this.convert(activity);
            return this.factory.createTaskDefinition(formKey, node, formKey, false);
        }
        return null;
    }

    private WorkflowTransition getDefaultTransition(String processDefKey, String nodeId) {
        String processKey = processDefKey + TRANSITION_SUFFIX;
        String nodeKey = processDefKey + ".node." + nodeId + TRANSITION_SUFFIX;
        String transitionId = "Next";
        String title = "Next";
        String description = "Default Transition";
        return this.factory.createTransition(transitionId, title, description, true, nodeKey, processKey, DEFAULT_TRANSITION_KEY);
    }

    public WorkflowInstance convert(ProcessInstance instance) {
        return this.convertAndSetVariables(instance, null);
    }

    public WorkflowInstance convertAndSetVariables(ProcessInstance instance, Map<String, Object> collectedvariables) {
        if (instance == null) {
            return null;
        }
        HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(instance.getId()).singleResult();
        return this.convertToInstanceAndSetVariables(historicInstance, collectedvariables);
    }

    public WorkflowInstance convert(HistoricProcessInstance instance, Map<String, Object> collectedvariables) {
        if (instance == null) {
            return null;
        }
        HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(instance.getId()).singleResult();
        return this.convertToInstanceAndSetVariables(historicInstance, collectedvariables);
    }

    public WorkflowPath convert(Execution execution) {
        String instanceId = execution.getProcessInstanceId();
        ProcessInstance instance = this.activitiUtil.getProcessInstance(instanceId);
        return this.convert(execution, instance);
    }

    public WorkflowPath convert(Execution execution, ProcessInstance instance) {
        if (execution == null) {
            return null;
        }
        boolean isActive = !execution.isEnded();
        HashMap<String, Object> workflowInstanceVariables = new HashMap<String, Object>();
        WorkflowInstance wfInstance = this.convertAndSetVariables(instance, workflowInstanceVariables);
        WorkflowNode node = null;
        List nodeIds = this.runtimeService.getActiveActivityIds(execution.getId());
        if (nodeIds != null && nodeIds.size() >= 1) {
            ReadOnlyProcessDefinition procDef = this.activitiUtil.getDeployedProcessDefinition(instance.getProcessDefinitionId());
            PvmActivity activity = procDef.findActivity((String)nodeIds.get(0));
            node = this.convert(activity);
        }
        return this.factory.createPath(execution.getId(), wfInstance, node, isActive);
    }

    public WorkflowNode convert(PvmActivity activity, boolean forceIsTaskNode) {
        String procDefId = activity.getProcessDefinition().getId();
        String key = this.activitiUtil.getProcessDefinition(procDefId).getKey();
        return this.getNode(activity, key, forceIsTaskNode);
    }

    private WorkflowNode getNode(PvmActivity activity, String key, boolean forceIsTaskNode) {
        boolean isTaskNode;
        String name = activity.getId();
        String defaultTitle = (String)activity.getProperty("name");
        String defaultDescription = (String)activity.getProperty("documentation");
        String type = (String)activity.getProperty("type");
        boolean bl = isTaskNode = forceIsTaskNode || "userTask".equals(type);
        if (defaultTitle == null) {
            defaultTitle = name;
        }
        if (defaultDescription == null) {
            defaultDescription = name;
        }
        WorkflowTransition transition = this.getDefaultTransition(key, name);
        return this.factory.createNode(name, key, defaultTitle, defaultDescription, type, isTaskNode, transition);
    }

    public WorkflowNode convert(PvmActivity activity) {
        return this.convert(activity, false);
    }

    public List<WorkflowPath> convertExecution(List<Execution> executions) {
        ArrayList<WorkflowPath> results = new ArrayList<WorkflowPath>(executions.size());
        for (Execution execution : executions) {
            results.add(this.convert(execution));
        }
        return results;
    }

    public <T> List<T> convert(List<?> inputs) {
        return this.convert(inputs, false);
    }

    public <T> List<T> convert(List<?> inputs, boolean ignoreNotDeployed) {
        ArrayList<Object> results = new ArrayList<Object>(inputs.size());
        for (Object in : inputs) {
            Object out;
            block3: {
                out = null;
                try {
                    out = this.convert(in);
                }
                catch (NullPointerException npe) {
                    if (ignoreNotDeployed) break block3;
                    throw npe;
                }
            }
            if (out == null) continue;
            results.add(out);
        }
        return results;
    }

    private Object convert(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Deployment) {
            return this.convert((Deployment)obj);
        }
        if (obj instanceof ProcessDefinition) {
            return this.convert((ProcessDefinition)obj);
        }
        if (obj instanceof ProcessInstance) {
            return this.convert((ProcessInstance)obj);
        }
        if (obj instanceof Execution) {
            return this.convert((Execution)obj);
        }
        if (obj instanceof ActivityImpl) {
            return this.convert((PvmActivity)((ActivityImpl)obj));
        }
        if (obj instanceof Task) {
            return this.convert((Task)obj);
        }
        if (obj instanceof HistoricTaskInstance) {
            return this.convert((HistoricTaskInstance)obj);
        }
        if (obj instanceof HistoricProcessInstance) {
            return this.convert((HistoricProcessInstance)obj);
        }
        throw new WorkflowException("Cannot convert object: " + obj + " of type: " + obj.getClass());
    }

    public WorkflowTask convert(Task task) {
        return this.convert(task, false);
    }

    public WorkflowTask convert(Task task, boolean ignoreDomainMismatch) {
        if (task == null) {
            return null;
        }
        String id = task.getId();
        String defaultTitle = task.getName();
        String defaultDescription = task.getDescription();
        WorkflowTaskState state = WorkflowTaskState.IN_PROGRESS;
        WorkflowPath path = this.getWorkflowPath(task.getExecutionId(), ignoreDomainMismatch);
        if (path != null) {
            WorkflowNode node = path.getNode();
            TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
            String taskDefId = null;
            if (taskFormData != null) {
                taskDefId = taskFormData.getFormKey();
            }
            WorkflowTaskDefinition taskDef = this.factory.createTaskDefinition(taskDefId, node, taskDefId, false);
            Map<QName, Serializable> properties = this.propertyConverter.getTaskProperties(task);
            return this.factory.createTask(id, taskDef, taskDef.getId(), defaultTitle, defaultDescription, state, path, properties);
        }
        return null;
    }

    public Map<QName, Serializable> getTaskProperties(Task task) {
        return this.propertyConverter.getTaskProperties(task);
    }

    public Map<QName, Serializable> getTaskProperties(HistoricTaskInstance task) {
        Map<String, Object> variables = this.propertyConverter.getHistoricTaskVariables(task.getId());
        return this.propertyConverter.getTaskProperties(task, variables);
    }

    public WorkflowPath getWorkflowPath(String executionId, boolean ignoreDomainMismatch) {
        WorkflowPath path;
        block2: {
            Execution execution = this.activitiUtil.getExecution(executionId);
            path = null;
            try {
                path = this.convert(execution);
            }
            catch (RuntimeException re) {
                if (ignoreDomainMismatch) break block2;
                throw re;
            }
        }
        return path;
    }

    public WorkflowTask getVirtualStartTask(String processInstanceId, Boolean inProgress) {
        ProcessInstance processInstance = this.activitiUtil.getProcessInstance(processInstanceId);
        if (processInstance != null) {
            if (null == inProgress) {
                inProgress = this.isStartTaskActive(processInstanceId);
            }
            return this.getVirtualStartTask(processInstance, (boolean)inProgress);
        }
        HistoricProcessInstance historicProcessInstance = this.activitiUtil.getHistoricProcessInstance(processInstanceId);
        return this.getVirtualStartTask(historicProcessInstance);
    }

    public boolean isStartTaskActive(String processInstanceId) {
        Object endDate = this.runtimeService.getVariable(processInstanceId, "_startTaskCompleted");
        return endDate == null;
    }

    private WorkflowTask getVirtualStartTask(ProcessInstance processInstance, boolean inProgress) {
        String processInstanceId = processInstance.getId();
        if (!this.activitiUtil.isMultiTenantWorkflowDeploymentEnabled() && !this.isCorrectTenantRuntime(processInstanceId)) {
            return null;
        }
        String id = "start" + processInstanceId;
        WorkflowTaskState state = null;
        state = inProgress ? WorkflowTaskState.IN_PROGRESS : WorkflowTaskState.COMPLETED;
        WorkflowPath path = this.convert((Execution)processInstance);
        String definitionId = processInstance.getProcessDefinitionId();
        ReadOnlyProcessDefinition procDef = this.activitiUtil.getDeployedProcessDefinition(definitionId);
        WorkflowNode startNode = this.convert(procDef.getInitial(), true);
        String key = ((ProcessDefinition)procDef).getKey();
        StartFormData startFormData = this.getStartFormData(definitionId, key);
        String taskDefId = null;
        if (startFormData != null) {
            taskDefId = startFormData.getFormKey();
        }
        WorkflowTaskDefinition taskDef = this.factory.createTaskDefinition(taskDefId, startNode, taskDefId, true);
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Map<QName, Serializable> properties = this.propertyConverter.getStartTaskProperties(historicProcessInstance, taskDefId, !inProgress);
        String defaultTitle = null;
        String defaultDescription = null;
        return this.factory.createTask(id, taskDef, taskDef.getId(), defaultTitle, defaultDescription, state, path, properties);
    }

    public boolean isCorrectTenantRuntime(String processInstanceId, boolean isRuntime) {
        if (!this.activitiUtil.isMultiTenantWorkflowDeploymentEnabled()) {
            if (isRuntime) {
                return this.isCorrectTenantRuntime(processInstanceId);
            }
            return this.isCorrectTenantHistoric(processInstanceId);
        }
        return true;
    }

    public boolean isCorrectTenantRuntime(String processInstanceId) {
        return this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).variableValueEquals("_tenant_domain", (Object)TenantUtil.getCurrentDomain()).count() > 0L;
    }

    public boolean isCorrectTenantHistoric(String processInstanceId) {
        return this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).variableValueEquals("_tenant_domain", (Object)TenantUtil.getCurrentDomain()).count() > 0L;
    }

    private WorkflowTask getVirtualStartTask(HistoricProcessInstance historicProcessInstance) {
        if (historicProcessInstance == null) {
            return null;
        }
        String processInstanceId = historicProcessInstance.getId();
        if (!this.activitiUtil.isMultiTenantWorkflowDeploymentEnabled() && !this.isCorrectTenantHistoric(processInstanceId)) {
            return null;
        }
        String id = "start" + processInstanceId;
        WorkflowTaskState state = WorkflowTaskState.COMPLETED;
        WorkflowPath path = this.buildCompletedPath(processInstanceId, processInstanceId);
        if (path == null) {
            return null;
        }
        ReadOnlyProcessDefinition procDef = this.activitiUtil.getDeployedProcessDefinition(historicProcessInstance.getProcessDefinitionId());
        WorkflowNode startNode = this.convert(procDef.getInitial(), true);
        String taskDefId = this.activitiUtil.getStartFormKey(historicProcessInstance.getProcessDefinitionId());
        WorkflowTaskDefinition taskDef = this.factory.createTaskDefinition(taskDefId, startNode, taskDefId, true);
        boolean completed = historicProcessInstance.getEndTime() != null;
        Map<QName, Serializable> properties = this.propertyConverter.getStartTaskProperties(historicProcessInstance, taskDefId, completed);
        String defaultTitle = null;
        String defaultDescription = null;
        return this.factory.createTask(id, taskDef, taskDef.getId(), defaultTitle, defaultDescription, state, path, properties);
    }

    public WorkflowTask convert(HistoricTaskInstance historicTaskInstance) {
        if (historicTaskInstance == null) {
            return null;
        }
        WorkflowPath path = this.getWorkflowPath(historicTaskInstance);
        if (path == null) {
            return null;
        }
        WorkflowNode node = this.buildHistoricTaskWorkflowNode(historicTaskInstance);
        WorkflowTaskState state = WorkflowTaskState.COMPLETED;
        String taskId = historicTaskInstance.getId();
        Map<String, Object> variables = this.propertyConverter.getHistoricTaskVariables(taskId);
        Map<QName, Serializable> historicTaskProperties = this.propertyConverter.getTaskProperties(historicTaskInstance, variables);
        String formKey = (String)variables.get("taskFormKey");
        WorkflowTaskDefinition taskDef = this.factory.createTaskDefinition(formKey, node, formKey, false);
        String title = historicTaskInstance.getName();
        String description = historicTaskInstance.getDescription();
        String taskName = taskDef.getId();
        return this.factory.createTask(taskId, taskDef, taskName, title, description, state, path, historicTaskProperties);
    }

    public WorkflowPath getWorkflowPath(HistoricTaskInstance historicTaskInstance) {
        WorkflowPath path = null;
        Execution execution = this.activitiUtil.getExecution(historicTaskInstance.getExecutionId());
        path = execution != null ? this.convert(execution) : this.buildCompletedPath(historicTaskInstance.getExecutionId(), historicTaskInstance.getProcessInstanceId());
        return path;
    }

    public String getFormKey(PvmActivity act, ReadOnlyProcessDefinition processDefinition) {
        if (act instanceof ActivityImpl) {
            TaskDefinition taskDef;
            ActivityImpl actImpl = (ActivityImpl)act;
            if (actImpl.getActivityBehavior() instanceof UserTaskActivityBehavior) {
                UserTaskActivityBehavior uta = (UserTaskActivityBehavior)actImpl.getActivityBehavior();
                return this.getFormKey(uta.getTaskDefinition());
            }
            if (actImpl.getActivityBehavior() instanceof MultiInstanceActivityBehavior && processDefinition instanceof ProcessDefinitionEntity && (taskDef = (TaskDefinition)((ProcessDefinitionEntity)processDefinition).getTaskDefinitions().get(act.getId())) != null) {
                return this.getFormKey(taskDef);
            }
        }
        return null;
    }

    private String getFormKey(TaskDefinition taskDefinition) {
        TaskFormHandler handler = taskDefinition.getTaskFormHandler();
        if (handler != null && handler instanceof DefaultTaskFormHandler) {
            return ((DefaultTaskFormHandler)handler).getFormKey().getExpressionText();
        }
        return null;
    }

    private WorkflowNode buildHistoricTaskWorkflowNode(HistoricTaskInstance historicTaskInstance) {
        ReadOnlyProcessDefinition procDef = this.activitiUtil.getDeployedProcessDefinition(historicTaskInstance.getProcessDefinitionId());
        PvmActivity taskActivity = procDef.findActivity(historicTaskInstance.getTaskDefinitionKey());
        return this.convert(taskActivity);
    }

    public WorkflowPath buildCompletedPath(String executionId, String processInstanceId) {
        WorkflowInstance wfInstance = null;
        ProcessInstance processInstance = this.activitiUtil.getProcessInstance(processInstanceId);
        if (processInstance != null) {
            wfInstance = this.convert(processInstance);
        } else {
            HistoricProcessInstance historicProcessInstance = this.activitiUtil.getHistoricProcessInstance(processInstanceId);
            if (historicProcessInstance != null) {
                wfInstance = this.convert(historicProcessInstance);
            }
        }
        if (wfInstance == null) {
            return null;
        }
        WorkflowNode node = null;
        return this.factory.createPath(executionId, wfInstance, node, false);
    }

    public WorkflowInstance convertToInstanceAndSetVariables(HistoricProcessInstance historicProcessInstance, Map<String, Object> collectedVariables) {
        String processInstanceId;
        String id = processInstanceId = historicProcessInstance.getId();
        ProcessDefinition procDef = this.activitiUtil.getProcessDefinition(historicProcessInstance.getProcessDefinitionId());
        WorkflowDefinition definition = this.convert(procDef);
        Map<String, Object> variables = this.propertyConverter.getHistoricProcessVariables(processInstanceId);
        Date startDate = historicProcessInstance.getStartTime();
        Date endDate = historicProcessInstance.getEndTime();
        if (collectedVariables != null) {
            collectedVariables.putAll(variables);
        }
        boolean isActive = endDate == null;
        return this.factory.createInstance(id, definition, variables, isActive, startDate, endDate);
    }

    public String getWorkflowDefinitionName(String workflowDefinitionId) {
        ReadOnlyProcessDefinition def = this.activitiUtil.getDeployedProcessDefinition(workflowDefinitionId);
        return ((ProcessDefinition)def).getKey();
    }

    public Collection<PvmActivity> findUserTasks(PvmActivity startEvent) {
        LinkedHashMap<String, PvmActivity> userTasks = new LinkedHashMap<String, PvmActivity>();
        HashSet<String> processedActivities = new HashSet<String>();
        this.findUserTasks(startEvent, userTasks, processedActivities);
        return userTasks.values();
    }

    private void findUserTasks(PvmActivity currentActivity, Map<String, PvmActivity> userTasks, Set<String> processedActivities) {
        if (!processedActivities.contains(currentActivity.getId())) {
            processedActivities.add(currentActivity.getId());
            if (this.isUserTask(currentActivity)) {
                userTasks.put(currentActivity.getId(), currentActivity);
            }
            if (currentActivity.getOutgoingTransitions() != null) {
                for (PvmTransition transition : currentActivity.getOutgoingTransitions()) {
                    if (transition.getDestination() == null) continue;
                    this.findUserTasks(transition.getDestination(), userTasks, processedActivities);
                }
            }
        }
    }

    private boolean isUserTask(PvmActivity currentActivity) {
        String type = (String)currentActivity.getProperty("type");
        return type != null && type.equals("userTask");
    }

    public WorkflowInstance convert(HistoricProcessInstance historicProcessInstance) {
        return this.convertToInstanceAndSetVariables(historicProcessInstance, null);
    }

    public WorkflowObjectFactory getWorkflowObjectFactory() {
        return this.factory;
    }
}

