/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.calendar;

import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class CalendarRecurrenceHelper {
    private static Log logger = LogFactory.getLog(CalendarRecurrenceHelper.class);
    protected static final Map<String, Integer> d2cd = Collections.unmodifiableMap(new HashMap<String, Integer>(){
        {
            this.put("SU", 1);
            this.put("MO", 2);
            this.put("TU", 3);
            this.put("WE", 4);
            this.put("TH", 5);
            this.put("FR", 6);
            this.put("SA", 7);
        }
    });
    public static final Map<String, Integer> DAY_NAMES_TO_CALENDAR_DAYS = Collections.unmodifiableMap(d2cd);
    private static final long DAY_IN_MS = 86400000L;
    private static final long WEEK_IN_MS = 604800000L;
    private static final long MONTH_IN_MS = 2678400000L;
    private static final long YEAR_IN_MS = 32140800000L;
    protected static final Map<Integer, String> WEEK_NUMBER_TO_WEEK_NAME = Collections.unmodifiableMap(new HashMap<Integer, String>(){
        {
            this.put(1, "first");
            this.put(2, "second");
            this.put(3, "third");
            this.put(4, "fourth");
            this.put(-1, "last");
        }
    });

    public static Map<String, String> buildLocalRecurrenceDaysOfTheWeek(Locale locale) {
        DateFormatSymbols dates = new DateFormatSymbols(I18NUtil.getLocale());
        String[] weekdays = dates.getWeekdays();
        HashMap<String, String> days = new HashMap<String, String>();
        for (Map.Entry<String, Integer> e : DAY_NAMES_TO_CALENDAR_DAYS.entrySet()) {
            days.put(e.getKey(), weekdays[e.getValue()]);
        }
        return days;
    }

    public static Map<Integer, String> buildLocalRecurrenceWeekNames(Locale locale) {
        return WEEK_NUMBER_TO_WEEK_NAME;
    }

    public static Map<String, String> extractRecurrenceRule(CalendarEntry entry) {
        return CalendarRecurrenceHelper.extractRecurrenceRule(entry.getRecurrenceRule());
    }

    private static Map<String, String> extractRecurrenceRule(String recurrenceRule) {
        if (recurrenceRule == null) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (String rule : recurrenceRule.split(";")) {
            String[] parts = rule.split("=");
            if (parts.length != 2) {
                logger.warn((Object)("Invalid rule '" + rule + "' in recurrence: " + recurrenceRule));
                continue;
            }
            params.put(parts[0], parts[1]);
        }
        return params;
    }

    protected static Map<String, String> fixOutlookRecurrenceQuirks(Map<String, String> params) {
        if (params.containsKey("FREQ") && "MONTHLY".equals(params.get("FREQ")) && params.get("BYMONTH") != null) {
            int days;
            params.put("FREQ", "YEARLY");
            String intervalString = params.get("INTERVAL");
            if (intervalString != null) {
                int interval = Integer.parseInt(intervalString);
                params.put("INTERVAL", String.valueOf(interval / 12));
            }
            if (params.containsKey("BYDAY") && params.containsKey("BYSETPOS") && (days = params.get("BYDAY").split(",").length) == 7) {
                params.put("BYMONTHDAY", params.get("BYSETPOS"));
                params.remove("BYDAY");
                params.remove("BYSETPOS");
            }
        }
        return params;
    }

    public static List<Date> getRecurrencesOnOrAfter(CalendarEntry entry, Date onOrAfter, Date until, boolean firstOnly) {
        return CalendarRecurrenceHelper.getRecurrencesOnOrAfter(entry.getRecurrenceRule(), entry.getStart(), entry.getEnd(), entry.getLastRecurrence(), onOrAfter, until, firstOnly);
    }

    public static List<Date> getRecurrencesOnOrAfter(String recurrenceRule, Date eventStart, Date eventEnd, Date lastRecurrence, Date onOrAfter, Date until, boolean firstOnly) {
        if (recurrenceRule == null) {
            return null;
        }
        if (lastRecurrence != null && lastRecurrence.before(onOrAfter)) {
            return null;
        }
        if (lastRecurrence != null) {
            if (until == null) {
                until = lastRecurrence;
            } else if (lastRecurrence.before(until)) {
                until = lastRecurrence;
            }
        }
        if (lastRecurrence == null && !firstOnly && until == null) {
            logger.info((Object)"No end date set on the recurring event, and no end date specified, only fetching first instance");
            firstOnly = true;
        }
        ArrayList<Date> dates = new ArrayList<Date>();
        Map<String, String> params = CalendarRecurrenceHelper.extractRecurrenceRule(recurrenceRule);
        if ((params = CalendarRecurrenceHelper.fixOutlookRecurrenceQuirks(params)).containsKey("FREQ")) {
            String freq = params.get("FREQ");
            String intervalS = params.get("INTERVAL");
            int interval = 1;
            if (intervalS != null) {
                try {
                    interval = Integer.parseInt(intervalS);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)("Invalid interval " + intervalS));
                }
            }
            Calendar currentDate = Calendar.getInstance();
            currentDate.setTime(eventStart);
            long duration = eventEnd.getTime() - eventStart.getTime();
            if ("DAILY".equals(freq)) {
                CalendarRecurrenceHelper.buildDailyRecurrences(currentDate, duration, dates, params, onOrAfter, until, firstOnly, interval);
            } else if ("WEEKLY".equals(freq)) {
                CalendarRecurrenceHelper.buildWeeklyRecurrences(currentDate, duration, dates, params, onOrAfter, until, firstOnly, interval);
            } else if ("MONTHLY".equals(freq)) {
                CalendarRecurrenceHelper.buildMonthlyRecurrences(currentDate, duration, dates, params, onOrAfter, until, firstOnly, interval);
            } else if ("YEARLY".equals(freq)) {
                CalendarRecurrenceHelper.buildYearlyRecurrences(currentDate, duration, dates, params, onOrAfter, until, firstOnly, interval);
            } else {
                logger.warn((Object)("Unsupported recurrence frequency " + freq));
            }
            return dates;
        }
        logger.warn((Object)("No frequency found, possible invalid rule? " + recurrenceRule));
        return null;
    }

    protected static void buildDailyRecurrences(Calendar currentDate, long duration, List<Date> dates, Map<String, String> params, Date onOrAfter, Date until, boolean firstOnly, int interval) {
        if (onOrAfter.before(currentDate.getTime())) {
            onOrAfter = currentDate.getTime();
        }
        while (currentDate.getTime().before(onOrAfter)) {
            currentDate.add(5, interval);
        }
        currentDate.setTime(new Date(currentDate.getTime().getTime() - 86400000L * (long)interval * 2L));
        Date currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
        while (currentEventEnd.before(onOrAfter)) {
            currentDate.add(5, interval);
            currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
        }
        if (firstOnly) {
            if (until != null) {
                if (currentDate.getTime().before(until)) {
                    dates.add(currentDate.getTime());
                }
            } else {
                dates.add(currentDate.getTime());
            }
        } else {
            while (!currentDate.getTime().after(until)) {
                dates.add(currentDate.getTime());
                currentDate.add(5, interval);
            }
        }
    }

    protected static void buildWeeklyRecurrences(Calendar currentDate, long duration, List<Date> dates, Map<String, String> params, Date onOrAfter, Date until, boolean firstOnly, int interval) {
        if (onOrAfter.before(currentDate.getTime())) {
            onOrAfter = currentDate.getTime();
        }
        ArrayList<Integer> daysOfWeek = new ArrayList<Integer>();
        for (String dayS : params.get("BYDAY").split(",")) {
            Integer day = DAY_NAMES_TO_CALENDAR_DAYS.get(dayS);
            if (day == null) {
                logger.warn((Object)("Invalid day " + dayS));
                continue;
            }
            daysOfWeek.add(day);
        }
        Collections.sort(daysOfWeek);
        boolean going = true;
        boolean valid = false;
        Date origDate = currentDate.getTime();
        currentDate.setTime(new Date(currentDate.getTime().getTime() - 604800000L * (long)interval * 2L));
        while (going) {
            Iterator i$ = daysOfWeek.iterator();
            while (i$.hasNext()) {
                Date currentEventEnd;
                int day = (Integer)i$.next();
                currentDate.set(7, day);
                if (!(valid || (currentEventEnd = new Date(currentDate.getTimeInMillis() + duration)).before(onOrAfter) || currentEventEnd.before(origDate))) {
                    valid = true;
                }
                if (!valid) continue;
                if (until != null && currentDate.getTime().after(until)) {
                    going = false;
                    break;
                }
                dates.add(currentDate.getTime());
                if (!firstOnly) continue;
                going = false;
                break;
            }
            currentDate.set(7, (Integer)daysOfWeek.get(0));
            currentDate.add(5, interval * 7);
        }
    }

    protected static void buildMonthlyRecurrences(Calendar currentDate, long duration, List<Date> dates, Map<String, String> params, Date onOrAfter, Date until, boolean firstOnly, int monthInterval) {
        block13: {
            block14: {
                if (onOrAfter.before(currentDate.getTime())) {
                    onOrAfter = currentDate.getTime();
                }
                if (params.get("BYMONTHDAY") == null) break block14;
                currentDate.setTime(new Date(currentDate.getTime().getTime() - 2678400000L * (long)monthInterval * 2L));
                int dayOfMonth = Integer.parseInt(params.get("BYMONTHDAY"));
                if (currentDate.get(5) > dayOfMonth) {
                    CalendarRecurrenceHelper.addMonthToDayOfMonth(currentDate, dayOfMonth, monthInterval);
                } else {
                    currentDate.set(5, dayOfMonth);
                    if (currentDate.get(5) != dayOfMonth) {
                        currentDate.add(5, -1);
                    }
                }
                Date currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
                while (currentEventEnd.before(onOrAfter)) {
                    CalendarRecurrenceHelper.addMonthToDayOfMonth(currentDate, dayOfMonth, monthInterval);
                    currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
                }
                while (until == null || !currentDate.getTime().after(until)) {
                    dates.add(currentDate.getTime());
                    if (!firstOnly) {
                        CalendarRecurrenceHelper.addMonthToDayOfMonth(currentDate, dayOfMonth, monthInterval);
                        continue;
                    }
                    break block13;
                }
                break block13;
            }
            if (params.get("BYSETPOS") == null) break block13;
            int dayOfWeek = -1;
            int instanceInMonth = 1;
            if (params.containsKey("BYDAY")) {
                dayOfWeek = DAY_NAMES_TO_CALENDAR_DAYS.get(params.get("BYDAY"));
                instanceInMonth = Integer.parseInt(params.get("BYSETPOS"));
            } else {
                dayOfWeek = DAY_NAMES_TO_CALENDAR_DAYS.get(params.get("BYSETPOS"));
                instanceInMonth = 1;
            }
            Date origDate = currentDate.getTime();
            currentDate.setTime(new Date(currentDate.getTime().getTime() - 2678400000L * (long)monthInterval * 2L));
            CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
            Date currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            if (currentEventEnd.before(origDate)) {
                CalendarRecurrenceHelper.addMonthToFirstDayOfWeek(currentDate, dayOfWeek, monthInterval);
                CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
                currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            }
            while (currentEventEnd.before(onOrAfter)) {
                CalendarRecurrenceHelper.addMonthToFirstDayOfWeek(currentDate, dayOfWeek, monthInterval);
                CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
                currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            }
            while (until == null || !currentDate.getTime().after(until)) {
                dates.add(currentDate.getTime());
                if (!firstOnly) {
                    CalendarRecurrenceHelper.addMonthToFirstDayOfWeek(currentDate, dayOfWeek, monthInterval);
                    CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
                    continue;
                }
                break;
            }
        }
    }

    protected static void buildYearlyRecurrences(Calendar currentDate, long duration, List<Date> dates, Map<String, String> params, Date onOrAfter, Date until, boolean firstOnly, int interval) {
        if (onOrAfter.before(currentDate.getTime())) {
            onOrAfter = currentDate.getTime();
        }
        int realMonth = Integer.parseInt(params.get("BYMONTH"));
        int month = realMonth - 1;
        if (params.get("BYMONTHDAY") != null) {
            currentDate.setTime(new Date(currentDate.getTime().getTime() - 32140800000L * (long)interval * 2L));
            int dayOfMonth = Integer.parseInt(params.get("BYMONTHDAY"));
            if (currentDate.get(2) != month || currentDate.get(5) != dayOfMonth) {
                if (currentDate.get(2) < month || currentDate.get(2) == month && currentDate.get(5) < dayOfMonth) {
                    currentDate.set(2, month);
                    currentDate.set(5, dayOfMonth);
                } else {
                    currentDate.set(1, currentDate.get(1) + interval);
                    currentDate.set(2, month);
                    currentDate.set(5, dayOfMonth);
                }
            }
            Date currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            while (currentEventEnd.before(onOrAfter)) {
                currentDate.set(1, currentDate.get(1) + interval);
                currentDate.set(2, month);
                currentDate.set(5, dayOfMonth);
                currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            }
            while (until == null || !currentDate.getTime().after(until)) {
                dates.add(currentDate.getTime());
                if (!firstOnly) {
                    currentDate.set(1, currentDate.get(1) + interval);
                    currentDate.set(2, month);
                    currentDate.set(5, dayOfMonth);
                    continue;
                }
                break;
            }
        } else {
            int dayOfWeek = -1;
            int instanceInMonth = 1;
            if (params.containsKey("BYDAY")) {
                dayOfWeek = DAY_NAMES_TO_CALENDAR_DAYS.get(params.get("BYDAY"));
                instanceInMonth = Integer.parseInt(params.get("BYSETPOS"));
            } else {
                dayOfWeek = DAY_NAMES_TO_CALENDAR_DAYS.get(params.get("BYSETPOS"));
                instanceInMonth = 1;
            }
            currentDate.setTime(new Date(currentDate.getTime().getTime() - 32140800000L * (long)interval * 2L));
            Date origDate = currentDate.getTime();
            currentDate.set(2, month);
            currentDate.set(5, 1);
            CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
            Date thisYear = currentDate.getTime();
            currentDate.setTime(origDate);
            if (currentDate.getTime().after(thisYear)) {
                currentDate.set(1, currentDate.get(1) + interval);
                currentDate.set(2, month);
                currentDate.set(5, 1);
                CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
            } else {
                currentDate.setTime(thisYear);
            }
            Date currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            while (currentEventEnd.before(onOrAfter)) {
                currentDate.set(1, currentDate.get(1) + interval);
                currentDate.set(2, month);
                currentDate.set(5, 1);
                CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
                currentEventEnd = new Date(currentDate.getTimeInMillis() + duration);
            }
            while (until == null || !currentDate.getTime().after(until)) {
                dates.add(currentDate.getTime());
                if (!firstOnly) {
                    currentDate.set(1, currentDate.get(1) + interval);
                    currentDate.set(2, month);
                    currentDate.set(5, 1);
                    CalendarRecurrenceHelper.toDayOfWeekInMonth(currentDate, dayOfWeek, instanceInMonth);
                    continue;
                }
                break;
            }
        }
    }

    private static void addMonthToDayOfMonth(Calendar c, int dayOfMonth, int monthInterval) {
        for (int i = 0; i < monthInterval; ++i) {
            c.set(5, 1);
            c.add(5, 33);
            c.set(5, dayOfMonth);
            if (c.get(5) == dayOfMonth) continue;
            c.set(5, 1);
            c.add(5, -1);
        }
    }

    private static void addMonthToFirstDayOfWeek(Calendar c, int dayOfWeek, int monthInterval) {
        CalendarRecurrenceHelper.addMonthToDayOfMonth(c, 1, monthInterval);
        CalendarRecurrenceHelper.toDayOfWeekInMonth(c, dayOfWeek, 1);
    }

    private static void toDayOfWeekInMonth(Calendar c, int dayOfWeek, int weekInMonth) {
        c.set(5, 1);
        c.set(7, dayOfWeek);
        c.set(8, weekInMonth);
    }
}

