/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tools;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.importer.FileImportPackageHandler;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.view.ImportPackageHandler;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.service.cmr.view.ImporterContentCache;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.cmr.view.ImporterProgress;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.tools.Tool;
import org.alfresco.tools.ToolArgumentException;
import org.alfresco.tools.ToolContext;
import org.alfresco.tools.ToolException;

public class Import
extends Tool {
    private ImportContext context;

    public static void main(String[] args) {
        Import tool = new Import();
        tool.start(args);
    }

    @Override
    protected ToolContext processArgs(String[] args) throws ToolArgumentException {
        this.context = new ImportContext();
        this.context.setLogin(true);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h") || args[i].equals("-help")) {
                this.context.setHelp(true);
                break;
            }
            if (args[i].equals("-s") || args[i].equals("-store")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <store> for the option -store must be specified");
                }
                this.context.storeRef = new StoreRef(args[i]);
                continue;
            }
            if (args[i].equals("-p") || args[i].equals("-path")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <path> for the option -path must be specified");
                }
                this.context.path = args[i];
                continue;
            }
            if (args[i].equals("-d") || args[i].equals("-dir")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <dir> for the option -dir must be specified");
                }
                this.context.sourceDir = args[i];
                continue;
            }
            if (args[i].equals("-user")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <user> for the option -user must be specified");
                }
                this.context.setUsername(args[i]);
                continue;
            }
            if (args[i].equals("-pwd")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <password> for the option -pwd must be specified");
                }
                this.context.setPassword(args[i]);
                continue;
            }
            if (args[i].equals("-encoding")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <encoding> for the option -encoding must be specified");
                }
                this.context.encoding = args[i];
                continue;
            }
            if (args[i].equals("-uuidBinding")) {
                ++i;
                try {
                    this.context.uuidBinding = ImporterBinding.UUID_BINDING.valueOf(ImporterBinding.UUID_BINDING.class, args[i]);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ToolArgumentException("The value " + args[i] + " is an invalid uuidBinding");
                }
            }
            if (args[i].equals("-quiet")) {
                this.context.setQuiet(true);
                continue;
            }
            if (args[i].equals("-verbose")) {
                this.context.setVerbose(true);
                continue;
            }
            if (!args[i].startsWith("-")) {
                ImportContext.access$602(this.context, new String[args.length - i]);
                ImportContext.access$702(this.context, new boolean[this.context.packageNames.length]);
                System.arraycopy(args, i, this.context.packageNames, 0, this.context.packageNames.length);
                break;
            }
            throw new ToolArgumentException("Unknown option " + args[i]);
        }
        return this.context;
    }

    @Override
    protected void displayHelp() {
        this.logError("Usage: import -user username -s[tore] store [options] packagename");
        this.logError("");
        this.logError("username: username for login");
        this.logError("store: the store to import into the form of scheme://store_name");
        this.logError("packagename: the filename to import from (with or without extension)");
        this.logError("");
        this.logError("Options:");
        this.logError(" -h[elp] display this help");
        this.logError(" -p[ath] the path within the store to extract into (default: /)");
        this.logError(" -d[ir] the source directory to import from (default: current directory)");
        this.logError(" -pwd password for login");
        this.logError(" -encoding package file encoding (default: " + Charset.defaultCharset() + ")");
        this.logError(" -uuidBinding CREATE_NEW, REMOVE_EXISTING, REPLACE_EXISTING, UPDATE_EXISTING, THROW_ON_COLLISION (default: CREATE_NEW)");
        this.logError(" -quiet do not display any messages during import");
        this.logError(" -verbose report import progress");
    }

    @Override
    protected String getToolName() {
        return "Alfresco Repository Importer";
    }

    @Override
    protected int execute() throws ToolException {
        ImporterService importer = this.getServiceRegistry().getImporterService();
        int status = 0;
        for (int i = 0; i < this.context.packageNames.length; ++i) {
            ImportPackageHandler importHandler = new ZipHandler(this.context.getSourceDir(), this.context.getPackageFile(i), this.context.encoding);
            try {
                importHandler = this.context.zipFile[i] ? new ZipHandler(this.context.getSourceDir(), this.context.getPackageFile(i), this.context.encoding) : new FileHandler(this.context.getSourceDir(), this.context.getPackageFile(i), this.context.encoding);
                try {
                    ImportBinding binding = new ImportBinding(this.context.uuidBinding);
                    importer.importView(importHandler, this.context.getLocation(), (ImporterBinding)binding, (ImporterProgress)new ImportProgress());
                    continue;
                }
                catch (ImporterException e) {
                    throw new ToolException("Failed to import package due to " + e.getMessage(), e);
                }
            }
            catch (Throwable t) {
                status = this.handleError(t);
            }
        }
        return status;
    }

    private class ImportBinding
    implements ImporterBinding {
        private ImporterBinding.UUID_BINDING uuidBinding = null;

        public ImportBinding(ImporterBinding.UUID_BINDING uuidBinding) {
            this.uuidBinding = uuidBinding;
        }

        @Override
        public ImporterBinding.UUID_BINDING getUUIDBinding() {
            return this.uuidBinding;
        }

        @Override
        public boolean allowReferenceWithinTransaction() {
            return false;
        }

        @Override
        public String getValue(String key) {
            return null;
        }

        @Override
        public QName[] getExcludedClasses() {
            return new QName[0];
        }

        @Override
        public ImporterContentCache getImportConentCache() {
            return null;
        }
    }

    private class ImportContext
    extends ToolContext {
        private StoreRef storeRef;
        private String path;
        private String sourceDir;
        private String[] packageNames;
        private String encoding = null;
        private ImporterBinding.UUID_BINDING uuidBinding = ImporterBinding.UUID_BINDING.CREATE_NEW;
        private boolean[] zipFile;

        private ImportContext() {
        }

        @Override
        void validate() {
            File fileSourceDir;
            super.validate();
            if (this.storeRef == null) {
                throw new ToolArgumentException("Store to import into has not been specified.");
            }
            if (this.packageNames == null) {
                throw new ToolArgumentException("Package name has not been specified.");
            }
            if (this.sourceDir != null && !(fileSourceDir = this.getSourceDir()).exists()) {
                throw new ToolArgumentException("Source directory " + fileSourceDir.getAbsolutePath() + " does not exist.");
            }
            for (int i = 0; i < this.packageNames.length; ++i) {
                File packageFile;
                if (this.packageNames[i].endsWith(".acp") || this.packageNames[i].endsWith(".zip")) {
                    packageFile = new File(this.getSourceDir(), this.packageNames[i]);
                    if (!packageFile.exists()) {
                        throw new ToolArgumentException("Package zip file " + packageFile.getAbsolutePath() + " does not exist.");
                    }
                    this.zipFile[i] = true;
                    continue;
                }
                packageFile = new File(this.getSourceDir(), this.getDataFile(i).getPath());
                if (packageFile.exists()) continue;
                throw new ToolArgumentException("Package file " + packageFile.getAbsolutePath() + " does not exist.");
            }
        }

        private Location getLocation() {
            Location location = new Location(this.storeRef);
            location.setPath(this.path);
            return location;
        }

        private File getSourceDir() {
            File dir = this.sourceDir == null ? null : new File(this.sourceDir);
            return dir;
        }

        private File getDataFile(int i) {
            String dataFile = this.packageNames[i].indexOf(46) != -1 ? this.packageNames[i] : this.packageNames[i] + ".xml";
            File file = new File(dataFile);
            return file;
        }

        private File getPackageFile(int i) {
            return this.zipFile[i] ? new File(this.packageNames[i]) : this.getDataFile(i);
        }

        static /* synthetic */ String[] access$602(ImportContext x0, String[] x1) {
            x0.packageNames = x1;
            return x1;
        }

        static /* synthetic */ boolean[] access$702(ImportContext x0, boolean[] x1) {
            x0.zipFile = x1;
            return x1;
        }
    }

    private class ImportProgress
    implements ImporterProgress {
        private ImportProgress() {
        }

        @Override
        public void nodeCreated(NodeRef nodeRef, NodeRef parentRef, QName assocName, QName childName) {
            Import.this.logVerbose("Imported node " + nodeRef + " (parent=" + parentRef + ", childname=" + childName + ", association=" + assocName + ")");
        }

        @Override
        public void nodeLinked(NodeRef nodeRef, NodeRef parentRef, QName assocName, QName childName) {
        }

        @Override
        public void contentCreated(NodeRef nodeRef, String sourceUrl) {
        }

        @Override
        public void propertySet(NodeRef nodeRef, QName property, Serializable value) {
        }

        @Override
        public void permissionSet(NodeRef nodeRef, AccessPermission permission) {
        }

        @Override
        public void aspectAdded(NodeRef nodeRef, QName aspect) {
        }

        @Override
        public void started() {
        }

        @Override
        public void completed() {
        }

        @Override
        public void error(Throwable e) {
        }
    }

    private class FileHandler
    extends FileImportPackageHandler {
        public FileHandler(File sourceDir, File dataFile, String dataFileEncoding) {
            super(sourceDir, dataFile, dataFileEncoding);
        }

        @Override
        protected void log(String message) {
            Import.this.logInfo(message);
        }
    }

    private class ZipHandler
    extends ACPImportPackageHandler {
        public ZipHandler(File sourceDir, File dataFile, String dataFileEncoding) {
            super(new File(sourceDir, dataFile.getPath()), dataFileEncoding);
        }

        @Override
        protected void log(String message) {
            Import.this.logInfo(message);
        }
    }
}

