/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import com.sun.star.io.IOException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.AliasDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.DefaultsDefinition;
import org.springframework.beans.factory.parsing.ImportDefinition;
import org.springframework.beans.factory.parsing.ReaderEventListener;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ContextDependencyLister {
    public static final String[] DEFAULT_CONFIG_LOCATIONS = new String[]{"classpath:alfresco/application-context.xml"};
    private String[] configLocations;
    private BeanTrackingApplicationContext instance;
    private Hashtable<String, List<String>> contextBeans;
    private Hashtable<String, List<String>> beanDependencies;
    private Hashtable<String, List<String>> beanDependedOnBy;
    private Hashtable<String, Set<String>> contextDependsOn;
    private Hashtable<String, Set<String>> contextDependedOnBy;

    public ContextDependencyLister(String[] configLocations) {
        this.configLocations = configLocations;
    }

    public ContextDependencyLister() {
        this(DEFAULT_CONFIG_LOCATIONS);
    }

    public static void main(String[] args) throws Exception {
        ContextDependencyLister lister;
        boolean beanLevel = false;
        boolean graphViz = false;
        if (args.length > 0 && "-graphviz".equals(args[0])) {
            graphViz = true;
            lister = new ContextDependencyLister();
        } else if (args.length > 0) {
            beanLevel = true;
            lister = new ContextDependencyLister(args);
        } else {
            lister = new ContextDependencyLister();
        }
        if (graphViz) {
            lister.graphVizDependencies("/tmp/context.dot");
        } else {
            lister.printDependencies(beanLevel);
        }
    }

    private void calculateDependencies() {
        String depContext;
        String parentContext;
        long startTime = System.currentTimeMillis();
        this.instance = new BeanTrackingApplicationContext(this.configLocations);
        long endTime = System.currentTimeMillis();
        NumberFormat df = NumberFormat.getNumberInstance();
        System.out.println();
        System.out.println("Loading complete");
        System.out.println("  Took " + df.format((endTime - startTime) / 1000L) + " seconds");
        System.out.println();
        this.contextBeans = new Hashtable();
        for (String bean : this.instance.btl.beanSource.keySet()) {
            String context = (String)this.instance.btl.beanSource.get(bean);
            if (!this.contextBeans.containsKey(context)) {
                this.contextBeans.put(context, new ArrayList());
            }
            this.contextBeans.get(context).add(bean);
        }
        this.beanDependencies = new Hashtable();
        this.beanDependedOnBy = new Hashtable();
        for (String parentBean : this.instance.btl.beanAllDependencies.keySet()) {
            parentContext = (String)this.instance.btl.beanSource.get(parentBean);
            if (parentContext == null) {
                System.err.println("Warning - I don't know where defined bean " + parentBean + " came from!");
                continue;
            }
            for (String depBean : (List)this.instance.btl.beanAllDependencies.get(parentBean)) {
                while (this.instance.btl.aliases.containsKey(depBean)) {
                    depBean = (String)this.instance.btl.aliases.get(depBean);
                }
                depContext = (String)this.instance.btl.beanSource.get(depBean);
                if (depContext == null) {
                    System.err.println("Warning - I don't know where depdendency " + depBean + " came from!");
                    continue;
                }
                if (depContext.equals(parentContext)) continue;
                if (!this.beanDependencies.containsKey(parentBean)) {
                    this.beanDependencies.put(parentBean, new ArrayList());
                }
                this.beanDependencies.get(parentBean).add(depBean);
                if (!this.beanDependedOnBy.containsKey(depBean)) {
                    this.beanDependedOnBy.put(depBean, new ArrayList());
                }
                this.beanDependedOnBy.get(depBean).add(parentBean);
            }
        }
        this.contextDependsOn = new Hashtable();
        this.contextDependedOnBy = new Hashtable();
        for (String parentBean : this.beanDependencies.keySet()) {
            parentContext = (String)this.instance.btl.beanSource.get(parentBean);
            for (String depBean : this.beanDependencies.get(parentBean)) {
                depContext = (String)this.instance.btl.beanSource.get(depBean);
                if (!this.contextDependsOn.containsKey(parentContext)) {
                    this.contextDependsOn.put(parentContext, new HashSet());
                }
                this.contextDependsOn.get(parentContext).add(depContext);
            }
        }
        for (String depBean : this.beanDependedOnBy.keySet()) {
            String depContext2 = (String)this.instance.btl.beanSource.get(depBean);
            for (String parentBean : this.beanDependedOnBy.get(depBean)) {
                String parentContext2 = (String)this.instance.btl.beanSource.get(parentBean);
                if (!this.contextDependedOnBy.containsKey(depContext2)) {
                    this.contextDependedOnBy.put(depContext2, new HashSet());
                }
                this.contextDependedOnBy.get(depContext2).add(parentContext2);
            }
        }
    }

    public void printDependencies(boolean beanLevel) {
        this.calculateDependencies();
        for (String context : this.instance.btl.usedContextFiles) {
            System.out.println(context);
            if (this.contextDependsOn.containsKey(context)) {
                System.out.println("  Depends on:");
                for (String ctx : this.contextDependsOn.get(context)) {
                    System.out.println("    " + ctx);
                }
            } else {
                System.out.println("  (Doesn't depend on anything)");
            }
            if (this.contextDependedOnBy.containsKey(context)) {
                System.out.println("  Depended on by:");
                for (String ctx : this.contextDependedOnBy.get(context)) {
                    System.out.println("    " + ctx);
                }
            } else {
                System.out.println("  (Nothing depends on this)");
            }
            if (beanLevel && this.contextBeans.containsKey(context)) {
                boolean hasExtDeps = false;
                for (String ourBean : this.contextBeans.get(context)) {
                    if (!this.beanDependencies.containsKey(ourBean)) continue;
                    ArrayList<String> extDep = new ArrayList<String>();
                    for (String depBean : this.beanDependencies.get(ourBean)) {
                        String depContext = (String)this.instance.btl.beanSource.get(depBean);
                        if (depContext.equals(context)) continue;
                        extDep.add(depBean + " <= " + depContext);
                    }
                    if (extDep.size() <= 0) continue;
                    if (!hasExtDeps) {
                        System.out.println("  Beans with extenal dependencies:");
                        hasExtDeps = true;
                    }
                    System.out.println("    " + ourBean);
                    for (String depBean : extDep) {
                        System.out.println("      " + depBean);
                    }
                }
                boolean hasInboundDeps = false;
                for (String ourBean : this.contextBeans.get(context)) {
                    if (!this.beanDependedOnBy.containsKey(ourBean)) continue;
                    ArrayList<String> inbDep = new ArrayList<String>();
                    for (String parentBean : this.beanDependedOnBy.get(ourBean)) {
                        String parentContext = (String)this.instance.btl.beanSource.get(parentBean);
                        if (parentContext.equals(context)) continue;
                        inbDep.add(parentBean + " <= " + parentContext);
                    }
                    if (inbDep.size() <= 0) continue;
                    if (!hasInboundDeps) {
                        System.out.println("  Beans others dependend on:");
                        hasInboundDeps = true;
                    }
                    System.out.println("    " + ourBean);
                    for (String parentBean : inbDep) {
                        System.out.println("      " + parentBean);
                    }
                }
            }
            System.out.println();
        }
    }

    public void graphVizDependencies(String outFile) throws IOException, FileNotFoundException {
        this.calculateDependencies();
        HashMap<String, String> linkBean = new HashMap<String, String>();
        for (String context : this.instance.btl.usedContextFiles) {
            if (!this.contextBeans.containsKey(context)) continue;
            for (String ourBean : this.contextBeans.get(context)) {
                if (!this.beanDependencies.containsKey(ourBean) && !this.beanDependedOnBy.containsKey(ourBean) || linkBean.containsKey(context)) continue;
                linkBean.put(context, ourBean);
            }
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(outFile)));
        out.println("digraph cluster {");
        out.println(" nodesep = \"0.2\";");
        out.println(" ranksep = \"0.3\";");
        out.println(" compound = \"true\";");
        out.println(" rankdir = \"LR\";");
        StringBuffer beanLinks = new StringBuffer();
        StringBuffer contextLinks = new StringBuffer();
        for (String context : this.instance.btl.usedContextFiles) {
            String contextId = this.makeGraphVizContextId(context);
            String contextLabel = this.makeGraphVizLabel(context);
            out.println(" subgraph " + contextId + " {");
            out.println("  label = \"" + contextLabel + "\";");
            out.println("  style = filled;");
            out.println("  color = \"azure3\";");
            out.println("  fontcolor = \"coral3\";");
            out.println("  fontname = \"Arial\";");
            out.println("  fontsize = \"15\";");
            if (this.contextDependsOn.containsKey(context)) {
                String ourBean1Id = this.makeGraphVizNodeId((String)linkBean.get(context));
                for (String ctx : this.contextDependsOn.get(context)) {
                    String theirBean1Id = this.makeGraphVizNodeId((String)linkBean.get(ctx));
                    String theirId = this.makeGraphVizContextId(ctx);
                    contextLinks.append(" " + ourBean1Id + " -> " + theirBean1Id + " [color=\"coral3\", ltail=" + contextId + ", lhead=" + theirId + "];");
                    contextLinks.append('\n');
                }
            }
            if (this.contextBeans.containsKey(context)) {
                ArrayList<String> displayBeans = new ArrayList<String>();
                for (String ourBean : this.contextBeans.get(context)) {
                    if (!this.beanDependencies.containsKey(ourBean) && !this.beanDependedOnBy.containsKey(ourBean)) continue;
                    displayBeans.add(ourBean);
                }
                if (!displayBeans.isEmpty()) {
                    for (String ourBean : displayBeans) {
                        String nodeId = this.makeGraphVizNodeId(ourBean);
                        out.println("    " + nodeId + " [label=\"" + ourBean + "\",fontsize=9];");
                        if (!this.beanDependencies.containsKey(ourBean)) continue;
                        for (String depBean : this.beanDependencies.get(ourBean)) {
                            String otherId = this.makeGraphVizNodeId(depBean);
                            beanLinks.append(" " + nodeId + " -> " + otherId + " [color=\"deepskyblue2\"];");
                            beanLinks.append('\n');
                        }
                    }
                }
            }
            out.println(" }");
            out.println();
        }
        out.print(contextLinks.toString());
        out.println();
        out.print(beanLinks.toString());
        out.println("}");
        out.close();
    }

    private String makeGraphVizContextId(String thing) {
        return "cluster" + this.makeGraphVizId(thing);
    }

    private String makeGraphVizNodeId(String thing) {
        return "n" + this.makeGraphVizId(thing);
    }

    private String makeGraphVizId(String thing) {
        return Integer.toHexString(thing.hashCode());
    }

    private String makeGraphVizLabel(String thing) {
        if (thing.length() < 45) {
            return thing;
        }
        int minSplit = 20;
        int splitAt = thing.indexOf(47);
        if (splitAt > -1 && splitAt < minSplit) {
            int newSplit = thing.substring(minSplit).indexOf(47);
            splitAt = newSplit > -1 ? minSplit + newSplit : -1;
        }
        if (splitAt == -1 || splitAt > 45) {
            splitAt = 44;
        }
        String partA = thing.substring(0, ++splitAt);
        String partB = this.makeGraphVizLabel(thing.substring(splitAt));
        return partA + "\\n" + partB;
    }

    public static class BeanTrackingListener
    implements ReaderEventListener {
        private ArrayList<String> usedContextFiles = new ArrayList();
        private ArrayList<String> importedContextFiles = new ArrayList();
        private Hashtable<String, String> beanSource = new Hashtable();
        private Hashtable<String, List<String>> beanAllDependencies = new Hashtable();
        private Hashtable<String, String> aliases = new Hashtable();
        private String pathToSlash;
        private String uriToSlash;

        public void aliasRegistered(AliasDefinition alias) {
            if (!this.aliases.containsKey(alias.getAlias())) {
                this.aliases.put(alias.getAlias(), alias.getBeanName());
            }
        }

        public void componentRegistered(ComponentDefinition paramComponentDefinition) {
            String name = paramComponentDefinition.getName();
            for (BeanDefinition bd : paramComponentDefinition.getBeanDefinitions()) {
                this.processBeanDefinition(name, bd);
            }
        }

        private void processBeanDefinition(String beanName, BeanDefinition bd) {
            Object v;
            String resource = bd.getResourceDescription();
            int openSB = resource.indexOf(91);
            int closeSB = resource.indexOf(93);
            if (openSB > -1 && closeSB > -1 && openSB < closeSB) {
                String source = resource.substring(openSB + 1, closeSB);
                if (this.pathToSlash != null) {
                    if (source.startsWith(this.pathToSlash)) {
                        source = source.replace(this.pathToSlash, "");
                    }
                    if (source.startsWith(this.uriToSlash)) {
                        source = source.replace(this.uriToSlash, "");
                    }
                }
                this.beanSource.put(beanName, source);
                if (!this.usedContextFiles.contains(source)) {
                    this.usedContextFiles.add(source);
                }
            } else {
                System.err.println("Unknown resource location:\n\t" + resource);
            }
            ArrayList<String> refs = new ArrayList<String>();
            if (!bd.getConstructorArgumentValues().isEmpty()) {
                for (ConstructorArgumentValues.ValueHolder vh : bd.getConstructorArgumentValues().getGenericArgumentValues()) {
                    v = vh.getValue();
                    this.addRefIfNeeded(v, refs);
                }
                for (ConstructorArgumentValues.ValueHolder vh : bd.getConstructorArgumentValues().getIndexedArgumentValues().values()) {
                    v = vh.getValue();
                    this.addRefIfNeeded(v, refs);
                }
            }
            if (!bd.getPropertyValues().isEmpty()) {
                for (PropertyValue pv : bd.getPropertyValues().getPropertyValueList()) {
                    v = pv.getValue();
                    this.addRefIfNeeded(v, refs);
                }
            }
            if (bd.getParentName() != null) {
                this.addRefIfNeeded(bd.getParentName(), refs);
            }
            if (!refs.isEmpty()) {
                this.beanAllDependencies.put(beanName, refs);
            }
        }

        private void addRefIfNeeded(String beanName, List<String> refs) {
            if (beanName == null) {
                return;
            }
            if (beanName.length() > 0) {
                if (beanName.charAt(0) == '&') {
                    beanName = beanName.substring(1);
                }
                refs.add(beanName);
            }
        }

        private void addRefIfNeeded(Object v, List<String> refs) {
            if (v == null) {
                return;
            }
            if (v instanceof RuntimeBeanReference) {
                RuntimeBeanReference r = (RuntimeBeanReference)v;
                String name = r.getBeanName();
                this.addRefIfNeeded(name, refs);
                if (name == null || name.length() == 0) {
                    System.err.println("Warning - empty reference " + r);
                }
            } else if (v instanceof BeanDefinitionHolder) {
                BeanDefinitionHolder bdh = (BeanDefinitionHolder)v;
                this.processBeanDefinition(bdh.getBeanName(), bdh.getBeanDefinition());
            } else if (v instanceof ManagedList) {
                ManagedList ml = (ManagedList)v;
                for (Object le : ml) {
                    this.addRefIfNeeded(le, refs);
                }
            }
        }

        public void defaultsRegistered(DefaultsDefinition paramDefaultsDefinition) {
        }

        public void importProcessed(ImportDefinition paramImportDefinition) {
            String context = paramImportDefinition.getImportedResource();
            if (context.startsWith("classpath:")) {
                context = context.substring(10);
                if (this.pathToSlash == null) {
                    URL c = ContextDependencyLister.class.getClassLoader().getResource(context);
                    this.uriToSlash = c.toString().replace(context, "");
                    this.pathToSlash = c.getPath().replace(context, "");
                }
            }
            if (context.startsWith("classpath*:")) {
                context = context.substring(11);
            }
            if (!this.usedContextFiles.contains(context)) {
                this.usedContextFiles.add(context);
            }
            this.importedContextFiles.add(context);
        }
    }

    public static class BeanTrackingApplicationContext
    extends ClassPathXmlApplicationContext {
        private BeanTrackingListener btl;

        public BeanTrackingApplicationContext(String[] locations) {
            super(locations);
        }

        protected void initBeanDefinitionReader(XmlBeanDefinitionReader reader) {
            super.initBeanDefinitionReader(reader);
            this.btl = new BeanTrackingListener();
            reader.setEventListener((ReaderEventListener)this.btl);
            try {
                Field f = reader.getClass().getDeclaredField("eventListener");
                f.setAccessible(true);
                f.set(reader, this.btl);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

