/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.params.DefaultHttpParamsFactory;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientHelper {
    private static Log logger = LogFactory.getLog(HttpClientHelper.class);
    private static ThreadLocal<HttpClient> httpClient = new ThreadLocal<HttpClient>(){

        @Override
        protected HttpClient initialValue() {
            logger.debug((Object)("Creating HttpClient instance for thread: " + Thread.currentThread().getName()));
            return new HttpClient((HttpClientParams)new NonBlockingHttpParams());
        }
    };

    public static HttpClient getHttpClient() {
        return httpClient.get();
    }

    public static class NonBlockingHttpParams
    extends HttpClientParams {
        private HashMap<String, Object> parameters = new HashMap(8);
        private ReadWriteLock paramLock = new ReentrantReadWriteLock();

        public NonBlockingHttpParams() {
        }

        public NonBlockingHttpParams(HttpParams defaults) {
            super(defaults);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getParameter(String name) {
            HttpParams defaults;
            Object param = null;
            this.paramLock.readLock().lock();
            try {
                param = this.parameters.get(name);
            }
            finally {
                this.paramLock.readLock().unlock();
            }
            if (param == null && (defaults = this.getDefaults()) != null) {
                param = defaults.getParameter(name);
            }
            return param;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setParameter(String name, Object value) {
            this.paramLock.writeLock().lock();
            try {
                this.parameters.put(name, value);
            }
            finally {
                this.paramLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isParameterSetLocally(String name) {
            this.paramLock.readLock().lock();
            try {
                boolean bl = this.parameters.get(name) != null;
                return bl;
            }
            finally {
                this.paramLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            this.paramLock.writeLock().lock();
            try {
                this.parameters.clear();
            }
            finally {
                this.paramLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object clone() throws CloneNotSupportedException {
            NonBlockingHttpParams clone = (NonBlockingHttpParams)((Object)super.clone());
            this.paramLock.readLock().lock();
            try {
                clone.parameters = (HashMap)this.parameters.clone();
            }
            finally {
                this.paramLock.readLock().unlock();
            }
            clone.setDefaults(this.getDefaults());
            return clone;
        }
    }

    public static class NonBlockingHttpParamsFactory
    extends DefaultHttpParamsFactory {
        private volatile HttpParams httpParams;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpParams getDefaultParams() {
            if (this.httpParams == null) {
                NonBlockingHttpParamsFactory nonBlockingHttpParamsFactory = this;
                synchronized (nonBlockingHttpParamsFactory) {
                    if (this.httpParams == null) {
                        this.httpParams = this.createParams();
                    }
                }
            }
            return this.httpParams;
        }

        protected HttpParams createParams() {
            NonBlockingHttpParams params = new NonBlockingHttpParams(null);
            params.setParameter("http.useragent", "Spring Surf via Apache HttpClient/3.1");
            params.setVersion(HttpVersion.HTTP_1_1);
            params.setConnectionManagerClass(SimpleHttpConnectionManager.class);
            params.setCookiePolicy("ignoreCookies");
            params.setHttpElementCharset("US-ASCII");
            params.setContentCharset("ISO-8859-1");
            params.setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler());
            List<String> datePatterns = Arrays.asList("EEE, dd MMM yyyy HH:mm:ss zzz", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MMM-yyyy HH-mm-ss z", "EEE, dd MMM yy HH:mm:ss z", "EEE dd-MMM-yyyy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss z", "EEE dd-MMM-yyyy HH-mm-ss z", "EEE dd-MMM-yy HH:mm:ss z", "EEE dd MMM yy HH:mm:ss z", "EEE,dd-MMM-yy HH:mm:ss z", "EEE,dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MM-yyyy HH:mm:ss z");
            params.setParameter("http.dateparser.patterns", datePatterns);
            String agent = null;
            try {
                agent = System.getProperty("httpclient.useragent");
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            if (agent != null) {
                params.setParameter("http.useragent", agent);
            }
            String preemptiveDefault = null;
            try {
                preemptiveDefault = System.getProperty("httpclient.authentication.preemptive");
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            if (preemptiveDefault != null) {
                if ((preemptiveDefault = preemptiveDefault.trim().toLowerCase()).equals("true")) {
                    params.setParameter("http.authentication.preemptive", Boolean.TRUE);
                } else if (preemptiveDefault.equals("false")) {
                    params.setParameter("http.authentication.preemptive", Boolean.FALSE);
                }
            }
            String defaultCookiePolicy = null;
            try {
                defaultCookiePolicy = System.getProperty("apache.commons.httpclient.cookiespec");
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            if (defaultCookiePolicy != null) {
                if ("COMPATIBILITY".equalsIgnoreCase(defaultCookiePolicy)) {
                    params.setCookiePolicy("compatibility");
                } else if ("NETSCAPE_DRAFT".equalsIgnoreCase(defaultCookiePolicy)) {
                    params.setCookiePolicy("netscape");
                } else if ("RFC2109".equalsIgnoreCase(defaultCookiePolicy)) {
                    params.setCookiePolicy("rfc2109");
                }
            }
            return params;
        }
    }
}

