/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.util.OpenOfficeURI;
import org.alfresco.util.OpenOfficeVariant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenOfficeCommandLine
extends AbstractMap<String, List<String>> {
    private static final Log logger = LogFactory.getLog(OpenOfficeCommandLine.class);
    private Map<String, List<String>> map = new HashMap<String, List<String>>();
    private OpenOfficeVariant variant = new OpenOfficeVariant();

    public OpenOfficeCommandLine(String exe, String port, String user) throws IOException {
        File executable = this.variant.findExecutable(exe);
        File officeHome = this.variant.getOfficeHome(executable);
        ArrayList<String> command = new ArrayList<String>();
        String acceptValue = "socket,host=127.0.0.1,port=" + port + ";urp;StarOffice.ServiceManager";
        String userInstallation = new OpenOfficeURI(user).toString();
        command.add(executable == null ? exe : executable.getAbsolutePath());
        if (this.variant.isLibreOffice3Dot5(officeHome)) {
            command.add("--accept=" + acceptValue);
            if (this.variant.isMac() && !this.variant.isLibreOffice3Dot6(officeHome)) {
                command.add("--env:UserInstallation=" + userInstallation);
            } else {
                command.add("-env:UserInstallation=" + userInstallation);
            }
            command.add("--headless");
            command.add("--nocrashreport");
            command.add("--nofirststartwizard");
            command.add("--nologo");
            command.add("--norestore");
            logger.info((Object)("Using GNU based LibreOffice " + (this.variant.isLibreOffice3Dot6(officeHome) ? "3.6" : "3.5") + " command" + (this.variant.isMac() ? " on Mac" : "") + ": " + command));
        } else {
            command.add("-accept=" + acceptValue);
            command.add("-env:UserInstallation=" + userInstallation);
            command.add("-headless");
            command.add("-nocrashreport");
            command.add("-nofirststartwizard");
            command.add("-nologo");
            command.add("-norestore");
            logger.info((Object)("Using original OpenOffice command: " + command));
        }
        this.map.put("*", command);
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.map.entrySet();
    }
}

