/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;

public class PropertyMap
extends HashMap<QName, Serializable> {
    private static final long serialVersionUID = 8052326301073209645L;
    public static final Map<QName, Serializable> EMPTY_MAP = Collections.emptyMap();

    public PropertyMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public PropertyMap(int initialCapacity) {
        super(initialCapacity);
    }

    public PropertyMap() {
    }

    public static Pair<Map<QName, Serializable>, Map<QName, Serializable>> getBeforeAndAfterMapsForChanges(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (before == null) {
            before = Collections.emptyMap();
        }
        if (after == null) {
            after = Collections.emptyMap();
        }
        HashMap<QName, Serializable> afterDelta = new HashMap<QName, Serializable>(after);
        afterDelta.entrySet().removeAll(before.entrySet());
        HashMap<Object, Serializable> beforeDelta = new HashMap<Object, Serializable>(before);
        beforeDelta.entrySet().removeAll(after.entrySet());
        return new Pair(beforeDelta, afterDelta);
    }

    public static Map<QName, Serializable> getAddedProperties(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>();
        if (before != null && after != null) {
            result.putAll(after);
            result.keySet().removeAll(before.keySet());
        }
        return result;
    }

    public static Map<QName, Serializable> getRemovedProperties(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>();
        if (before != null && after != null) {
            result.putAll(before);
            result.keySet().removeAll(after.keySet());
        }
        return result;
    }

    public static Map<QName, Serializable> getChangedProperties(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>();
        if (before != null && after != null) {
            HashMap<QName, Serializable> intersection = new HashMap<QName, Serializable>();
            intersection.putAll(after);
            intersection.keySet().retainAll(before.keySet());
            for (Map.Entry entry : intersection.entrySet()) {
                if (EqualsHelper.nullSafeEquals((Object)before.get(entry.getKey()), (Object)after.get(entry.getKey()))) continue;
                result.put((QName)entry.getKey(), (Serializable)entry.getValue());
            }
        }
        return result;
    }

    public static Map<QName, Serializable> getUnchangedProperties(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>();
        if (before != null && after != null) {
            HashMap<QName, Serializable> intersection = new HashMap<QName, Serializable>();
            intersection.putAll(before);
            intersection.keySet().retainAll(after.keySet());
            for (Map.Entry entry : intersection.entrySet()) {
                if (!EqualsHelper.nullSafeEquals((Object)before.get(entry.getKey()), (Object)after.get(entry.getKey()))) continue;
                result.put((QName)entry.getKey(), (Serializable)entry.getValue());
            }
        }
        return result;
    }
}

