/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.validator.NameValidator;
import org.alfresco.util.schemacomp.validator.SchemaVersionValidator;

public class Schema
extends AbstractDbObject
implements Iterable<DbObject> {
    protected final List<DbObject> objects = new ArrayList<DbObject>();
    protected final String dbPrefix;
    protected final int version;
    protected final boolean checkTableColumnOrder;

    public Schema(String name) {
        this(name, "", 0, true);
    }

    public Schema(String name, String dbPrefix, int schemaVersion, boolean checkTableColumnOrder) {
        super(null, name);
        ParameterCheck.mandatory((String)"dbPrefix", (Object)dbPrefix);
        this.dbPrefix = dbPrefix;
        this.version = schemaVersion;
        this.checkTableColumnOrder = checkTableColumnOrder;
        this.addDefaultValidators();
    }

    private void addDefaultValidators() {
        NameValidator nameValidator = new NameValidator();
        nameValidator.setPattern(Pattern.compile(".*"));
        this.getValidators().add(nameValidator);
        SchemaVersionValidator versionValidator = new SchemaVersionValidator();
        this.getValidators().add(versionValidator);
    }

    public void add(DbObject dbObject) {
        dbObject.setParent(this);
        this.objects.add(dbObject);
    }

    @Override
    public Iterator<DbObject> iterator() {
        return this.objects.iterator();
    }

    public boolean contains(DbObject object) {
        return this.objects.contains(object);
    }

    public String getDbPrefix() {
        return this.dbPrefix;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isCheckTableColumnOrder() {
        return this.checkTableColumnOrder;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dbPrefix == null ? 0 : this.dbPrefix.hashCode());
        result = 31 * result + (this.objects == null ? 0 : this.objects.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Schema other = (Schema)obj;
        if (this.dbPrefix == null ? other.dbPrefix != null : !this.dbPrefix.equals(other.dbPrefix)) {
            return false;
        }
        if (this.objects == null ? other.objects != null : !this.objects.equals(other.objects)) {
            return false;
        }
        return this.version == other.version;
    }

    @Override
    protected void doDiff(DbObject right, DiffContext ctx) {
        Schema rightSchema = (Schema)right;
        this.comparisonUtils.compareSimple(new DbProperty(this, "version"), new DbProperty(rightSchema, "version"), ctx);
        this.comparisonUtils.compareCollections(this.objects, rightSchema.objects, ctx);
    }

    @Override
    public void accept(DbObjectVisitor visitor) {
        visitor.visit(this);
        for (DbObject child : this.objects) {
            child.accept(visitor);
        }
    }

    @Override
    public boolean sameAs(DbObject other) {
        return other != null && other.getClass().equals(this.getClass());
    }

    public boolean containsByName(String name) {
        Iterator<DbObject> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

