/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.actions;

import java.util.List;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.wcm.util.WCMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WCMSandboxRevertSnapshotAction
extends ActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(WCMSandboxRevertSnapshotAction.class);
    public static final String NAME = "wcm-revert-snapshot";
    public static final String PARAM_VERSION = "version";
    private SandboxService sbService;

    public void setSandboxService(SandboxService sbService) {
        this.sbService = sbService;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        Pair<Integer, String> pathVersion = AVMNodeConverter.ToAVMVersionPath(actionedUponNodeRef);
        if ((Integer)pathVersion.getFirst() != -1) {
            logger.warn((Object)("Ignored version " + pathVersion.getFirst() + " for " + actionedUponNodeRef + " (will revert latest)"));
        }
        int revertVersion = (Integer)action.getParameterValue(PARAM_VERSION);
        String sbStoreId = WCMUtil.getSandboxStoreId((String)pathVersion.getSecond());
        this.sbService.revertSnapshot(sbStoreId, revertVersion);
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_VERSION, DataTypeDefinition.INT, true, this.getParamDisplayLabel(PARAM_VERSION)));
    }
}

