/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.asset;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.mbeans.VirtServerRegistry;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.ImporterActionExecuter;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.asset.AssetInfoImpl;
import org.alfresco.wcm.asset.AssetService;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.alfresco.wcm.util.WCMUtil;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.springframework.extensions.surf.util.ParameterCheck;

public class AssetServiceImpl
implements AssetService {
    private static char PATH_SEPARATOR = (char)47;
    private static final int BUFFER_SIZE = 16384;
    private AVMService avmService;
    private AVMLockingService avmLockingService;
    private NodeService avmNodeService;
    private VirtServerRegistry virtServerRegistry;

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setAvmLockingService(AVMLockingService avmLockingService) {
        this.avmLockingService = avmLockingService;
    }

    public void setNodeService(NodeService avmNodeService) {
        this.avmNodeService = avmNodeService;
    }

    public void setVirtServerRegistry(VirtServerRegistry virtServerRegistry) {
        this.virtServerRegistry = virtServerRegistry;
    }

    private void checkMandatoryPath(String path) {
        ParameterCheck.mandatoryString((String)"path", (String)path);
        if (path.indexOf(58) != -1) {
            throw new IllegalArgumentException("Unexpected path '" + path + "' - should not contain '" + ":" + "'");
        }
    }

    private boolean isWebProjectStagingSandbox(String sbStoreId) {
        PropertyValue propVal = this.avmService.getStoreProperty(sbStoreId, SandboxConstants.PROP_WEB_PROJECT_NODE_REF);
        return propVal != null && WCMUtil.isStagingStore(sbStoreId);
    }

    @Override
    public void createFolderWebApp(String sbStoreId, String webApp, String parentFolderPathRelativeToWebApp, String name) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"webApp", (String)webApp);
        this.checkMandatoryPath(parentFolderPathRelativeToWebApp);
        ParameterCheck.mandatoryString((String)"name", (String)name);
        if (this.isWebProjectStagingSandbox(sbStoreId)) {
            throw new AccessDeniedException("Not allowed to write in: " + sbStoreId);
        }
        parentFolderPathRelativeToWebApp = AVMUtil.addLeadingSlash(parentFolderPathRelativeToWebApp);
        String avmParentPath = WCMUtil.buildStoreWebappPath(sbStoreId, webApp) + parentFolderPathRelativeToWebApp;
        this.createFolderAVM(avmParentPath, name, null);
    }

    @Override
    public void createFolder(String sbStoreId, String parentFolderPath, String name, Map<QName, Serializable> properties) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"parentFolderPath", (String)parentFolderPath);
        ParameterCheck.mandatoryString((String)"name", (String)name);
        String avmParentPath = AVMUtil.buildAVMPath(sbStoreId, parentFolderPath);
        this.createFolderAVM(avmParentPath, name, properties);
    }

    private void createFolderAVM(String avmParentPath, String name, Map<QName, Serializable> properties) {
        ParameterCheck.mandatoryString((String)"avmParentPath", (String)avmParentPath);
        ParameterCheck.mandatoryString((String)"name", (String)name);
        String sbStoreId = WCMUtil.getSandboxStoreId(avmParentPath);
        if (!this.isWebProjectStagingSandbox(sbStoreId)) {
            this.avmService.createDirectory(avmParentPath, name);
            String avmPath = avmParentPath + PATH_SEPARATOR + name;
            this.avmService.addAspect(avmPath, ApplicationModel.ASPECT_UIFACETS);
            if (properties != null && properties.size() > 0) {
                this.setProperties(avmPath, properties);
            }
        } else {
            throw new AccessDeniedException("Not allowed to write in: " + sbStoreId);
        }
    }

    @Override
    public ContentWriter createFileWebApp(String sbStoreId, String webApp, String parentFolderPathRelativeToWebApp, String name) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"webApp", (String)webApp);
        ParameterCheck.mandatoryString((String)"parentFolderPathRelativeToWebApp", (String)parentFolderPathRelativeToWebApp);
        ParameterCheck.mandatoryString((String)"name", (String)name);
        parentFolderPathRelativeToWebApp = AVMUtil.addLeadingSlash(parentFolderPathRelativeToWebApp);
        String avmParentPath = WCMUtil.buildStoreWebappPath(sbStoreId, webApp) + parentFolderPathRelativeToWebApp;
        this.createFileAVM(avmParentPath, name);
        String avmPath = avmParentPath + PATH_SEPARATOR + name;
        return this.avmService.getContentWriter(avmPath, true);
    }

    @Override
    public ContentWriter createFile(String sbStoreId, String parentFolderPath, String name, Map<QName, Serializable> properties) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"parentFolderPath", (String)parentFolderPath);
        ParameterCheck.mandatoryString((String)"name", (String)name);
        String avmParentPath = AVMUtil.buildAVMPath(sbStoreId, parentFolderPath);
        this.createFileAVM(avmParentPath, name);
        String avmPath = avmParentPath + PATH_SEPARATOR + name;
        if (properties != null && properties.size() > 0) {
            this.setProperties(avmPath, properties);
        }
        return this.avmService.getContentWriter(avmPath, true);
    }

    private void createFileAVM(String avmParentPath, String name) {
        ParameterCheck.mandatoryString((String)"avmParentPath", (String)avmParentPath);
        ParameterCheck.mandatoryString((String)"name", (String)name);
        String sbStoreId = WCMUtil.getSandboxStoreId(avmParentPath);
        if (!this.isWebProjectStagingSandbox(sbStoreId)) {
            try {
                this.avmService.createFile(avmParentPath, name).close();
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("I/O Error.", (Throwable)e);
            }
        } else {
            throw new AccessDeniedException("Not allowed to write in: " + sbStoreId);
        }
    }

    private void createFileAVM(String avmParentPath, String name, InputStream in) {
        ParameterCheck.mandatoryString((String)"avmParentPath", (String)avmParentPath);
        String sbStoreId = WCMUtil.getSandboxStoreId(avmParentPath);
        if (this.isWebProjectStagingSandbox(sbStoreId)) {
            throw new AccessDeniedException("Not allowed to write in: " + sbStoreId);
        }
        this.avmService.createFile(avmParentPath, name, in, null, null);
    }

    @Override
    public ContentWriter getContentWriter(AssetInfo asset) {
        ParameterCheck.mandatory((String)"asset", (Object)asset);
        if (!this.isWebProjectStagingSandbox(asset.getSandboxId())) {
            return this.avmService.getContentWriter(asset.getAvmPath(), true);
        }
        throw new AccessDeniedException("Not allowed to write in: " + asset.getSandboxId());
    }

    @Override
    public ContentReader getContentReader(AssetInfo asset) {
        ParameterCheck.mandatory((String)"asset", (Object)asset);
        return this.avmService.getContentReader(asset.getSandboxVersion(), asset.getAvmPath());
    }

    @Override
    public AssetInfo getAssetWebApp(String sbStoreId, String webApp, String pathRelativeToWebApp) {
        return this.getAssetWebApp(sbStoreId, webApp, pathRelativeToWebApp, false);
    }

    @Override
    public AssetInfo getAssetWebApp(String sbStoreId, String webApp, String pathRelativeToWebApp, boolean includeDeleted) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"webApp", (String)webApp);
        ParameterCheck.mandatoryString((String)"pathRelativeToWebApp", (String)pathRelativeToWebApp);
        pathRelativeToWebApp = AVMUtil.addLeadingSlash(pathRelativeToWebApp);
        String avmPath = WCMUtil.buildStoreWebappPath(sbStoreId, webApp) + pathRelativeToWebApp;
        return this.getAssetAVM(-1, avmPath, includeDeleted);
    }

    @Override
    public AssetInfo getAsset(String sbStoreId, String path) {
        return this.getAsset(sbStoreId, -1, path, false);
    }

    @Override
    public AssetInfo getAsset(String sbStoreId, int version, String path, boolean includeDeleted) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"path", (String)path);
        String avmPath = AVMUtil.buildAVMPath(sbStoreId, path);
        return this.getAssetAVM(version, avmPath, includeDeleted);
    }

    private AssetInfo getAssetAVM(int version, String avmPath, boolean includeDeleted) {
        ParameterCheck.mandatoryString((String)"avmPath", (String)avmPath);
        AVMNodeDescriptor node = this.avmService.lookup(version, avmPath, includeDeleted);
        AssetInfoImpl asset = null;
        if (node != null) {
            String lockOwner = null;
            if (this.avmLockingService != null) {
                String wpStoreId = WCMUtil.getWebProjectStoreIdFromPath(avmPath);
                String[] parts = WCMUtil.splitPath(avmPath);
                lockOwner = this.getLockOwner(wpStoreId, parts[1]);
            }
            asset = new AssetInfoImpl(version, node, lockOwner);
        }
        return asset;
    }

    @Override
    public String getLockOwner(AssetInfo asset) {
        ParameterCheck.mandatory((String)"asset", (Object)asset);
        return this.getLockOwner(WCMUtil.getWebProjectStoreId(asset.getSandboxId()), asset.getPath());
    }

    private String getLockOwner(String wpStoreId, String filePath) {
        return this.avmLockingService.getLockOwner(wpStoreId, filePath);
    }

    @Override
    public boolean hasLockAccess(AssetInfo asset) {
        ParameterCheck.mandatory((String)"asset", (Object)asset);
        return this.avmLockingService.hasAccess(WCMUtil.getWebProjectStoreId(asset.getSandboxId()), asset.getAvmPath(), AuthenticationUtil.getFullyAuthenticatedUser());
    }

    @Override
    public void updateAssetProperties(AssetInfo asset, Map<QName, Serializable> properties) {
        ParameterCheck.mandatory((String)"asset", (Object)asset);
        ParameterCheck.mandatory((String)"properties", properties);
        NodeRef avmNodeRef = AVMNodeConverter.ToNodeRef(-1, asset.getAvmPath());
        for (Map.Entry<QName, Serializable> prop : properties.entrySet()) {
            this.avmNodeService.setProperty(avmNodeRef, prop.getKey(), prop.getValue());
        }
    }

    @Override
    public void setAssetProperties(AssetInfo asset, Map<QName, Serializable> properties) {
        ParameterCheck.mandatory((String)"asset", (Object)asset);
        ParameterCheck.mandatory((String)"properties", properties);
        this.setProperties(asset.getAvmPath(), properties);
    }

    private void setProperties(String avmPath, Map<QName, Serializable> properties) {
        NodeRef avmNodeRef = AVMNodeConverter.ToNodeRef(-1, avmPath);
        this.avmNodeService.setProperties(avmNodeRef, properties);
    }

    @Override
    public void addAspect(AssetInfo asset, QName aspectName, Map<QName, Serializable> properties) {
        this.addAspect(asset.getAvmPath(), aspectName, properties);
    }

    private void addAspect(String avmPath, QName aspect, Map<QName, Serializable> properties) {
        NodeRef avmNodeRef = AVMNodeConverter.ToNodeRef(-1, avmPath);
        this.avmNodeService.addAspect(avmNodeRef, aspect, properties);
    }

    @Override
    public void removeAspect(AssetInfo asset, QName aspectName) {
        ParameterCheck.mandatory((String)"asset", (Object)asset);
        NodeRef avmNodeRef = AVMNodeConverter.ToNodeRef(-1, asset.getAvmPath());
        this.avmNodeService.removeAspect(avmNodeRef, aspectName);
    }

    @Override
    public Set<QName> getAspects(AssetInfo asset) {
        ParameterCheck.mandatory((String)"asset", (Object)asset);
        NodeRef avmNodeRef = AVMNodeConverter.ToNodeRef(asset.getSandboxVersion(), asset.getAvmPath());
        return this.avmNodeService.getAspects(avmNodeRef);
    }

    @Override
    public boolean hasAspect(AssetInfo asset, QName aspectName) {
        ParameterCheck.mandatory((String)"asset", (Object)asset);
        NodeRef avmNodeRef = AVMNodeConverter.ToNodeRef(asset.getSandboxVersion(), asset.getAvmPath());
        return this.avmNodeService.hasAspect(avmNodeRef, aspectName);
    }

    @Override
    public Map<QName, Serializable> getAssetProperties(AssetInfo asset) {
        ParameterCheck.mandatory((String)"asset", (Object)asset);
        return this.getProperties(asset.getSandboxVersion(), asset.getAvmPath());
    }

    private Map<QName, Serializable> getProperties(int version, String avmPath) {
        NodeRef avmNodeRef = AVMNodeConverter.ToNodeRef(version, avmPath);
        return this.avmNodeService.getProperties(avmNodeRef);
    }

    @Override
    public List<AssetInfo> listAssetsWebApp(String sbStoreId, String webApp, String parentFolderPathRelativeToWebApp, boolean includeDeleted) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"webApp", (String)webApp);
        ParameterCheck.mandatoryString((String)"parentFolderPathRelativeToWebApp", (String)parentFolderPathRelativeToWebApp);
        parentFolderPathRelativeToWebApp = AVMUtil.addLeadingSlash(parentFolderPathRelativeToWebApp);
        String avmPath = WCMUtil.buildStoreWebappPath(sbStoreId, webApp) + parentFolderPathRelativeToWebApp;
        return this.listAssetsAVM(-1, avmPath, includeDeleted);
    }

    @Override
    public List<AssetInfo> listAssets(String sbStoreId, String parentFolderPath, boolean includeDeleted) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"parentFolderPath", (String)parentFolderPath);
        String avmPath = AVMUtil.buildAVMPath(sbStoreId, parentFolderPath);
        return this.listAssetsAVM(-1, avmPath, includeDeleted);
    }

    @Override
    public List<AssetInfo> listAssets(String sbStoreId, int version, String parentFolderPath, boolean includeDeleted) {
        ParameterCheck.mandatoryString((String)"sbStoreId", (String)sbStoreId);
        ParameterCheck.mandatoryString((String)"parentFolderPath", (String)parentFolderPath);
        String avmPath = AVMUtil.buildAVMPath(sbStoreId, parentFolderPath);
        return this.listAssetsAVM(version, avmPath, includeDeleted);
    }

    private List<AssetInfo> listAssetsAVM(int version, String avmPath, boolean includeDeleted) {
        ParameterCheck.mandatoryString((String)"avmPath", (String)avmPath);
        SortedMap<String, AVMNodeDescriptor> nodes = this.avmService.getDirectoryListing(version, avmPath, includeDeleted);
        ArrayList<AssetInfo> assets = new ArrayList<AssetInfo>(nodes.size());
        for (AVMNodeDescriptor node : nodes.values()) {
            String lockOwner = null;
            if (this.avmLockingService != null) {
                String wpStoreId = WCMUtil.getWebProjectStoreIdFromPath(avmPath);
                String[] parts = WCMUtil.splitPath(avmPath);
                lockOwner = this.getLockOwner(wpStoreId, parts[1]);
            }
            assets.add(new AssetInfoImpl(version, node, lockOwner));
        }
        return assets;
    }

    @Override
    public void deleteAsset(AssetInfo asset) {
        ParameterCheck.mandatory((String)"asset", (Object)asset);
        if (this.isWebProjectStagingSandbox(asset.getSandboxId())) {
            throw new AccessDeniedException("Not allowed to write in: " + asset.getSandboxId());
        }
        this.avmService.removeNode(asset.getAvmPath());
    }

    @Override
    public AssetInfo renameAsset(AssetInfo asset, String newName) {
        ParameterCheck.mandatory((String)"asset", (Object)asset);
        if (!this.isWebProjectStagingSandbox(asset.getSandboxId())) {
            String avmParentPath = AVMUtil.splitBase(asset.getAvmPath())[0];
            String oldName = asset.getName();
            this.avmService.rename(avmParentPath, oldName, avmParentPath, newName);
            return this.getAsset(asset.getSandboxId(), WCMUtil.getStoreRelativePath(avmParentPath) + "/" + newName);
        }
        throw new AccessDeniedException("Not allowed to write in: " + asset.getSandboxId());
    }

    @Override
    public AssetInfo moveAsset(AssetInfo asset, String parentFolderPath) {
        ParameterCheck.mandatory((String)"asset", (Object)asset);
        if (!this.isWebProjectStagingSandbox(asset.getSandboxId())) {
            String avmDstPath = AVMUtil.buildAVMPath(asset.getSandboxId(), parentFolderPath);
            String avmSrcPath = AVMUtil.splitBase(asset.getAvmPath())[0];
            String name = asset.getName();
            this.avmService.rename(avmSrcPath, name, avmDstPath, name);
            return this.getAsset(asset.getSandboxId(), WCMUtil.getStoreRelativePath(avmDstPath) + "/" + name);
        }
        throw new AccessDeniedException("Not allowed to write in: " + asset.getSandboxId());
    }

    @Override
    public AssetInfo copyAsset(AssetInfo asset, String parentFolderPath) {
        ParameterCheck.mandatory((String)"asset", (Object)asset);
        if (!this.isWebProjectStagingSandbox(asset.getSandboxId())) {
            String avmDstParentPath = AVMUtil.buildAVMPath(asset.getSandboxId(), parentFolderPath);
            String avmSrcPath = asset.getAvmPath();
            String name = asset.getName();
            this.avmService.copy(-1, avmSrcPath, avmDstParentPath, name);
            return this.getAsset(asset.getSandboxId(), WCMUtil.getStoreRelativePath(avmDstParentPath + "/" + name));
        }
        throw new AccessDeniedException("Not allowed to write in: " + asset.getSandboxId());
    }

    @Override
    public void bulkImport(String sbStoreId, String parentFolderPath, File zipFile, boolean isHighByteZip) {
        if (this.isWebProjectStagingSandbox(sbStoreId)) {
            throw new AccessDeniedException("Not allowed to write in: " + sbStoreId);
        }
        String avmDstPath = AVMUtil.buildAVMPath(sbStoreId, parentFolderPath);
        NodeRef importRef = AVMNodeConverter.ToNodeRef(-1, avmDstPath);
        this.processZipImport(zipFile, isHighByteZip, importRef);
        this.avmService.createSnapshot(sbStoreId, "Import of file: " + zipFile.getName(), null);
        UpdateSandboxTransactionListener tl = new UpdateSandboxTransactionListener(avmDstPath);
        AlfrescoTransactionSupport.bindListener(tl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processZipImport(File file, boolean isHighByteZip, NodeRef rootRef) {
        try {
            ZipFile zipFile = new ZipFile(file, isHighByteZip ? "Cp437" : null, true);
            File alfTempDir = TempFileProvider.getTempDir();
            File tempDir = new File(alfTempDir.getPath() + File.separatorChar + file.getName() + "_unpack");
            try {
                ImporterActionExecuter.extractFile(zipFile, tempDir.getPath());
                this.importDirectory(tempDir.getPath(), rootRef);
            }
            finally {
                if (tempDir.exists()) {
                    ImporterActionExecuter.deleteDir(tempDir);
                }
            }
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Unable to process Zip file. File may not be of the expected format.", (Throwable)e);
        }
    }

    private void importDirectory(String dir, NodeRef root) {
        File topdir = new File(dir);
        if (!topdir.exists()) {
            return;
        }
        for (File file : topdir.listFiles()) {
            try {
                String avmPath;
                if (file.isFile()) {
                    avmPath = (String)AVMNodeConverter.ToAVMVersionPath(root).getSecond();
                    String fileName = file.getName();
                    HashMap<QName, Serializable> titledProps = new HashMap<QName, Serializable>();
                    titledProps.put(ContentModel.PROP_TITLE, (Serializable)((Object)fileName));
                    this.createFileAVM(avmPath, fileName, new BufferedInputStream(new FileInputStream(file), 16384));
                    String filePath = avmPath + '/' + fileName;
                    this.addAspect(filePath, ContentModel.ASPECT_TITLED, titledProps);
                    continue;
                }
                avmPath = (String)AVMNodeConverter.ToAVMVersionPath(root).getSecond();
                this.createFolderAVM(avmPath, file.getName(), null);
                String folderPath = avmPath + '/' + file.getName();
                NodeRef folderRef = AVMNodeConverter.ToNodeRef(-1, folderPath);
                this.importDirectory(file.getPath(), folderRef);
            }
            catch (FileNotFoundException e) {
                throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
            }
            catch (FileExistsException e) {
                throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
            }
        }
    }

    private class UpdateSandboxTransactionListener
    extends TransactionListenerAdapter {
        private String virtUpdatePath;

        public UpdateSandboxTransactionListener(String virtUpdatePath) {
            this.virtUpdatePath = virtUpdatePath;
        }

        @Override
        public void afterCommit() {
            if (this.virtUpdatePath != null) {
                WCMUtil.updateVServerWebapp(AssetServiceImpl.this.virtServerRegistry, this.virtUpdatePath, true);
            }
        }
    }
}

