/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.webproject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.mbeans.VirtServerRegistry;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.DNSNameMangler;
import org.alfresco.wcm.preview.PreviewURIServiceRegistry;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.alfresco.wcm.sandbox.SandboxFactory;
import org.alfresco.wcm.sandbox.SandboxInfo;
import org.alfresco.wcm.util.WCMUtil;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.alfresco.wcm.webproject.WebProjectInfoImpl;
import org.alfresco.wcm.webproject.WebProjectService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

public class WebProjectServiceImpl
extends WCMUtil
implements WebProjectService {
    private static Log logger = LogFactory.getLog(WebProjectServiceImpl.class);
    public static final StoreRef WEBPROJECT_STORE = new StoreRef("workspace://SpacesStore");
    private NodeRef webProjectsRootNodeRef;
    private boolean isSetWebProjectsRootNodeRef;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private AVMService avmService;
    private AuthorityService authorityService;
    private PermissionService permissionService;
    private PersonService personService;
    private SandboxFactory sandboxFactory;
    private VirtServerRegistry virtServerRegistry;
    private PreviewURIServiceRegistry previewURIProviderRegistry;
    private TransactionService transactionService;
    private AVMLockingService avmLockingService;
    private static final String SPACES_COMPANY_HOME_CHILDNAME = "app:company_home";
    private static final String SPACES_WCM_CHILDNAME = "app:wcm";

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setSandboxFactory(SandboxFactory sandboxFactory) {
        this.sandboxFactory = sandboxFactory;
    }

    public void setVirtServerRegistry(VirtServerRegistry virtServerRegistry) {
        this.virtServerRegistry = virtServerRegistry;
    }

    public void setPreviewURIServiceRegistry(PreviewURIServiceRegistry previewURIProviderRegistry) {
        this.previewURIProviderRegistry = previewURIProviderRegistry;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAvmLockingService(AVMLockingService avmLockingService) {
        this.avmLockingService = avmLockingService;
    }

    @Override
    public WebProjectInfo createWebProject(String dnsName, String name, String title, String description) {
        return this.createWebProject(dnsName, name, title, description, null, false, null);
    }

    @Override
    public WebProjectInfo createWebProject(String dnsName, String name, String title, String description, NodeRef sourceNodeRef) {
        return this.createWebProject(dnsName, name, title, description, null, false, sourceNodeRef);
    }

    @Override
    public WebProjectInfo createWebProject(String dnsName, String name, String title, String description, String defaultWebApp, boolean useAsTemplate, NodeRef sourceNodeRef) {
        return this.createWebProject(new WebProjectInfoImpl(dnsName, name, title, description, defaultWebApp, useAsTemplate, sourceNodeRef, null));
    }

    @Override
    public WebProjectInfo createWebProject(WebProjectInfo wpInfo) {
        long start = System.currentTimeMillis();
        String wpStoreId = wpInfo.getStoreId();
        String name = wpInfo.getName();
        String title = wpInfo.getTitle();
        String description = wpInfo.getDescription();
        boolean useAsTemplate = wpInfo.isTemplate();
        NodeRef sourceNodeRef = wpInfo.getNodeRef();
        String defaultWebApp = wpInfo.getDefaultWebApp();
        String previewProviderName = wpInfo.getPreviewProviderName();
        ParameterCheck.mandatoryString((String)"wpStoreId", (String)wpStoreId);
        ParameterCheck.mandatoryString((String)"name", (String)name);
        wpStoreId = DNSNameMangler.MakeDNSName((String[])new String[]{wpStoreId});
        if (wpStoreId.indexOf("--") != -1) {
            throw new IllegalArgumentException("Unexpected store id '" + wpStoreId + "' - should not contain '" + "--" + "'");
        }
        if (wpStoreId.indexOf(58) != -1) {
            throw new IllegalArgumentException("Unexpected store id '" + wpStoreId + "' - should not contain '" + ':' + "'");
        }
        if (previewProviderName == null) {
            previewProviderName = this.previewURIProviderRegistry.getDefaultProviderName();
        } else if (!this.previewURIProviderRegistry.getPreviewURIServiceProviders().keySet().contains(previewProviderName)) {
            throw new AlfrescoRuntimeException("Cannot update web project '" + wpInfo.getStoreId() + "' - unknown preview URI service provider (" + previewProviderName + ")");
        }
        defaultWebApp = defaultWebApp != null && defaultWebApp.length() != 0 ? defaultWebApp : "ROOT";
        HashMap<QName, Object> props = new HashMap<QName, Object>(1);
        props.put(ContentModel.PROP_NAME, name);
        props.put(WCMAppModel.PROP_ISSOURCE, useAsTemplate);
        props.put(WCMAppModel.PROP_DEFAULTWEBAPP, defaultWebApp);
        props.put(WCMAppModel.PROP_AVMSTORE, wpStoreId);
        props.put(WCMAppModel.PROP_PREVIEW_PROVIDER, previewProviderName);
        NodeRef webProjectsRoot = this.getWebProjectsRoot();
        if (!this.nodeService.hasAspect(webProjectsRoot, RuleModel.ASPECT_IGNORE_INHERITED_RULES)) {
            this.nodeService.addAspect(webProjectsRoot, RuleModel.ASPECT_IGNORE_INHERITED_RULES, null);
        }
        ChildAssociationRef childAssocRef = this.nodeService.createNode(webProjectsRoot, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)name)), WCMAppModel.TYPE_AVMWEBFOLDER, props);
        NodeRef wpNodeRef = childAssocRef.getChildRef();
        HashMap<QName, String> uiFacetsProps = new HashMap<QName, String>(4);
        uiFacetsProps.put(ApplicationModel.PROP_ICON, "space-icon-website");
        uiFacetsProps.put(ContentModel.PROP_TITLE, title);
        uiFacetsProps.put(ContentModel.PROP_DESCRIPTION, description);
        this.nodeService.addAspect(wpNodeRef, ApplicationModel.ASPECT_UIFACETS, uiFacetsProps);
        String branchStoreId = null;
        if (sourceNodeRef != null) {
            branchStoreId = (String)((Object)this.nodeService.getProperty(sourceNodeRef, WCMAppModel.PROP_AVMSTORE));
        }
        this.sandboxFactory.createStagingSandbox(wpStoreId, wpNodeRef, branchStoreId);
        String stagingStore = WCMUtil.buildStagingStoreName(wpStoreId);
        if (branchStoreId == null) {
            String stagingStoreRoot = WCMUtil.buildSandboxRootPath(stagingStore);
            this.avmService.createDirectory(stagingStoreRoot, defaultWebApp);
            this.avmService.addAspect(AVMNodeConverter.ExtendAVMPath(stagingStoreRoot, defaultWebApp), WCMAppModel.ASPECT_WEBAPP);
        }
        this.sandboxFactory.setStagingPermissionMasks(wpStoreId);
        this.avmService.setStoreProperty(stagingStore, SandboxConstants.PROP_WEB_PROJECT_PREVIEW_PROVIDER, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)previewProviderName)));
        this.avmService.createSnapshot(wpStoreId, null, null);
        this.permissionService.setInheritParentPermissions(wpNodeRef, false);
        this.inviteWebUser(wpNodeRef, AuthenticationUtil.getFullyAuthenticatedUser(), "ContentManager", true);
        CreateWebAppTransactionListener tl = new CreateWebAppTransactionListener(wpStoreId, "ROOT");
        AlfrescoTransactionSupport.bindListener(tl);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created web project: " + wpNodeRef + " in " + (System.currentTimeMillis() - start) + " ms (store id: " + wpStoreId + ")"));
        }
        return new WebProjectInfoImpl(wpStoreId, name, title, description, defaultWebApp, useAsTemplate, wpNodeRef, previewProviderName);
    }

    @Override
    public void createWebApp(String wpStoreId, String webAppName, String webAppDescription) {
        this.createWebApp(this.getWebProjectNodeFromStore(wpStoreId), webAppName, webAppDescription);
    }

    @Override
    public void createWebApp(NodeRef wpNodeRef, final String webAppName, final String webAppDescription) {
        long start = System.currentTimeMillis();
        WebProjectInfo wpInfo = this.getWebProject(wpNodeRef);
        if (this.isContentManager(wpNodeRef)) {
            final String stagingStoreId = wpInfo.getStagingStoreName();
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    String parent = WCMUtil.buildSandboxRootPath(stagingStoreId);
                    WebProjectServiceImpl.this.avmService.createDirectory(parent, webAppName);
                    String path = AVMNodeConverter.ExtendAVMPath(parent, webAppName);
                    WebProjectServiceImpl.this.avmService.addAspect(path, ApplicationModel.ASPECT_UIFACETS);
                    WebProjectServiceImpl.this.avmService.addAspect(path, WCMAppModel.ASPECT_WEBAPP);
                    if (webAppDescription != null && webAppDescription.length() != 0) {
                        WebProjectServiceImpl.this.avmService.setNodeProperty(path, ContentModel.PROP_DESCRIPTION, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)webAppDescription)));
                    }
                    WebProjectServiceImpl.this.avmService.createSnapshot(stagingStoreId, null, null);
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            CreateWebAppTransactionListener tl = new CreateWebAppTransactionListener(wpInfo.getStoreId(), webAppName);
            AlfrescoTransactionSupport.bindListener(tl);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created web app: " + webAppName + " in " + (System.currentTimeMillis() - start) + " ms (store id: " + wpInfo.getStoreId() + ")"));
            }
        } else {
            throw new AccessDeniedException("Only content managers may create new webapp '" + webAppName + "' (store id: " + wpInfo.getStoreId() + ")");
        }
    }

    @Override
    public List<String> listWebApps(String wpStoreId) {
        return this.listWebApps(this.getWebProjectNodeFromStore(wpStoreId));
    }

    @Override
    public List<String> listWebApps(NodeRef wpNodeRef) {
        WebProjectInfo wpInfo = this.getWebProject(wpNodeRef);
        String path = WCMUtil.buildSandboxRootPath(wpInfo.getStagingStoreName());
        SortedMap<String, AVMNodeDescriptor> folders = this.avmService.getDirectoryListing(-1, path);
        ArrayList<String> webAppNames = new ArrayList<String>(folders.size());
        webAppNames.addAll(folders.keySet());
        return webAppNames;
    }

    @Override
    public void deleteWebApp(String wpStoreId, String webAppName) {
        this.deleteWebApp(this.getWebProjectNodeFromStore(wpStoreId), webAppName);
    }

    @Override
    public void deleteWebApp(NodeRef wpNodeRef, final String webAppName) {
        long start = System.currentTimeMillis();
        ParameterCheck.mandatoryString((String)"webAppName", (String)webAppName);
        WebProjectInfo wpInfo = this.getWebProject(wpNodeRef);
        if (webAppName.equals(wpInfo.getDefaultWebApp())) {
            throw new AlfrescoRuntimeException("Cannot delete default webapp '" + webAppName + "' (store id: " + wpInfo.getStoreId() + ")");
        }
        if (this.isContentManager(wpInfo.getNodeRef())) {
            final String wpStoreId = wpInfo.getStoreId();
            WCMUtil.removeVServerWebapp(this.virtServerRegistry, WCMUtil.buildStoreWebappPath(wpStoreId, webAppName), true);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    String parent = WCMUtil.buildSandboxRootPath(wpStoreId);
                    WebProjectServiceImpl.this.avmService.removeNode(parent, webAppName);
                    WebProjectServiceImpl.this.avmService.createSnapshot(wpStoreId, null, null);
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleted web app: " + webAppName + " in " + (System.currentTimeMillis() - start) + " ms (store id: " + wpStoreId + ")"));
            }
        } else {
            throw new AccessDeniedException("Only content managers may delete webapp '" + webAppName + "' (web project: " + wpNodeRef + ")");
        }
    }

    @Override
    public boolean hasWebProjectsRoot() {
        return this.getWebProjectsRootOrNull() != null;
    }

    private NodeRef getWebProjectsRootOrNull() {
        if (!this.isSetWebProjectsRootNodeRef) {
            List results = this.searchService.selectNodes(this.nodeService.getRootNode(WEBPROJECT_STORE), this.getWebProjectsPath(), null, (NamespacePrefixResolver)this.namespaceService, false);
            int size = results.size();
            if (size > 1) {
                throw new AlfrescoRuntimeException("More than one root 'Web Projects' folder exists");
            }
            if (size > 0) {
                this.webProjectsRootNodeRef = (NodeRef)results.get(0);
            }
            this.isSetWebProjectsRootNodeRef = true;
        }
        return this.webProjectsRootNodeRef;
    }

    @Override
    public NodeRef getWebProjectsRoot() {
        NodeRef result = this.getWebProjectsRootOrNull();
        if (result == null) {
            throw new AlfrescoRuntimeException("No root 'Web Projects' folder exists (is WCM enabled ?)");
        }
        return result;
    }

    @Override
    public List<WebProjectInfo> listWebProjects() {
        NodeRef wpRoot = this.getWebProjectsRoot();
        HashSet<QName> nodeTypeQNames = new HashSet<QName>(1);
        nodeTypeQNames.add(WCMAppModel.TYPE_AVMWEBFOLDER);
        List webProjects = this.nodeService.getChildAssocs(wpRoot, nodeTypeQNames);
        ArrayList<WebProjectInfo> result = new ArrayList<WebProjectInfo>(webProjects.size());
        for (ChildAssociationRef childAssocRefs : webProjects) {
            result.add(this.getWebProject(childAssocRefs.getChildRef()));
        }
        return result;
    }

    @Override
    public List<WebProjectInfo> listWebProjects(String userName) {
        List<WebProjectInfo> webProjects = this.listWebProjects();
        ArrayList<WebProjectInfo> result = new ArrayList<WebProjectInfo>(webProjects.size());
        for (WebProjectInfo webProject : webProjects) {
            if (!this.isWebUser(webProject.getNodeRef(), userName)) continue;
            result.add(webProject);
        }
        return result;
    }

    @Override
    public boolean isWebProject(String wpStoreId) {
        NodeRef wpNodeRef = this.getWebProjectNodeFromStore(wpStoreId);
        if (wpNodeRef == null) {
            return false;
        }
        return this.isWebProject(wpNodeRef);
    }

    @Override
    public boolean isWebProject(NodeRef wpNodeRef) {
        if (wpNodeRef == null) {
            return false;
        }
        try {
            return WCMAppModel.TYPE_AVMWEBFOLDER.equals((Object)this.nodeService.getType(wpNodeRef));
        }
        catch (InvalidNodeRefException e) {
            return false;
        }
    }

    @Override
    public WebProjectInfo getWebProject(String wpStoreId) {
        WebProjectInfo result = null;
        NodeRef wpNodeRef = this.getWebProjectNodeFromStore(wpStoreId);
        if (wpNodeRef != null) {
            result = this.getWebProject(wpNodeRef);
        }
        return result;
    }

    @Override
    public String getPreviewProvider(String wpStoreId) {
        ParameterCheck.mandatoryString((String)"wpStoreId", (String)wpStoreId);
        String previewProviderName = null;
        try {
            String stagingStoreId = WCMUtil.buildStagingStoreName(wpStoreId);
            PropertyValue pValue = this.avmService.getStoreProperty(stagingStoreId, SandboxConstants.PROP_WEB_PROJECT_PREVIEW_PROVIDER);
            if (pValue != null) {
                previewProviderName = (String)((Object)pValue.getValue(DataTypeDefinition.TEXT));
            }
        }
        catch (AVMNotFoundException nfe) {
            logger.warn((Object)(wpStoreId + " is not a web project: " + (Object)((Object)nfe)));
        }
        if (previewProviderName == null) {
            previewProviderName = this.previewURIProviderRegistry.getDefaultProviderName();
        }
        return previewProviderName;
    }

    @Override
    public WebProjectInfo getWebProject(NodeRef wpNodeRef) {
        if (!this.isWebProject(wpNodeRef)) {
            throw new IllegalArgumentException(wpNodeRef + " is not a web project");
        }
        Map properties = this.nodeService.getProperties(wpNodeRef);
        String name = (String)properties.get(ContentModel.PROP_NAME);
        String title = (String)properties.get(ContentModel.PROP_TITLE);
        String description = (String)properties.get(ContentModel.PROP_DESCRIPTION);
        String wpStoreId = (String)properties.get(WCMAppModel.PROP_AVMSTORE);
        String defaultWebApp = (String)properties.get(WCMAppModel.PROP_DEFAULTWEBAPP);
        Boolean useAsTemplate = (Boolean)properties.get(WCMAppModel.PROP_ISSOURCE);
        String previewProvider = (String)properties.get(WCMAppModel.PROP_PREVIEW_PROVIDER);
        WebProjectInfoImpl wpInfo = new WebProjectInfoImpl(wpStoreId, name, title, description, defaultWebApp, useAsTemplate, wpNodeRef, previewProvider);
        return wpInfo;
    }

    @Override
    public void updateWebProject(WebProjectInfo wpInfo) {
        long start = System.currentTimeMillis();
        NodeRef wpNodeRef = this.getWebProjectNodeFromStore(wpInfo.getStoreId());
        if (wpNodeRef == null) {
            throw new AlfrescoRuntimeException("Cannot update web project '" + wpInfo.getStoreId() + "' - it does not exist.");
        }
        if (!this.listWebApps(wpNodeRef).contains(wpInfo.getDefaultWebApp())) {
            throw new AlfrescoRuntimeException("Cannot update web project '" + wpInfo.getStoreId() + "' - unknown default web app  (" + wpInfo.getDefaultWebApp() + ")");
        }
        if (wpInfo.getPreviewProviderName() == null) {
            wpInfo.setPreviewProviderName(this.previewURIProviderRegistry.getDefaultProviderName());
        } else if (!this.previewURIProviderRegistry.getPreviewURIServiceProviders().keySet().contains(wpInfo.getPreviewProviderName())) {
            throw new AlfrescoRuntimeException("Cannot update web project '" + wpInfo.getStoreId() + "' - unknown preview URI service provider (" + wpInfo.getPreviewProviderName() + ")");
        }
        Map properties = this.nodeService.getProperties(wpNodeRef);
        properties.put(ContentModel.PROP_NAME, wpInfo.getName());
        properties.put(ContentModel.PROP_TITLE, wpInfo.getTitle());
        properties.put(ContentModel.PROP_DESCRIPTION, wpInfo.getDescription());
        properties.put(WCMAppModel.PROP_DEFAULTWEBAPP, wpInfo.getDefaultWebApp());
        properties.put(WCMAppModel.PROP_ISSOURCE, wpInfo.isTemplate());
        properties.put(WCMAppModel.PROP_PREVIEW_PROVIDER, wpInfo.getPreviewProviderName());
        this.nodeService.setProperties(wpNodeRef, properties);
        String stagingStore = WCMUtil.buildStagingStoreName(wpInfo.getStoreId());
        this.avmService.deleteStoreProperty(stagingStore, SandboxConstants.PROP_WEB_PROJECT_PREVIEW_PROVIDER);
        this.avmService.setStoreProperty(stagingStore, SandboxConstants.PROP_WEB_PROJECT_PREVIEW_PROVIDER, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)wpInfo.getPreviewProviderName())));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updated web project: " + wpNodeRef + " in " + (System.currentTimeMillis() - start) + " ms (store id: " + wpInfo.getStoreId() + ")"));
        }
    }

    @Override
    public void deleteWebProject(String wpStoreId) {
        NodeRef wpNodeRef = this.getWebProjectNodeFromStore(wpStoreId);
        if (wpNodeRef == null) {
            throw new AccessDeniedException("Only content managers may delete a web project");
        }
        this.deleteWebProject(wpNodeRef);
    }

    @Override
    public void deleteWebProject(final NodeRef wpNodeRef) {
        long start = System.currentTimeMillis();
        if (!this.isContentManager(wpNodeRef)) {
            throw new AccessDeniedException("Only content managers may delete web project");
        }
        final String wpStoreId = (String)((Object)this.nodeService.getProperty(wpNodeRef, WCMAppModel.PROP_AVMSTORE));
        if (wpStoreId != null) {
            final String sandbox = WCMUtil.buildStagingStoreName(wpStoreId);
            String path = WCMUtil.buildStoreWebappPath(sandbox, "/ROOT");
            WCMUtil.removeAllVServerWebapps(this.virtServerRegistry, path, true);
            try {
                RetryingTransactionHelper.RetryingTransactionCallback<Object> deleteWebProjectWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    @Override
                    public Object execute() throws Throwable {
                        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                            public Object doWork() throws Exception {
                                List<SandboxInfo> sbInfos = WebProjectServiceImpl.this.sandboxFactory.listAllSandboxes(wpStoreId, true, true);
                                for (SandboxInfo sbInfo : sbInfos) {
                                    String sbStoreId = sbInfo.getSandboxId();
                                    if (WebProjectServiceImpl.isLocalhostDeployedStore(wpStoreId, sbStoreId) && WebProjectServiceImpl.this.getWebProject(WCMUtil.getWebProjectStoreId(sbStoreId)) != null) continue;
                                    WebProjectServiceImpl.this.sandboxFactory.deleteSandbox(sbInfo, false, false);
                                }
                                WebProjectServiceImpl.this.avmLockingService.removeLocks(wpStoreId);
                                StoreRef archiveStoreRef = WebProjectServiceImpl.this.nodeService.getStoreArchiveNode(wpNodeRef.getStoreRef()).getStoreRef();
                                WebProjectServiceImpl.this.nodeService.deleteNode(wpNodeRef);
                                WebProjectServiceImpl.this.nodeService.deleteNode(new NodeRef(archiveStoreRef, wpNodeRef.getId()));
                                WebProjectServiceImpl.this.sandboxFactory.removeGroupsForStore(sandbox);
                                return null;
                            }
                        }, (String)AuthenticationUtil.getSystemUserName());
                        return null;
                    }
                };
                this.transactionService.getRetryingTransactionHelper().doInTransaction(deleteWebProjectWork);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deleted web project: " + wpNodeRef + " in " + (System.currentTimeMillis() - start) + " ms (store id: " + wpStoreId + ")"));
                }
            }
            catch (Throwable err) {
                throw new AlfrescoRuntimeException("Failed to delete web project: ", err);
            }
        }
    }

    @Override
    public boolean isContentManager(String storeName) {
        return this.isContentManager(storeName, AuthenticationUtil.getFullyAuthenticatedUser());
    }

    @Override
    public boolean isContentManager(String wpStoreId, String userName) {
        return this.isContentManager(this.getWebProjectNodeFromStore(wpStoreId), userName);
    }

    @Override
    public boolean isContentManager(NodeRef wpNodeRef) {
        return this.isContentManager(wpNodeRef, AuthenticationUtil.getFullyAuthenticatedUser());
    }

    @Override
    public boolean isContentManager(NodeRef wpNodeRef, String userName) {
        String userRole = this.getWebUserRole(wpNodeRef, userName);
        return "ContentManager".equals(userRole);
    }

    @Override
    public boolean isWebUser(String wpStoreId) {
        return this.isWebUser(this.getWebProjectNodeFromStore(wpStoreId));
    }

    @Override
    public boolean isWebUser(NodeRef wpNodeRef) {
        return this.permissionService.hasPermission(wpNodeRef, "Read") == AccessStatus.ALLOWED;
    }

    @Override
    public boolean isWebUser(String wpStoreId, String username) {
        return this.isWebUser(this.getWebProjectNodeFromStore(wpStoreId), username);
    }

    @Override
    public boolean isWebUser(final NodeRef wpNodeRef, String userName) {
        return (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                return WebProjectServiceImpl.this.isWebUser(wpNodeRef);
            }
        }, (String)userName);
    }

    @Override
    public int getWebUserCount(NodeRef wpNodeRef) {
        long start = System.currentTimeMillis();
        int cnt = WCMUtil.listWebUserRefs(this.nodeService, wpNodeRef, false).size();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Get web user cnt: " + wpNodeRef + "(" + cnt + ") in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return cnt;
    }

    @Override
    public Map<String, String> listWebUsers(String wpStoreId) {
        return this.listWebUsers(this.getWebProjectNodeFromStore(wpStoreId));
    }

    @Override
    public Map<String, String> listWebUsers(NodeRef wpNodeRef) {
        long start = System.currentTimeMillis();
        if (this.isContentManager(wpNodeRef) || AuthenticationUtil.getRunAsUser().equals(AuthenticationUtil.getSystemUserName()) || this.permissionService.hasPermission(wpNodeRef, "AddChildren") == AccessStatus.ALLOWED) {
            Map<String, String> users = WCMUtil.listWebUsers(this.nodeService, wpNodeRef);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("List web users: " + wpNodeRef + "(" + users.size() + ") in " + (System.currentTimeMillis() - start) + " ms"));
            }
            return users;
        }
        throw new AccessDeniedException("Only content managers may list users in a web project");
    }

    @Override
    public String getWebUserRole(String wpStoreId, String userName) {
        return this.getWebUserRole(this.getWebProjectNodeFromStore(wpStoreId), userName);
    }

    @Override
    public String getWebUserRole(NodeRef wpNodeRef, String userName) {
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        String userRole = null;
        if (!this.isWebProject(wpNodeRef)) {
            logger.warn((Object)(wpNodeRef + " is not a web project"));
            return null;
        }
        userRole = this.authorityService.isAdminAuthority(userName) ? "ContentManager" : this.getWebUserRoleImpl(wpNodeRef, userName);
        return userRole;
    }

    private String getWebUserRoleImpl(NodeRef wpNodeRef, String userName) {
        NodeRef userRef = this.getWebUserRef(wpNodeRef, userName);
        String userRole = null;
        if (userRef != null) {
            userRole = (String)((Object)this.nodeService.getProperty(userRef, WCMAppModel.PROP_WEBUSERROLE));
        }
        return userRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeRef getWebUserRef(NodeRef wpNodeRef, String userName) {
        StringBuilder query = new StringBuilder(128);
        query.append("+PARENT:\"").append(wpNodeRef).append("\" ");
        query.append("+TYPE:\"").append(WCMAppModel.TYPE_WEBUSER).append("\" ");
        query.append("+@").append("wca").append("\\:username:\"");
        query.append(userName);
        query.append("\"");
        List nodes = null;
        try (ResultSet resultSet = null;){
            resultSet = this.searchService.query(WEBPROJECT_STORE, "lucene", query.toString());
            nodes = resultSet.getNodeRefs();
        }
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            if (this.nodeService.getProperty((NodeRef)i.next(), WCMAppModel.PROP_WEBUSERNAME).equals(userName)) continue;
            i.remove();
        }
        if (nodes.size() == 1) {
            return (NodeRef)nodes.get(0);
        }
        if (nodes.size() == 0) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("getWebUserRef: web user (" + userName + ") not found in web project: " + wpNodeRef));
            }
        } else {
            logger.error((Object)("getWebUserRef: more than one web user (" + userName + ") found in web project: " + wpNodeRef));
        }
        return null;
    }

    @Override
    public NodeRef getWebProjectNodeFromPath(String absoluteAVMPath) {
        return this.getWebProjectNodeFromStore(WCMUtil.getWebProjectStoreIdFromPath(absoluteAVMPath));
    }

    @Override
    public NodeRef getWebProjectNodeFromStore(String wpStoreId) {
        ParameterCheck.mandatoryString((String)"wpStoreId", (String)wpStoreId);
        return WCMUtil.getWebProjectNodeFromWebProjectStore(this.avmService, wpStoreId);
    }

    @Override
    public void inviteWebUsersGroups(String wpStoreId, Map<String, String> userGroupRoles) {
        this.inviteWebUsersGroups(this.getWebProjectNodeFromStore(wpStoreId), userGroupRoles, false);
    }

    @Override
    public void inviteWebUsersGroups(String wpStoreId, Map<String, String> userGroupRoles, boolean autoCreateAuthorSandbox) {
        this.inviteWebUsersGroups(this.getWebProjectNodeFromStore(wpStoreId), userGroupRoles, autoCreateAuthorSandbox);
    }

    @Override
    public void inviteWebUsersGroups(NodeRef wpNodeRef, Map<String, String> userGroupRoles, boolean autoCreateAuthorSandbox) {
        long start = System.currentTimeMillis();
        if (!this.isContentManager(wpNodeRef) && this.permissionService.hasPermission(wpNodeRef, "AddChildren") != AccessStatus.ALLOWED) {
            throw new AccessDeniedException("Only content managers may invite web users");
        }
        WebProjectInfo wpInfo = this.getWebProject(wpNodeRef);
        String wpStoreId = wpInfo.getStoreId();
        ArrayList<String> managers = new ArrayList<String>(4);
        HashMap<String, NodeRef> webSiteUsers = new HashMap<String, NodeRef>(8);
        LinkedList<String> managersToRemove = new LinkedList<String>();
        LinkedList<SandboxFactory.UserRoleWrapper> usersToUpdate = new LinkedList<SandboxFactory.UserRoleWrapper>();
        for (Map.Entry<String, String> userRole : userGroupRoles.entrySet()) {
            String authority = userRole.getKey();
            String role = userRole.getValue();
            for (String string : this.findNestedUserAuthorities(authority)) {
                if (!"ContentManager".equals(role)) continue;
                managers.add(string);
            }
        }
        List userInfoRefs = this.nodeService.getChildAssocs(wpNodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBUSER, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef ref : userInfoRefs) {
            NodeRef userInfoRef = ref.getChildRef();
            String username = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERNAME));
            String string = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERROLE));
            if ("ContentManager".equals(string) && !managers.contains(username)) {
                managers.add(username);
            }
            webSiteUsers.put(username, userInfoRef);
        }
        LinkedList<SandboxInfo> sandboxInfoList = new LinkedList<SandboxInfo>();
        int invitedCount = 0;
        boolean managersUpdateRequired = false;
        for (Map.Entry entry : userGroupRoles.entrySet()) {
            String authority = (String)entry.getKey();
            String role = (String)entry.getValue();
            for (String userAuth : this.findNestedUserAuthorities(authority)) {
                if (!webSiteUsers.keySet().contains(userAuth)) {
                    if (autoCreateAuthorSandbox) {
                        SandboxInfo sbInfo = this.sandboxFactory.createUserSandbox(wpStoreId, userAuth, role);
                        sandboxInfoList.add(sbInfo);
                    }
                    this.sandboxFactory.addStagingAreaUser(wpStoreId, userAuth, role);
                    this.createWebUser(wpNodeRef, userAuth, role);
                    managersUpdateRequired |= "ContentManager".equals(role);
                    ++invitedCount;
                    continue;
                }
                NodeRef userRef = (NodeRef)webSiteUsers.get(userAuth);
                String oldUserRole = (String)((Object)this.nodeService.getProperty(userRef, WCMAppModel.PROP_WEBUSERROLE));
                if (role.equals(oldUserRole)) continue;
                Map props = this.nodeService.getProperties(userRef);
                props.put(WCMAppModel.PROP_WEBUSERNAME, userAuth);
                props.put(WCMAppModel.PROP_WEBUSERROLE, role);
                this.nodeService.setProperties(userRef, props);
                if ("ContentManager".equals(role)) {
                    managersUpdateRequired = true;
                } else if ("ContentManager".equals(oldUserRole)) {
                    managersToRemove.add(userAuth);
                }
                SandboxFactory sandboxFactory = this.sandboxFactory;
                sandboxFactory.getClass();
                usersToUpdate.add(sandboxFactory.new SandboxFactory.UserRoleWrapper(userAuth, oldUserRole, role));
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(userAuth + "'s role has been changed from '" + oldUserRole + "' to '" + role + "'"));
            }
        }
        CreateSandboxTransactionListener tl = new CreateSandboxTransactionListener(sandboxInfoList, this.listWebApps(wpNodeRef));
        AlfrescoTransactionSupport.bindListener(tl);
        if (managersUpdateRequired) {
            this.sandboxFactory.updateSandboxManagers(wpStoreId, managers);
        }
        if (managersToRemove.size() != 0) {
            this.sandboxFactory.removeSandboxManagers(wpStoreId, managersToRemove);
        }
        Set set = this.permissionService.getSettablePermissions(WCMAppModel.TYPE_AVMWEBFOLDER);
        block5: for (Map.Entry<String, String> userRole : userGroupRoles.entrySet()) {
            String authority = userRole.getKey();
            String role = userRole.getValue();
            for (String permission : set) {
                if (!role.equals(permission)) continue;
                this.permissionService.setPermission(wpNodeRef, authority, permission, true);
                continue block5;
            }
        }
        if (usersToUpdate.size() != 0) {
            this.sandboxFactory.updateSandboxRoles(wpStoreId, usersToUpdate, set);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Invited " + invitedCount + " web users in " + (System.currentTimeMillis() - start) + " ms (store id: " + wpStoreId + ")"));
        }
    }

    @Override
    public void inviteWebUser(String wpStoreId, String userAuth, String role) {
        this.inviteWebUser(this.getWebProjectNodeFromStore(wpStoreId), userAuth, role, false);
    }

    @Override
    public void inviteWebUser(String wpStoreId, String userAuth, String role, boolean autoCreateAuthorSandbox) {
        this.inviteWebUser(this.getWebProjectNodeFromStore(wpStoreId), userAuth, role, autoCreateAuthorSandbox);
    }

    @Override
    public void inviteWebUser(NodeRef wpNodeRef, String userAuth, String role, boolean autoCreateAuthorSandbox) {
        long start = System.currentTimeMillis();
        if (!this.isContentManager(wpNodeRef) && this.permissionService.hasPermission(wpNodeRef, "AddChildren") != AccessStatus.ALLOWED) {
            throw new AccessDeniedException("Only content managers may invite web user");
        }
        WebProjectInfo wpInfo = this.getWebProject(wpNodeRef);
        String wpStoreId = wpInfo.getStoreId();
        ArrayList<String> managers = new ArrayList<String>(4);
        Map<String, String> existingUserRoles = this.listWebUsers(wpNodeRef);
        for (Map.Entry<String, String> userRole : existingUserRoles.entrySet()) {
            String username = userRole.getKey();
            String userrole = userRole.getValue();
            if (!"ContentManager".equals(userrole) || managers.contains(username)) continue;
            managers.add(username);
        }
        Set perms = this.permissionService.getSettablePermissions(WCMAppModel.TYPE_AVMWEBFOLDER);
        NodeRef userRef = this.getWebUserRef(wpNodeRef, userAuth);
        if (userRef != null) {
            String oldUserRole = (String)((Object)this.nodeService.getProperty(userRef, WCMAppModel.PROP_WEBUSERROLE));
            if (!role.equals(oldUserRole)) {
                Map props = this.nodeService.getProperties(userRef);
                props.put(WCMAppModel.PROP_WEBUSERNAME, userAuth);
                props.put(WCMAppModel.PROP_WEBUSERROLE, role);
                this.nodeService.setProperties(userRef, props);
                if ("ContentManager".equals(role)) {
                    managers.add(userAuth);
                    this.sandboxFactory.updateSandboxManagers(wpStoreId, managers);
                } else if ("ContentManager".equals(oldUserRole)) {
                    LinkedList<String> managersToRemove = new LinkedList<String>();
                    managersToRemove.add(userAuth);
                    this.sandboxFactory.removeSandboxManagers(wpStoreId, managersToRemove);
                }
                LinkedList<SandboxFactory.UserRoleWrapper> usersToUpdate = new LinkedList<SandboxFactory.UserRoleWrapper>();
                SandboxFactory sandboxFactory = this.sandboxFactory;
                sandboxFactory.getClass();
                usersToUpdate.add(sandboxFactory.new SandboxFactory.UserRoleWrapper(userAuth, oldUserRole, role));
                this.sandboxFactory.updateSandboxRoles(wpStoreId, usersToUpdate, perms);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Web user " + userAuth + "'s role has been changed from '" + oldUserRole + "' to '" + role + "' in " + (System.currentTimeMillis() - start) + " ms (store id: " + wpStoreId + ")"));
                }
            }
        } else {
            if (autoCreateAuthorSandbox) {
                SandboxInfo sbInfo = this.sandboxFactory.createUserSandbox(wpStoreId, userAuth, role);
                LinkedList<SandboxInfo> sandboxInfoList = new LinkedList<SandboxInfo>();
                sandboxInfoList.add(sbInfo);
                CreateSandboxTransactionListener tl = new CreateSandboxTransactionListener(sandboxInfoList, this.listWebApps(wpNodeRef));
                AlfrescoTransactionSupport.bindListener(tl);
            }
            if ("ContentManager".equals(role)) {
                managers.add(userAuth);
                this.sandboxFactory.updateSandboxManagers(wpStoreId, managers);
            }
            this.sandboxFactory.addStagingAreaUser(wpStoreId, userAuth, role);
            this.createWebUser(wpNodeRef, userAuth, role);
            for (String permission : perms) {
                if (!role.equals(permission)) continue;
                this.permissionService.setPermission(wpNodeRef, userAuth, permission, true);
                break;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invited web user: " + userAuth + " in " + (System.currentTimeMillis() - start) + " ms (store id: " + wpStoreId + ")"));
            }
        }
    }

    private void createWebUser(NodeRef wpNodeRef, String userName, String userRole) {
        HashMap<QName, String> props = new HashMap<QName, String>(2, 1.0f);
        props.put(WCMAppModel.PROP_WEBUSERNAME, userName);
        props.put(WCMAppModel.PROP_WEBUSERROLE, userRole);
        this.nodeService.createNode(wpNodeRef, WCMAppModel.ASSOC_WEBUSER, WCMAppModel.ASSOC_WEBUSER, WCMAppModel.TYPE_WEBUSER, props);
    }

    @Override
    public void uninviteWebUser(String wpStoreId, String userAuth) {
        this.uninviteWebUser(this.getWebProjectNodeFromStore(wpStoreId), userAuth, false);
    }

    @Override
    public void uninviteWebUser(String wpStoreId, String userAuth, boolean autoDeleteAuthorSandbox) {
        this.uninviteWebUser(this.getWebProjectNodeFromStore(wpStoreId), userAuth, autoDeleteAuthorSandbox);
    }

    @Override
    public void uninviteWebUser(NodeRef wpNodeRef, String userAuth, boolean autoDeleteAuthorSandbox) {
        NodeRef userInfoRef;
        long start = System.currentTimeMillis();
        if (!this.isContentManager(wpNodeRef)) {
            throw new AccessDeniedException("Only content managers may uninvite web user '" + userAuth + "' from web project: " + wpNodeRef);
        }
        ParameterCheck.mandatory((String)"wpNodeRef", (Object)wpNodeRef);
        ParameterCheck.mandatoryString((String)"userAuth", (String)userAuth);
        WebProjectInfo wpInfo = this.getWebProject(wpNodeRef);
        String wpStoreId = wpInfo.getStoreId();
        String userMainStore = WCMUtil.buildUserMainStoreName(wpStoreId, userAuth);
        if (autoDeleteAuthorSandbox) {
            this.sandboxFactory.deleteSandbox(userMainStore);
        }
        List userInfoRefs = this.nodeService.getChildAssocs(wpNodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBUSER, RegexQNamePattern.MATCH_ALL);
        ArrayList<String> managers = new ArrayList<String>(4);
        for (ChildAssociationRef ref : userInfoRefs) {
            userInfoRef = ref.getChildRef();
            String username = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERNAME));
            String userrole = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERROLE));
            if (!"ContentManager".equals(userrole) || managers.contains(username)) continue;
            managers.add(username);
        }
        for (ChildAssociationRef ref : userInfoRefs) {
            userInfoRef = ref.getChildRef();
            String user = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERNAME));
            if (!userAuth.equals(user)) continue;
            this.nodeService.removeChild(wpNodeRef, ref.getChildRef());
            this.permissionService.clearPermission(wpNodeRef, userAuth);
            if (!logger.isDebugEnabled()) break;
            logger.debug((Object)("Uninvited web user: " + userAuth + " in " + (System.currentTimeMillis() - start) + " ms (store id: " + wpStoreId + ")"));
            break;
        }
    }

    private Set<String> findNestedUserAuthorities(String authority) {
        Set<Object> users;
        AuthorityType authType = AuthorityType.getAuthorityType((String)authority);
        if (authType.equals((Object)AuthorityType.USER)) {
            users = new HashSet(1, 1.0f);
            if (this.personService.personExists(authority)) {
                users.add(authority);
            }
        } else if (authType.equals((Object)AuthorityType.GROUP)) {
            users = this.authorityService.getContainedAuthorities(AuthorityType.USER, authority, false);
            for (String string : users) {
                if (this.personService.personExists(string)) continue;
                users.remove(string);
            }
        } else {
            users = Collections.emptySet();
        }
        return users;
    }

    private String getWebProjectsPath() {
        return "/app:company_home/app:wcm";
    }

    private class CreateSandboxTransactionListener
    extends TransactionListenerAdapter {
        private List<SandboxInfo> sandboxInfoList;
        private List<String> webAppNames;

        public CreateSandboxTransactionListener(List<SandboxInfo> sandboxInfoList, List<String> webAppNames) {
            this.sandboxInfoList = sandboxInfoList;
            this.webAppNames = webAppNames;
        }

        @Override
        public void afterCommit() {
            for (SandboxInfo sandboxInfo : this.sandboxInfoList) {
                String newlyInvitedStoreName = WCMUtil.buildStagingStoreName(sandboxInfo.getMainStoreName());
                for (String webAppName : this.webAppNames) {
                    String path = WCMUtil.buildStoreWebappPath(newlyInvitedStoreName, webAppName);
                    WCMUtil.updateVServerWebapp(WebProjectServiceImpl.this.virtServerRegistry, path, true);
                }
            }
        }
    }

    private class CreateWebAppTransactionListener
    extends TransactionListenerAdapter {
        private String wpStoreId;
        private String webApp;

        public CreateWebAppTransactionListener(String wpStoreId, String webApp) {
            this.wpStoreId = wpStoreId;
            this.webApp = webApp;
        }

        @Override
        public void afterCommit() {
            if (this.wpStoreId != null) {
                String newStoreName = WCMUtil.buildStagingStoreName(this.wpStoreId);
                String path = WCMUtil.buildStoreWebappPath(newStoreName, this.webApp);
                WCMUtil.updateVServerWebapp(WebProjectServiceImpl.this.virtServerRegistry, path, true);
            }
        }
    }
}

