/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.webproject.script;

import java.util.List;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.wcm.asset.AssetService;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.alfresco.wcm.webproject.WebProjectService;
import org.alfresco.wcm.webproject.script.WebProject;

public class WebProjects
extends BaseScopableProcessorExtension {
    private ServiceRegistry serviceRegistry;
    private WebProjectService webProjectService;
    private SandboxService sandboxService;
    private AssetService assetService;
    private NamespaceService namespaceService;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setWebProjectService(WebProjectService webProjectService) {
        this.webProjectService = webProjectService;
    }

    public WebProjectService getWebProjectService() {
        return this.webProjectService;
    }

    public void setSandboxService(SandboxService sandboxService) {
        this.sandboxService = sandboxService;
    }

    public SandboxService getSandboxService() {
        return this.sandboxService;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    public AssetService getAssetService() {
        return this.assetService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public WebProject createWebProject(String dnsName, String name, String title, String description) {
        WebProjectInfo info = this.webProjectService.createWebProject(dnsName, name, title, description);
        return new WebProject(this, info);
    }

    public WebProject getWebProject(String webProjectRef) {
        WebProjectInfo info = this.webProjectService.getWebProject(webProjectRef);
        if (info != null) {
            WebProject retVal = new WebProject(this, info);
            return retVal;
        }
        return null;
    }

    public WebProject[] listWebProjects() {
        List<WebProjectInfo> projects = this.webProjectService.listWebProjects();
        WebProject[] ret = new WebProject[projects.size()];
        int i = 0;
        for (WebProjectInfo info : projects) {
            ret[i++] = new WebProject(this, info);
        }
        return ret;
    }

    public WebProject[] listWebProjects(String userName) {
        List<WebProjectInfo> projects = this.webProjectService.listWebProjects(userName);
        WebProject[] ret = new WebProject[projects.size()];
        int i = 0;
        for (WebProjectInfo info : projects) {
            ret[i++] = new WebProject(this, info);
        }
        return ret;
    }
}

