/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.alfresco.util.Pair;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class CachingDateFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = 3258415049197565235L;
    public static final String FORMAT_FULL_GENERIC = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String FORMAT_CMIS_SQL = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final StringAndResolution[] LENIENT_FORMATS;
    public static final String FORMAT_DATE_GENERIC = "yyyy-MM-dd";
    public static final String FORMAT_TIME_GENERIC = "HH:mm:ss";
    private static ThreadLocal<SimpleDateFormat> s_localDateFormat;
    private static ThreadLocal<SimpleDateFormat> s_localDateOnlyFormat;
    private static ThreadLocal<SimpleDateFormat> s_localTimeOnlyFormat;
    private static ThreadLocal<SimpleDateFormat> s_localCmisSqlDatetime;
    private static ThreadLocal<SimpleDateFormatAndResolution[]> s_lenientParsers;
    private transient Map<String, Date> cacheDates = new WeakHashMap<String, Date>(89);

    private CachingDateFormat(String format) {
        super(format);
    }

    public String toString() {
        return this.toPattern();
    }

    public static SimpleDateFormat getDateFormat(int length, Locale locale, boolean lenient) {
        SimpleDateFormat dateFormat = (SimpleDateFormat)CachingDateFormat.getDateInstance(length, locale);
        String pattern = dateFormat.toPattern();
        return CachingDateFormat.getDateFormat(pattern, lenient);
    }

    public static SimpleDateFormat getDateTimeFormat(int dateLength, int timeLength, Locale locale, boolean lenient) {
        SimpleDateFormat dateFormat = (SimpleDateFormat)CachingDateFormat.getDateTimeInstance(dateLength, timeLength, locale);
        String pattern = dateFormat.toPattern();
        return CachingDateFormat.getDateFormat(pattern, lenient);
    }

    public static SimpleDateFormat getDateFormat(String pattern, boolean lenient) {
        CachingDateFormat dateFormat = new CachingDateFormat(pattern);
        dateFormat.setLenient(lenient);
        return dateFormat;
    }

    public static SimpleDateFormat getDateFormat() {
        if (s_localDateFormat.get() != null) {
            return s_localDateFormat.get();
        }
        CachingDateFormat formatter = new CachingDateFormat(FORMAT_FULL_GENERIC);
        formatter.setLenient(false);
        s_localDateFormat.set(formatter);
        return s_localDateFormat.get();
    }

    public static SimpleDateFormat getCmisSqlDatetimeFormat() {
        if (s_localCmisSqlDatetime.get() != null) {
            return s_localCmisSqlDatetime.get();
        }
        CachingDateFormat formatter = new CachingDateFormat(FORMAT_CMIS_SQL);
        formatter.setLenient(false);
        s_localCmisSqlDatetime.set(formatter);
        return s_localCmisSqlDatetime.get();
    }

    public static SimpleDateFormat getDateOnlyFormat() {
        if (s_localDateOnlyFormat.get() != null) {
            return s_localDateOnlyFormat.get();
        }
        CachingDateFormat formatter = new CachingDateFormat(FORMAT_DATE_GENERIC);
        formatter.setLenient(false);
        s_localDateOnlyFormat.set(formatter);
        return s_localDateOnlyFormat.get();
    }

    public static SimpleDateFormat getTimeOnlyFormat() {
        if (s_localTimeOnlyFormat.get() != null) {
            return s_localTimeOnlyFormat.get();
        }
        CachingDateFormat formatter = new CachingDateFormat(FORMAT_TIME_GENERIC);
        formatter.setLenient(false);
        s_localTimeOnlyFormat.set(formatter);
        return s_localTimeOnlyFormat.get();
    }

    @Override
    public Date parse(String text, ParsePosition pos) {
        Date cached = this.cacheDates.get(text);
        if (cached == null) {
            Date date = super.parse(text, pos);
            if (date != null && pos.getIndex() == text.length()) {
                this.cacheDates.put(text, date);
                Date clonedDate = (Date)date.clone();
                return clonedDate;
            }
            return date;
        }
        pos.setIndex(text.length());
        Date clonedDate = (Date)cached.clone();
        return clonedDate;
    }

    public static Pair<Date, Integer> lenientParse(String text, int minimumResolution) throws ParseException {
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        try {
            Date parsed = fmt.parseDateTime(text).toDate();
            return new Pair<Date, Integer>(parsed, 14);
        }
        catch (IllegalArgumentException e) {
            SimpleDateFormatAndResolution[] formatters;
            for (SimpleDateFormatAndResolution formatter : formatters = CachingDateFormat.getLenientFormatters()) {
                if (formatter.resolution < minimumResolution) continue;
                ParsePosition pp = new ParsePosition(0);
                Date parsed = formatter.simpleDateFormat.parse(text, pp);
                if (pp.getIndex() < text.length() || parsed == null) continue;
                return new Pair<Date, Integer>(parsed, formatter.resolution);
            }
            throw new ParseException("Unknown date format", 0);
        }
    }

    public static SimpleDateFormatAndResolution[] getLenientFormatters() {
        if (s_lenientParsers.get() != null) {
            return s_lenientParsers.get();
        }
        int i = 0;
        SimpleDateFormatAndResolution[] formatters = new SimpleDateFormatAndResolution[LENIENT_FORMATS.length];
        for (StringAndResolution format : LENIENT_FORMATS) {
            CachingDateFormat formatter = new CachingDateFormat(format.string);
            formatter.setLenient(false);
            formatters[i++] = new SimpleDateFormatAndResolution(formatter, format.resolution);
        }
        s_lenientParsers.set(formatters);
        return s_lenientParsers.get();
    }

    static {
        ArrayList<StringAndResolution> list = new ArrayList<StringAndResolution>();
        list.add(new StringAndResolution(FORMAT_CMIS_SQL, 14));
        list.add(new StringAndResolution("yyyy-MM-dd'T'HH:mm:ss.SSS", 14));
        list.add(new StringAndResolution(FORMAT_FULL_GENERIC, 13));
        list.add(new StringAndResolution("yyyy-MM-dd'T'HH:mm", 12));
        list.add(new StringAndResolution("yyyy-MM-dd'T'HH", 11));
        list.add(new StringAndResolution("yyyy-MM-dd'T'", 5));
        list.add(new StringAndResolution(FORMAT_DATE_GENERIC, 5));
        list.add(new StringAndResolution("yyyy-MM", 2));
        list.add(new StringAndResolution("yyyy-MMM-dd'T'HH:mm:ss.SSSZ", 14));
        list.add(new StringAndResolution("yyyy-MMM-dd'T'HH:mm:ss.SSS", 14));
        list.add(new StringAndResolution("yyyy-MMM-dd'T'HH:mm:ss", 13));
        list.add(new StringAndResolution("yyyy-MMM-dd'T'HH:mm", 12));
        list.add(new StringAndResolution("yyyy-MMM-dd'T'HH", 11));
        list.add(new StringAndResolution("yyyy-MMM-dd'T'", 5));
        list.add(new StringAndResolution("yyyy-MMM-dd", 5));
        list.add(new StringAndResolution("yyyy-MMM", 2));
        list.add(new StringAndResolution("yyyy", 1));
        LENIENT_FORMATS = list.toArray(new StringAndResolution[0]);
        s_localDateFormat = new ThreadLocal();
        s_localDateOnlyFormat = new ThreadLocal();
        s_localTimeOnlyFormat = new ThreadLocal();
        s_localCmisSqlDatetime = new ThreadLocal();
        s_lenientParsers = new ThreadLocal();
    }

    public static class SimpleDateFormatAndResolution {
        SimpleDateFormat simpleDateFormat;
        int resolution;

        SimpleDateFormatAndResolution(SimpleDateFormat simpleDateFormat, int resolution) {
            this.simpleDateFormat = simpleDateFormat;
            this.resolution = resolution;
        }

        public SimpleDateFormat getSimpleDateFormat() {
            return this.simpleDateFormat;
        }

        public int getResolution() {
            return this.resolution;
        }
    }

    public static class StringAndResolution {
        String string;
        int resolution;

        public int getResolution() {
            return this.resolution;
        }

        public void setResolution(int resolution) {
            this.resolution = resolution;
        }

        StringAndResolution(String string, int resolution) {
            this.string = string;
            this.resolution = resolution;
        }
    }
}

