/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.regex.Pattern;
import org.alfresco.util.GUID;

public class DNSNameMangler {
    private static final String SEPARATOR = ".";
    private static final int MAX_INTERNAL_DNS_NAME_LENGTH = 150;
    private static final Pattern RX_DNS_LEGAL = Pattern.compile("[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*");
    private static final Pattern RX_ILLEGAL_CHARS = Pattern.compile("[^a-zA-Z0-9]");
    private static final Pattern RX_HYPHENS = Pattern.compile("\\-+");
    private static final Pattern RX_LEADING_HYPHEN = Pattern.compile("^\\-");
    private static final Pattern RX_TRAILING_HYPHEN = Pattern.compile("\\-$");

    public static String MakeDNSName(String ... components) {
        StringBuilder builder = new StringBuilder();
        for (int i = components.length - 1; i > 0; --i) {
            builder.append(DNSNameMangler.MangleOne(components[i]));
            builder.append(SEPARATOR);
        }
        builder.append(DNSNameMangler.MangleOne(components[0]));
        String result = builder.toString();
        if (result.length() <= 150 && RX_DNS_LEGAL.matcher(result).matches()) {
            return result;
        }
        result = components[0] + SEPARATOR + "guid-" + GUID.generate();
        if ((result = DNSNameMangler.MangleOne(result)).length() <= 150 && RX_DNS_LEGAL.matcher(result).matches()) {
            return result;
        }
        return DNSNameMangler.MangleOne("guid-" + GUID.generate());
    }

    static String MangleOne(String name) {
        name = RX_ILLEGAL_CHARS.matcher(name).replaceAll("-");
        name = RX_LEADING_HYPHEN.matcher(name).replaceAll("x");
        name = RX_TRAILING_HYPHEN.matcher(name).replaceAll("x");
        return name;
    }
}

