/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.exec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.util.Pair;

public class ExecParameterTokenizer {
    private final String str;
    private List<String> tokens;

    public ExecParameterTokenizer(String str) {
        this.str = str;
    }

    public List<String> getAllTokens() {
        block6: {
            if (this.str == null) {
                throw new NullPointerException("Illegal null string cannot be tokenized.");
            }
            if (this.tokens != null) break block6;
            this.tokens = new ArrayList<String>();
            if (this.str.indexOf(39) == -1 && this.str.indexOf(34) == -1) {
                StringTokenizer standardTokenizer = new StringTokenizer(this.str);
                while (standardTokenizer.hasMoreTokens()) {
                    this.tokens.add(standardTokenizer.nextToken());
                }
            } else {
                ArrayList<Pair<Integer, Integer>> quotedRegions = new ArrayList<Pair<Integer, Integer>>();
                Pair<Integer, Integer> next = this.identifyNextQuotedRegion(this.str, 0);
                while (next != null) {
                    quotedRegions.add(next);
                    next = this.identifyNextQuotedRegion(this.str, next.getSecond() + 1);
                }
                List<Substring> substrings = this.getSubstrings(this.str, quotedRegions);
                for (Substring r : substrings) {
                    this.tokens.addAll(r.getTokens());
                }
            }
        }
        return this.tokens;
    }

    private List<Substring> getSubstrings(String str, List<Pair<Integer, Integer>> quotedRegionIndices) {
        ArrayList<Substring> result = new ArrayList<Substring>();
        int cursorPosition = 0;
        for (Pair<Integer, Integer> nextQuotedRegionIndices : quotedRegionIndices) {
            if (cursorPosition < nextQuotedRegionIndices.getFirst()) {
                int startIndexOfNextQuotedRegion = nextQuotedRegionIndices.getFirst() - 1;
                result.add(new UnquotedSubstring(str.substring(cursorPosition, startIndexOfNextQuotedRegion)));
                cursorPosition = startIndexOfNextQuotedRegion;
            }
            result.add(new QuotedSubstring(str.substring(nextQuotedRegionIndices.getFirst(), nextQuotedRegionIndices.getSecond())));
            cursorPosition = nextQuotedRegionIndices.getSecond();
        }
        if (cursorPosition < str.length() - 1) {
            result.add(new UnquotedSubstring(str.substring(cursorPosition, str.length() - 1)));
        }
        return result;
    }

    private Pair<Integer, Integer> identifyNextQuotedRegion(String str, int startingIndex) {
        int indexOfNextSingleQuote = str.indexOf(39, startingIndex);
        int indexOfNextDoubleQuote = str.indexOf(34, startingIndex);
        if (indexOfNextSingleQuote == -1 && indexOfNextDoubleQuote == -1) {
            return null;
        }
        if (indexOfNextSingleQuote > -1 && indexOfNextDoubleQuote > -1) {
            int indexOfNextQuote = Math.min(indexOfNextSingleQuote, indexOfNextDoubleQuote);
            char quoteChar = str.charAt(indexOfNextQuote);
            return this.findIndexOfClosingQuote(str, indexOfNextQuote, quoteChar);
        }
        int indexOfNextQuote = Math.max(indexOfNextSingleQuote, indexOfNextDoubleQuote);
        char quoteChar = str.charAt(indexOfNextQuote);
        return this.findIndexOfClosingQuote(str, indexOfNextQuote, quoteChar);
    }

    private Pair<Integer, Integer> findIndexOfClosingQuote(String str, int indexOfStartingQuote, char quoteChar) {
        int indexAfterClosingQuote = str.indexOf(quoteChar, indexOfStartingQuote + 1) + 1;
        if (indexAfterClosingQuote == 0) {
            throw new IllegalArgumentException("No closing " + quoteChar + "quote in" + str);
        }
        return new Pair<Integer, Integer>(indexOfStartingQuote, indexAfterClosingQuote);
    }

    public class QuotedSubstring
    implements Substring {
        private final String regionString;

        public QuotedSubstring(String str) {
            this.regionString = str;
        }

        @Override
        public List<String> getTokens() {
            String stringWithoutQuotes = this.regionString.substring(1, this.regionString.length() - 1);
            return Arrays.asList(stringWithoutQuotes);
        }

        public String toString() {
            return QuotedSubstring.class.getSimpleName() + ": '" + this.regionString + '\'';
        }
    }

    public class UnquotedSubstring
    implements Substring {
        private final String regionString;

        public UnquotedSubstring(String str) {
            this.regionString = str;
        }

        @Override
        public List<String> getTokens() {
            StringTokenizer t = new StringTokenizer(this.regionString);
            ArrayList<String> result = new ArrayList<String>();
            while (t.hasMoreTokens()) {
                result.add(t.nextToken());
            }
            return result;
        }

        public String toString() {
            return UnquotedSubstring.class.getSimpleName() + ": '" + this.regionString + '\'';
        }
    }

    public static interface Substring {
        public List<String> getTokens();
    }
}

