/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.xml;

import com.sun.codemodel.JCodeModel;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import java.io.File;
import java.net.URL;
import org.springframework.util.ResourceUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class SchemaHelper {
    public static void main(String ... args) {
        String dirStr;
        String urlStr;
        if (args.length < 2 || !args[0].startsWith("--compile-xsd=") && !args[1].startsWith("--output-dir=")) {
            System.out.println("Usage: SchemaHelper --compile-xsd=<URL> --output-dir=<directory>");
            System.exit(1);
        }
        if ((urlStr = args[0].substring(14)).length() == 0) {
            System.out.println("Usage: SchemaHelper --compile-xsd=<URL> --output-dir=<directory>");
            System.exit(1);
        }
        if ((dirStr = args[1].substring(13)).length() == 0) {
            System.out.println("Usage: SchemaHelper --compile-xsd=<URL> --output-dir=<directory>");
            System.exit(1);
        }
        try {
            URL url = ResourceUtils.getURL((String)urlStr);
            File dir = new File(dirStr);
            if (!dir.exists() || !dir.isDirectory()) {
                System.out.println("Output directory not found: " + dirStr);
                System.exit(1);
            }
            ErrorListener errorListener = new ErrorListener(){

                public void warning(SAXParseException e) {
                    System.out.println("WARNING: " + e.getMessage());
                }

                public void info(SAXParseException e) {
                    System.out.println("INFO: " + e.getMessage());
                }

                public void fatalError(SAXParseException e) {
                    SchemaHelper.handleException(urlStr, e);
                }

                public void error(SAXParseException e) {
                    SchemaHelper.handleException(urlStr, e);
                }
            };
            SchemaCompiler compiler = XJC.createSchemaCompiler();
            compiler.setErrorListener(errorListener);
            compiler.parseSchema(new InputSource(url.toExternalForm()));
            S2JJAXBModel model = compiler.bind();
            if (model == null) {
                System.out.println("Failed to produce binding model for URL " + urlStr);
                System.exit(1);
            }
            JCodeModel codeModel = model.generateCode(null, errorListener);
            codeModel.build(dir);
        }
        catch (Throwable e) {
            SchemaHelper.handleException(urlStr, e);
            System.exit(1);
        }
    }

    private static void handleException(String urlStr, Throwable e) {
        System.out.println("Error processing XSD " + urlStr);
        e.printStackTrace();
    }
}

