/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.alfresco.opencmis.mapping.AbstractLuceneBuilder;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class ParentLuceneBuilder
extends AbstractLuceneBuilder {
    private DictionaryService dictionaryService;

    public ParentLuceneBuilder(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    private StoreRef getStore(AbstractLuceneQueryParser lqp) {
        ArrayList<StoreRef> stores = lqp.getSearchParameters().getStores();
        if (stores.size() < 1) {
            return StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        }
        return stores.get(0);
    }

    @Override
    public String getLuceneFieldName() {
        return "PARENT";
    }

    private String getValueAsString(AbstractLuceneQueryParser lqp, Serializable value) {
        String nodeRefStr = (String)((Object)value);
        if (!NodeRef.isNodeRef((String)((Object)value))) {
            StoreRef storeRef = this.getStore(lqp);
            nodeRefStr = storeRef.toString() + "/" + (String)((Object)value);
        }
        Object converted = DefaultTypeConverter.INSTANCE.convert(this.dictionaryService.getDataType(DataTypeDefinition.NODE_REF), (Object)nodeRefStr);
        String asString = DefaultTypeConverter.INSTANCE.convert(String.class, converted);
        return asString;
    }

    @Override
    public Query buildLuceneEquality(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(lqp, value);
        return lqp.getFieldQuery(field, stringValue, AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneExists(AbstractLuceneQueryParser lqp, Boolean not) throws ParseException {
        if (not.booleanValue()) {
            return new TermQuery(new Term("ISROOT", "T"));
        }
        return new MatchAllDocsQuery();
    }

    @Override
    public Query buildLuceneIn(AbstractLuceneQueryParser lqp, Collection<Serializable> values, Boolean not, PredicateMode mode) throws ParseException {
        String field = this.getLuceneFieldName();
        if (values.size() == 0) {
            if (not.booleanValue()) {
                return new MatchAllDocsQuery();
            }
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        if (values.size() == 1) {
            Serializable value = values.iterator().next();
            if (not.booleanValue()) {
                return lqp.getDoesNotMatchFieldQuery(field, this.getValueAsString(lqp, value), AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
            }
            return lqp.getFieldQuery(field, this.getValueAsString(lqp, value), AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        if (not.booleanValue()) {
            booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        }
        for (Serializable value : values) {
            Query any = lqp.getFieldQuery(field, this.getValueAsString(lqp, value), AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
            if (not.booleanValue()) {
                booleanQuery.add(any, BooleanClause.Occur.MUST_NOT);
                continue;
            }
            booleanQuery.add(any, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    @Override
    public Query buildLuceneInequality(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(lqp, value);
        return lqp.getDoesNotMatchFieldQuery(field, stringValue, AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneLike(AbstractLuceneQueryParser lqp, Serializable value, Boolean not) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(lqp, value);
        if (not.booleanValue()) {
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
            booleanQuery.add(lqp.getLikeQuery(field, stringValue, AnalysisMode.IDENTIFIER), BooleanClause.Occur.MUST_NOT);
            return booleanQuery;
        }
        return lqp.getLikeQuery(field, stringValue, AnalysisMode.IDENTIFIER);
    }

    @Override
    public String getLuceneSortField(AbstractLuceneQueryParser lqp) {
        return this.getLuceneFieldName();
    }
}

