/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.alfresco.repo.dictionary.M2Constraint;
import org.alfresco.repo.dictionary.M2Label;
import org.alfresco.repo.dictionary.M2ModelDiff;
import org.alfresco.repo.dictionary.M2NamedValue;
import org.alfresco.repo.dictionary.M2PropertyDefinition;
import org.alfresco.repo.dictionary.ModelQuery;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.dictionary.constraint.NumericRangeConstraint;
import org.alfresco.repo.dictionary.constraint.RegexConstraint;
import org.alfresco.repo.dictionary.constraint.RegisteredConstraint;
import org.alfresco.repo.dictionary.constraint.StringLengthConstraint;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.PropertyAccessException;

class M2ConstraintDefinition
implements ConstraintDefinition {
    private static final String PROP_SHORT_NAME = "shortName";
    private static final String PROP_TITLE = "title";
    private static final String PROP_DESCRIPTION = "description";
    public static final String ERR_CYCLIC_REF = "d_dictionary.constraint.err.cyclic_ref";
    public static final String ERR_TYPE_AND_REF = "d_dictionary.constraint.err.type_and_ref";
    public static final String ERR_TYPE_OR_REF = "d_dictionary.constraint.err.type_or_ref";
    public static final String ERR_REF_NOT_FOUND = "d_dictionary.constraint.err.ref_not_found";
    public static final String ERR_ANON_NEEDS_PROPERTY = "d_dictionary.constraint.err.anon_needs_property";
    public static final String ERR_INVALID_TYPE = "d_dictionary.constraint.err.invalid_type";
    public static final String ERR_SIMPLE_AND_LIST = "d_dictionary.constraint.err.property_simple_and_list";
    public static final String ERR_CONSTRUCT_FAILURE = "d_dictionary.constraint.err.construct_failure";
    public static final String ERR_PROPERTY_MISMATCH = "d_dictionary.constraint.err.property_mismatch";
    public static final String ERR_RESERVED_PROPERTY = "d_dictionary.constraint.err.reserved_property";
    private static int anonPropCount = 0;
    private ModelDefinition model;
    private NamespacePrefixResolver prefixResolver;
    private M2Constraint m2Constraint;
    private QName name;
    private Constraint constraint;
    private boolean resolving;
    private transient MessageLookup staticMessageLookup = new StaticMessageLookup();

    M2ConstraintDefinition(M2PropertyDefinition m2PropertyDef, M2Constraint m2Constraint, NamespacePrefixResolver prefixResolver) {
        this(m2PropertyDef.getModel(), m2PropertyDef, m2Constraint, prefixResolver);
    }

    M2ConstraintDefinition(ModelDefinition modelDefinition, M2PropertyDefinition m2PropertyDef, M2Constraint m2Constraint, NamespacePrefixResolver prefixResolver) {
        this.model = modelDefinition;
        this.m2Constraint = m2Constraint;
        this.prefixResolver = prefixResolver;
        String constraintName = m2Constraint.getName();
        if (constraintName == null) {
            if (m2PropertyDef == null) {
                throw new DictionaryException(ERR_ANON_NEEDS_PROPERTY);
            }
            String localName = m2PropertyDef.getName().getLocalName() + "_anon_" + ++anonPropCount;
            this.name = QName.createQName(m2PropertyDef.getName().getNamespaceURI(), localName);
            m2Constraint.setName(this.name.getPrefixedQName(prefixResolver).toPrefixString());
        } else {
            this.name = QName.createQName(m2Constraint.getName(), prefixResolver);
            if (!this.model.isNamespaceDefined(this.name.getNamespaceURI())) {
                throw new DictionaryException("Cannot define constraint " + this.name.toPrefixString() + " as namespace " + this.name.getNamespaceURI() + " is not defined by model " + this.model.getName().toPrefixString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resolveDependencies(ModelQuery query, boolean enableConstraintClassLoading) {
        if (this.resolving) {
            throw new DictionaryException(ERR_CYCLIC_REF, this.name.toPrefixString());
        }
        try {
            this.resolving = true;
            this.resolveInternal(query, enableConstraintClassLoading);
        }
        finally {
            this.resolving = false;
        }
    }

    private synchronized void resolveInternal(ModelQuery query, boolean enableConstraintClassLoading) {
        if (this.constraint != null) {
            return;
        }
        String shortName = this.name.toPrefixString();
        String ref = this.m2Constraint.getRef();
        String type = this.m2Constraint.getType();
        String title = this.m2Constraint.getTitle();
        String description = this.m2Constraint.getDescription();
        if (ref != null && type != null) {
            throw new DictionaryException(ERR_TYPE_AND_REF, shortName);
        }
        if (ref == null && type == null) {
            throw new DictionaryException(ERR_TYPE_OR_REF, shortName);
        }
        if (ref != null) {
            QName qnameRef = QName.createQName(ref, this.prefixResolver);
            M2ConstraintDefinition constraintDef = (M2ConstraintDefinition)query.getConstraint(qnameRef);
            if (constraintDef == null) {
                throw new DictionaryException(ERR_REF_NOT_FOUND, ref, shortName);
            }
            constraintDef.resolveDependencies(query, enableConstraintClassLoading);
            this.constraint = constraintDef.getConstraint();
            if (this.m2Constraint.getTitle() == null) {
                this.m2Constraint.setTitle(constraintDef.getTitle(null));
            }
            if (this.m2Constraint.getDescription() == null) {
                this.m2Constraint.setDescription(constraintDef.getDescription(null));
            }
        } else {
            try {
                ConstraintType constraintType = ConstraintType.valueOf(type);
                this.constraint = constraintType.newInstance();
            }
            catch (IllegalArgumentException e) {
                try {
                    if (enableConstraintClassLoading) {
                        Class<?> clazz = Class.forName(type);
                        this.constraint = (Constraint)clazz.newInstance();
                    }
                }
                catch (ClassNotFoundException ee) {
                    throw new DictionaryException(ERR_INVALID_TYPE, type, shortName);
                }
                catch (ClassCastException ee) {
                    throw new DictionaryException(ERR_INVALID_TYPE, type, shortName);
                }
                catch (Exception ee) {
                    throw new DictionaryException(ERR_CONSTRUCT_FAILURE, type, shortName);
                }
            }
            if (this.constraint != null) {
                BeanWrapperImpl beanWrapper = new BeanWrapperImpl((Object)this.constraint);
                List<M2NamedValue> constraintNamedValues = this.m2Constraint.getParameters();
                if (constraintNamedValues != null) {
                    for (M2NamedValue namedValue : constraintNamedValues) {
                        String namedValueName = namedValue.getName();
                        if (namedValueName.equals(PROP_SHORT_NAME)) {
                            throw new DictionaryException(ERR_RESERVED_PROPERTY, PROP_SHORT_NAME, namedValueName);
                        }
                        Object value = null;
                        if (namedValue.getSimpleValue() != null && namedValue.getListValue() != null) {
                            throw new DictionaryException(ERR_SIMPLE_AND_LIST, shortName, namedValue.getName());
                        }
                        if (namedValue.getSimpleValue() != null) {
                            value = namedValue.getSimpleValue();
                        } else if (namedValue.getListValue() != null) {
                            value = namedValue.getListValue();
                        }
                        try {
                            beanWrapper.setPropertyValue(namedValueName, value);
                        }
                        catch (PropertyAccessException e) {
                            throw new DictionaryException(ERR_PROPERTY_MISMATCH, e, namedValueName, shortName);
                        }
                        catch (InvalidPropertyException e) {
                            throw new DictionaryException(ERR_PROPERTY_MISMATCH, e, namedValueName, shortName);
                        }
                    }
                    if (beanWrapper.isWritableProperty(PROP_SHORT_NAME)) {
                        try {
                            beanWrapper.setPropertyValue(PROP_SHORT_NAME, (Object)shortName);
                        }
                        catch (PropertyAccessException e) {
                            throw new DictionaryException(ERR_PROPERTY_MISMATCH, e, shortName, shortName);
                        }
                        catch (InvalidPropertyException e) {
                            throw new DictionaryException(ERR_PROPERTY_MISMATCH, e, shortName, shortName);
                        }
                    }
                    if (title != null && beanWrapper.isWritableProperty(PROP_TITLE)) {
                        beanWrapper.setPropertyValue(PROP_TITLE, (Object)title);
                    }
                    if (title != null && beanWrapper.isWritableProperty(PROP_DESCRIPTION)) {
                        beanWrapper.setPropertyValue(PROP_DESCRIPTION, (Object)description);
                    }
                }
                this.constraint.initialize();
            }
        }
    }

    public String toString() {
        return this.getName().toString();
    }

    @Override
    public ModelDefinition getModel() {
        return this.model;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.getTitle(this.staticMessageLookup);
    }

    @Override
    public String getDescription() {
        return this.getDescription(this.staticMessageLookup);
    }

    @Override
    public String getTitle(MessageLookup messageLookup) {
        String value = M2Label.getLabel(this.model, messageLookup, "constraint", this.name, PROP_TITLE);
        if (value == null) {
            value = this.m2Constraint.getTitle();
        }
        return value;
    }

    @Override
    public String getDescription(MessageLookup messageLookup) {
        String value = M2Label.getLabel(this.model, messageLookup, "constraint", this.name, PROP_DESCRIPTION);
        if (value == null) {
            value = this.m2Constraint.getDescription();
        }
        return value;
    }

    @Override
    public Constraint getConstraint() {
        return this.constraint;
    }

    @Override
    public QName getRef() {
        QName refQName = null;
        String ref = this.m2Constraint.getRef();
        if (ref != null) {
            refQName = QName.createQName(ref, this.prefixResolver);
        }
        return refQName;
    }

    M2ModelDiff diffConstraint(ConstraintDefinition conDef) {
        M2ModelDiff modelDiff = null;
        boolean isUpdated = false;
        boolean isUpdatedIncrementally = false;
        if (this == conDef) {
            modelDiff = new M2ModelDiff(this.name, "TYPE_CONSTRAINT", "unchanged");
            return modelDiff;
        }
        if (!this.name.equals(conDef.getName())) {
            isUpdated = true;
        }
        if (!EqualsHelper.nullSafeEquals((String)this.getTitle(null), (String)conDef.getTitle(null), (boolean)false)) {
            isUpdatedIncrementally = true;
        }
        if (!EqualsHelper.nullSafeEquals((String)this.getDescription(null), (String)conDef.getDescription(null), (boolean)false)) {
            isUpdatedIncrementally = true;
        }
        if (!EqualsHelper.nullSafeEquals((Object)this.getConstraint().getType(), (Object)conDef.getConstraint().getType())) {
            isUpdated = true;
        }
        modelDiff = isUpdated ? new M2ModelDiff(this.name, "TYPE_CONSTRAINT", "updated") : (isUpdatedIncrementally ? new M2ModelDiff(this.name, "TYPE_CONSTRAINT", "updated_inc") : new M2ModelDiff(this.name, "TYPE_CONSTRAINT", "unchanged"));
        return modelDiff;
    }

    static Collection<M2ModelDiff> diffConstraintLists(Collection<ConstraintDefinition> previousConstraints, Collection<ConstraintDefinition> newConstraints) {
        boolean found;
        ArrayList<M2ModelDiff> modelDiffs = new ArrayList<M2ModelDiff>();
        for (ConstraintDefinition previousConstraint : previousConstraints) {
            found = false;
            for (ConstraintDefinition newConstraint : newConstraints) {
                if (!newConstraint.getName().equals(previousConstraint.getName())) continue;
                modelDiffs.add(((M2ConstraintDefinition)previousConstraint).diffConstraint(previousConstraint));
                found = true;
                break;
            }
            if (found) continue;
            modelDiffs.add(new M2ModelDiff(previousConstraint.getName(), "TYPE_CONSTRAINT", "deleted"));
        }
        for (ConstraintDefinition newConstraint : newConstraints) {
            found = false;
            for (ConstraintDefinition previousConstraint : previousConstraints) {
                if (!newConstraint.getName().equals(previousConstraint.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            modelDiffs.add(new M2ModelDiff(newConstraint.getName(), "TYPE_CONSTRAINT", "created"));
        }
        return modelDiffs;
    }

    public static enum ConstraintType {
        REGISTERED{

            @Override
            protected Constraint newInstance() {
                return new RegisteredConstraint();
            }
        }
        ,
        REGEX{

            @Override
            protected Constraint newInstance() {
                return new RegexConstraint();
            }
        }
        ,
        MINMAX{

            @Override
            protected Constraint newInstance() {
                return new NumericRangeConstraint();
            }
        }
        ,
        LENGTH{

            @Override
            protected Constraint newInstance() {
                return new StringLengthConstraint();
            }
        }
        ,
        LIST{

            @Override
            protected Constraint newInstance() {
                return new ListOfValuesConstraint();
            }
        };


        protected abstract Constraint newInstance();
    }
}

