/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import java.util.Locale;
import java.util.StringTokenizer;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.util.EqualsHelper;
import org.springframework.extensions.surf.util.I18NUtil;

@AlfrescoPublicApi
public class ContentData
implements Serializable {
    private static final long serialVersionUID = 8979634213050121462L;
    private static char[] INVALID_CONTENT_URL_CHARS = new char[]{'|'};
    private final String contentUrl;
    private final String mimetype;
    private final long size;
    private final String encoding;
    private final Locale locale;

    public static ContentData createContentProperty(String contentPropertyStr) {
        String contentUrl = null;
        String mimetype = null;
        long size = 0L;
        String encoding = null;
        Locale locale = null;
        StringTokenizer tokenizer = new StringTokenizer(contentPropertyStr, "|");
        while (tokenizer.hasMoreTokens()) {
            String localeStr;
            String token = tokenizer.nextToken();
            if (token.startsWith("contentUrl=")) {
                contentUrl = token.substring(11);
                if (contentUrl.length() != 0) continue;
                contentUrl = null;
                continue;
            }
            if (token.startsWith("mimetype=")) {
                mimetype = token.substring(9);
                if (mimetype.length() != 0) continue;
                mimetype = null;
                continue;
            }
            if (token.startsWith("size=")) {
                String sizeStr = token.substring(5);
                if (sizeStr.length() <= 0) continue;
                size = Long.parseLong(sizeStr);
                continue;
            }
            if (token.startsWith("encoding=")) {
                encoding = token.substring(9);
                if (encoding.length() != 0) continue;
                encoding = null;
                continue;
            }
            if (!token.startsWith("locale=") || (localeStr = token.substring(7)).length() <= 0) continue;
            locale = I18NUtil.parseLocale((String)localeStr);
        }
        ContentData property = new ContentData(contentUrl, mimetype, size, encoding, locale);
        return property;
    }

    public static ContentData setMimetype(ContentData existing, String mimetype) {
        ContentData ret = new ContentData(existing == null ? null : existing.contentUrl, mimetype, existing == null ? 0L : existing.size, existing == null ? "UTF-8" : existing.encoding, existing == null ? null : existing.locale);
        return ret;
    }

    public static ContentData setEncoding(ContentData existing, String encoding) {
        ContentData ret = new ContentData(existing == null ? null : existing.contentUrl, existing == null ? null : existing.mimetype, existing == null ? 0L : existing.size, encoding, existing == null ? null : existing.locale);
        return ret;
    }

    public static boolean hasContent(ContentData contentData) {
        if (contentData == null) {
            return false;
        }
        return contentData.contentUrl != null;
    }

    protected ContentData(ContentData original) {
        this.contentUrl = original.contentUrl;
        this.encoding = original.encoding;
        this.locale = original.locale;
        this.mimetype = original.mimetype;
        this.size = original.size;
    }

    public ContentData(String contentUrl, String mimetype, long size, String encoding) {
        this(contentUrl, mimetype, size, encoding, null);
    }

    public ContentData(String contentUrl, String mimetype, long size, String encoding, Locale locale) {
        if (contentUrl != null && (mimetype == null || mimetype.length() == 0)) {
            mimetype = "application/octet-stream";
        }
        this.checkContentUrl(contentUrl, mimetype, encoding);
        this.contentUrl = contentUrl;
        this.mimetype = mimetype;
        this.size = size;
        this.encoding = encoding;
        if (locale == null) {
            locale = I18NUtil.getLocale();
        }
        this.locale = locale;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentData)) {
            return false;
        }
        ContentData that = (ContentData)obj;
        return EqualsHelper.nullSafeEquals((Object)this.contentUrl, (Object)that.contentUrl) && EqualsHelper.nullSafeEquals((String)this.mimetype, (String)that.mimetype, (boolean)true) && this.size == that.size && EqualsHelper.nullSafeEquals((String)this.encoding, (String)that.encoding, (boolean)true) && EqualsHelper.nullSafeEquals((Object)this.locale, (Object)that.locale);
    }

    public String toString() {
        return this.getInfoUrl();
    }

    public String getInfoUrl() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("contentUrl=").append(this.contentUrl == null ? "" : this.contentUrl).append("|mimetype=").append(this.mimetype == null ? "" : this.mimetype).append("|size=").append(this.size).append("|encoding=").append(this.encoding == null ? "" : this.encoding).append("|locale=").append(this.locale == null ? "" : DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.locale));
        return sb.toString();
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    private void checkContentUrl(String contentUrl, String mimetype, String encoding) {
        if (contentUrl != null && contentUrl.length() > 0) {
            for (int i = 0; i < INVALID_CONTENT_URL_CHARS.length; ++i) {
                for (int j = contentUrl.length() - 1; j > -1; --j) {
                    if (contentUrl.charAt(j) != INVALID_CONTENT_URL_CHARS[i]) continue;
                    throw new IllegalArgumentException("The content URL contains an invalid char: \n   content URL: " + contentUrl + "\n" + "   char: " + INVALID_CONTENT_URL_CHARS[i] + "\n" + "   position: " + j);
                }
            }
            if (mimetype == null) {
                throw new IllegalArgumentException("\nThe content mimetype must be set whenever the URL is set: \n   content URL: " + contentUrl + "\n" + "   mimetype: " + mimetype);
            }
        }
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public long getSize() {
        return this.size;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        if (this.contentUrl != null) {
            return this.contentUrl.hashCode();
        }
        return 0;
    }
}

