/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.security;

import java.util.Set;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionContext;
import org.alfresco.service.namespace.QName;

@AlfrescoPublicApi
public interface PermissionService {
    public static final String ROLE_PREFIX = "ROLE_";
    public static final String GROUP_PREFIX = "GROUP_";
    public static final String ALL_AUTHORITIES = "GROUP_EVERYONE";
    public static final String OWNER_AUTHORITY = "ROLE_OWNER";
    public static final String WCM_STORE_OWNER_AUTHORITY = "ROLE_WCM_STORE_OWNER";
    public static final String LOCK_OWNER_AUTHORITY = "ROLE_LOCK_OWNER";
    public static final String ADMINISTRATOR_AUTHORITY = "ROLE_ADMINISTRATOR";
    public static final String GUEST_AUTHORITY = "ROLE_GUEST";
    public static final String ALL_PERMISSIONS = "All";
    public static final String FULL_CONTROL = "FullControl";
    public static final String READ = "Read";
    public static final String WRITE = "Write";
    public static final String DELETE = "Delete";
    public static final String ADD_CHILDREN = "AddChildren";
    public static final String READ_PROPERTIES = "ReadProperties";
    public static final String READ_CHILDREN = "ReadChildren";
    public static final String WRITE_PROPERTIES = "WriteProperties";
    public static final String DELETE_NODE = "DeleteNode";
    public static final String DELETE_CHILDREN = "DeleteChildren";
    public static final String CREATE_CHILDREN = "CreateChildren";
    public static final String LINK_CHILDREN = "LinkChildren";
    public static final String DELETE_ASSOCIATIONS = "DeleteAssociations";
    public static final String READ_ASSOCIATIONS = "ReadAssociations";
    public static final String CREATE_ASSOCIATIONS = "CreateAssociations";
    public static final String READ_PERMISSIONS = "ReadPermissions";
    public static final String CHANGE_PERMISSIONS = "ChangePermissions";
    public static final String EXECUTE = "Execute";
    public static final String READ_CONTENT = "ReadContent";
    public static final String WRITE_CONTENT = "WriteContent";
    public static final String EXECUTE_CONTENT = "ExecuteContent";
    public static final String TAKE_OWNERSHIP = "TakeOwnership";
    public static final String SET_OWNER = "SetOwner";
    public static final String COORDINATOR = "Coordinator";
    public static final String CONTRIBUTOR = "Contributor";
    public static final String EDITOR = "Editor";
    public static final String CONSUMER = "Consumer";
    public static final String LOCK = "Lock";
    public static final String UNLOCK = "Unlock";
    public static final String CHECK_OUT = "CheckOut";
    public static final String CHECK_IN = "CheckIn";
    public static final String CANCEL_CHECK_OUT = "CancelCheckOut";
    public static final String ASPECTS = "Aspects";
    public static final String PROPERTIES = "Properties";
    public static final String WCM_CONTENT_MANAGER = "ContentManager";
    public static final String WCM_CONTENT_PUBLISHER = "ContentPublisher";
    public static final String WCM_CONTENT_CONTRIBUTOR = "ContentContributor";
    public static final String WCM_CONTENT_REVIEWER = "ContentReviewer";
    public static final String FLATTEN = "Flatten";

    @Auditable
    public String getOwnerAuthority();

    @Auditable
    public String getAllAuthorities();

    @Auditable
    public String getAllPermission();

    @Auditable(parameters={"nodeRef"})
    public Set<AccessPermission> getPermissions(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public Set<AccessPermission> getAllSetPermissions(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public Set<String> getSettablePermissions(NodeRef var1);

    @Auditable(parameters={"type"})
    public Set<String> getSettablePermissions(QName var1);

    @Auditable(parameters={"nodeRef", "permission"})
    public AccessStatus hasPermission(NodeRef var1, String var2);

    @Auditable(parameters={"nodeRef"})
    public AccessStatus hasReadPermission(NodeRef var1);

    @Auditable(parameters={"aclId"})
    public Set<String> getReaders(Long var1);

    @Auditable(parameters={"aclID", "context", "permission"})
    public AccessStatus hasPermission(Long var1, PermissionContext var2, String var3);

    @Auditable(parameters={"nodeRef"})
    public void deletePermissions(NodeRef var1);

    @Auditable(parameters={"nodeRef", "authority"})
    public void clearPermission(NodeRef var1, String var2);

    @Auditable(parameters={"nodeRef", "authority", "permission"})
    public void deletePermission(NodeRef var1, String var2, String var3);

    @Auditable(parameters={"nodeRef", "authority", "permission", "allow"})
    public void setPermission(NodeRef var1, String var2, String var3, boolean var4);

    @Auditable(parameters={"nodeRef", "inheritParentPermissions"})
    public void setInheritParentPermissions(NodeRef var1, boolean var2);

    @Auditable(parameters={"nodeRef"})
    public boolean getInheritParentPermissions(NodeRef var1);

    @Auditable(parameters={"storeRef", "authority", "permission", "allow"})
    public void setPermission(StoreRef var1, String var2, String var3, boolean var4);

    @Auditable(parameters={"storeRef", "authority", "permission"})
    public void deletePermission(StoreRef var1, String var2, String var3);

    @Auditable(parameters={"storeRef", "authority"})
    public void clearPermission(StoreRef var1, String var2);

    @Auditable(parameters={"storeRef"})
    public void deletePermissions(StoreRef var1);

    @Auditable(parameters={"storeRef"})
    public Set<AccessPermission> getAllSetPermissions(StoreRef var1);

    public Set<String> getAuthorisations();
}

