/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.cmis.CMISDictionaryModel;
import org.alfresco.cmis.CMISPropertyDefinition;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.CMISTypeId;
import org.alfresco.cmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.cmis.dictionary.CMISAbstractTypeDefinition;
import org.alfresco.cmis.mapping.CMISMapping;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;

public class CMISRelationshipTypeDefinition
extends CMISAbstractTypeDefinition {
    private static final long serialVersionUID = 5291428171784061346L;
    private List<CMISTypeId> allowedSourceTypeIds = new ArrayList<CMISTypeId>();
    private List<CMISTypeDefinition> allowedSourceTypes = new ArrayList<CMISTypeDefinition>();
    private List<CMISTypeDefinition> inheritedAllowedSourceTypes = new ArrayList<CMISTypeDefinition>();
    private List<CMISTypeId> allowedTargetTypeIds = new ArrayList<CMISTypeId>();
    private List<CMISTypeDefinition> allowedTargetTypes = new ArrayList<CMISTypeDefinition>();
    private List<CMISTypeDefinition> inheritedAllowedTargetTypes = new ArrayList<CMISTypeDefinition>();

    public CMISRelationshipTypeDefinition(CMISMapping cmisMapping, CMISTypeId typeId, DictionaryService dictionaryService, ClassDefinition cmisClassDef, AssociationDefinition assocDef) {
        this.isPublic = true;
        this.cmisClassDef = cmisClassDef;
        this.objectTypeId = typeId;
        this.actionEvaluators = cmisMapping.getActionEvaluators(this.objectTypeId.getScope());
        this.queryable = false;
        this.fullTextIndexed = false;
        this.includedInSuperTypeQuery = true;
        this.controllablePolicy = false;
        this.controllableACL = false;
        if (assocDef == null) {
            this.creatable = false;
            this.displayName = cmisClassDef.getTitle((MessageLookup)dictionaryService) != null ? cmisClassDef.getTitle((MessageLookup)dictionaryService) : typeId.getId();
            this.objectTypeQueryName = typeId.getId();
            QName parentQName = cmisMapping.getCmisType(cmisClassDef.getParentName());
            if (parentQName != null) {
                this.parentTypeId = cmisMapping.getCmisTypeId(CMISScope.OBJECT, parentQName);
            }
            this.description = cmisClassDef.getDescription((MessageLookup)dictionaryService) != null ? cmisClassDef.getDescription((MessageLookup)dictionaryService) : this.displayName;
        } else {
            CMISTypeId targetTypeId;
            this.creatable = true;
            this.displayName = assocDef.getTitle((MessageLookup)dictionaryService) != null ? assocDef.getTitle((MessageLookup)dictionaryService) : typeId.getId();
            this.objectTypeQueryName = ISO9075.encodeSQL((String)cmisMapping.buildPrefixEncodedString(typeId.getQName()));
            this.parentTypeId = CMISDictionaryModel.RELATIONSHIP_TYPE_ID;
            this.description = assocDef.getDescription((MessageLookup)dictionaryService) != null ? assocDef.getDescription((MessageLookup)dictionaryService) : this.displayName;
            CMISTypeId sourceTypeId = cmisMapping.getCmisTypeId(cmisMapping.getCmisType(assocDef.getSourceClass().getName()));
            if (sourceTypeId != null) {
                this.allowedSourceTypeIds.add(sourceTypeId);
            }
            if ((targetTypeId = cmisMapping.getCmisTypeId(cmisMapping.getCmisType(assocDef.getTargetClass().getName()))) != null) {
                this.allowedTargetTypeIds.add(targetTypeId);
            }
        }
    }

    @Override
    Map<String, CMISPropertyDefinition> createProperties(CMISMapping cmisMapping, DictionaryService dictionaryService) {
        if (this.objectTypeId.equals(CMISDictionaryModel.RELATIONSHIP_TYPE_ID)) {
            return super.createProperties(cmisMapping, dictionaryService);
        }
        this.properties = new HashMap();
        return this.properties;
    }

    @Override
    void createSubTypes(CMISMapping cmisMapping, DictionaryService dictionaryService) {
        this.subTypeIds = new ArrayList();
        if (this.objectTypeId.equals(CMISDictionaryModel.RELATIONSHIP_TYPE_ID)) {
            Collection assocs = dictionaryService.getAllAssociations();
            for (QName assoc : assocs) {
                if (!cmisMapping.isValidCmisRelationship(assoc)) continue;
                this.subTypeIds.add(cmisMapping.getCmisTypeId(CMISScope.RELATIONSHIP, assoc));
            }
        }
    }

    @Override
    void resolveDependencies(CMISAbstractDictionaryService.DictionaryRegistry registry) {
        CMISTypeDefinition type;
        super.resolveDependencies(registry);
        for (CMISTypeId sourceTypeId : this.allowedSourceTypeIds) {
            type = registry.objectDefsByTypeId.get(sourceTypeId);
            if (type == null) {
                throw new AlfrescoRuntimeException("Failed to retrieve allowed source type for type id " + sourceTypeId);
            }
            if (type.isPublic() != this.isPublic.booleanValue()) continue;
            this.allowedSourceTypes.add(type);
        }
        for (CMISTypeId targetTypeId : this.allowedTargetTypeIds) {
            type = registry.objectDefsByTypeId.get(targetTypeId);
            if (type == null) {
                throw new AlfrescoRuntimeException("Failed to retrieve allowed target type for type id " + targetTypeId);
            }
            if (type.isPublic() != this.isPublic.booleanValue()) continue;
            this.allowedTargetTypes.add(type);
        }
    }

    @Override
    void resolveInheritance(CMISAbstractDictionaryService.DictionaryRegistry registry) {
        super.resolveInheritance(registry);
        this.inheritedAllowedSourceTypes.addAll(this.allowedSourceTypes);
        this.inheritedAllowedTargetTypes.addAll(this.allowedTargetTypes);
        if (this.internalParentType != null) {
            this.inheritedAllowedSourceTypes.addAll(this.internalParentType.getAllowedSourceTypes());
            this.inheritedAllowedTargetTypes.addAll(this.internalParentType.getAllowedTargetTypes());
        }
    }

    @Override
    public Collection<CMISTypeDefinition> getAllowedSourceTypes() {
        return this.inheritedAllowedSourceTypes;
    }

    @Override
    public Collection<CMISTypeDefinition> getAllowedTargetTypes() {
        return this.inheritedAllowedTargetTypes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CMISRelationshipTypeDefinition[");
        builder.append("Id=").append(this.getTypeId().getId()).append(", ");
        builder.append("Namespace=").append(this.getTypeId().getLocalNamespace()).append(", ");
        builder.append("LocalName=").append(this.getTypeId().getLocalName()).append(", ");
        builder.append("QueryName=").append(this.getQueryName()).append(", ");
        builder.append("DisplayName=").append(this.getDisplayName()).append(", ");
        builder.append("ParentId=").append(this.getParentType() == null ? "<none>" : this.getParentType().getTypeId()).append(", ");
        builder.append("Description=").append(this.getDescription()).append(", ");
        builder.append("Creatable=").append(this.isCreatable()).append(", ");
        builder.append("Queryable=").append(this.isQueryable()).append(", ");
        builder.append("Controllable=").append(this.isControllablePolicy()).append(", ");
        builder.append("IncludedInSuperTypeQuery=").append(this.isIncludedInSuperTypeQuery()).append(", ");
        builder.append("AllowedSourceTypes=[");
        for (CMISTypeDefinition type : this.getAllowedSourceTypes()) {
            builder.append(type.getTypeId()).append(",");
        }
        builder.append("], ");
        builder.append("AllowedTargetTypes=[");
        for (CMISTypeDefinition type : this.getAllowedTargetTypes()) {
            builder.append(type.getTypeId()).append(",");
        }
        builder.append("], ");
        builder.append("SubTypes=").append(this.getSubTypes(false).size()).append(", ");
        builder.append("Properties=").append(this.getPropertyDefinitions().size());
        builder.append("]");
        return builder.toString();
    }
}

