/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import org.alfresco.cmis.CMISAllowedActionEnum;
import org.alfresco.cmis.mapping.AbstractActionEvaluator;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public class ObjectLockedActionEvaluator<ObjectType>
extends AbstractActionEvaluator<ObjectType> {
    private NodeService nodeService;
    private LockService lockService;
    private LockType lockType;
    private boolean lockExpected;

    protected ObjectLockedActionEvaluator(LockType lockType, boolean lockExpected, ServiceRegistry serviceRegistry, CMISAllowedActionEnum action) {
        super(serviceRegistry, action);
        this.lockType = lockType;
        this.lockExpected = lockExpected;
        this.nodeService = serviceRegistry.getNodeService();
        this.lockService = serviceRegistry.getLockService();
    }

    @Override
    public boolean isAllowed(ObjectType object) {
        NodeRef nodeRef;
        NodeRef nodeRef2 = nodeRef = object instanceof NodeRef ? (NodeRef)object : null;
        if (null != this.lockType && this.nodeService.exists(nodeRef)) {
            boolean locked = this.lockType == this.lockService.getLockType(nodeRef);
            return this.lockExpected && locked || !this.lockExpected && !locked;
        }
        return false;
    }
}

