/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.util.List;
import org.alfresco.cmis.CMISAllowedActionEnum;
import org.alfresco.cmis.CMISServices;
import org.alfresco.cmis.mapping.AbstractActionEvaluator;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public class ParentTypeActionEvaluator<ObjectType>
extends AbstractActionEvaluator<ObjectType> {
    private CMISServices cmisServices;
    private NodeService nodeService;
    private ParentTypeEnum parentType;
    private boolean expected;

    protected ParentTypeActionEvaluator(ServiceRegistry serviceRegistry, CMISAllowedActionEnum action, ParentTypeEnum parentType, boolean expected) {
        super(serviceRegistry, action);
        this.parentType = parentType;
        this.expected = expected;
        this.cmisServices = serviceRegistry.getCMISService();
        this.nodeService = serviceRegistry.getNodeService();
    }

    @Override
    public boolean isAllowed(ObjectType object) {
        NodeRef nodeRef = object instanceof NodeRef ? (NodeRef)object : null;
        NodeRef rootNodeRef = this.cmisServices.getDefaultRootNodeRef();
        if (null == nodeRef || rootNodeRef.equals((Object)nodeRef)) {
            return false;
        }
        List parentAssocs = this.nodeService.getParentAssocs(nodeRef);
        if (ParentTypeEnum.REPOSITORY_ROOT == this.parentType || ParentTypeEnum.PRIMARY_REPOSITORY_ROOT == this.parentType) {
            Object root = null;
            for (ChildAssociationRef ref : parentAssocs) {
                root = rootNodeRef.equals((Object)ref.getParentRef()) ? ref : null;
                if (null == root) continue;
                if (ParentTypeEnum.PRIMARY_REPOSITORY_ROOT != this.parentType || ref.isPrimary()) break;
                root = null;
                break;
            }
            return this.expected ? null != root : null == root;
        }
        return this.expected ? parentAssocs.size() > 1 : 1 == parentAssocs.size();
    }

    public static enum ParentTypeEnum {
        MULTI_FILED,
        REPOSITORY_ROOT,
        PRIMARY_REPOSITORY_ROOT;

    }
}

