/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.alfresco;

import org.alfresco.filesys.alfresco.AlfrescoContext;
import org.alfresco.filesys.alfresco.ExtendedDiskInterface;
import org.alfresco.filesys.alfresco.IOControlHandler;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.IOControlNotImplementedException;
import org.alfresco.jlan.server.filesys.IOCtlInterface;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.util.DataBuffer;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AlfrescoDiskDriver
implements IOCtlInterface,
ExtendedDiskInterface {
    private static final Log logger = LogFactory.getLog(AlfrescoDiskDriver.class);
    private ServiceRegistry m_serviceRegistry;
    protected TransactionService m_transactionService;
    protected IOControlHandler ioControlHandler;

    public void setIoControlHandler(IOControlHandler ioControlHandler) {
        this.ioControlHandler = ioControlHandler;
    }

    public IOControlHandler getIoControlHandler() {
        return this.ioControlHandler;
    }

    public final ServiceRegistry getServiceRegistry() {
        return this.m_serviceRegistry;
    }

    public final TransactionService getTransactionService() {
        return this.m_transactionService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.m_serviceRegistry = serviceRegistry;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.m_transactionService = transactionService;
    }

    public DataBuffer processIOControl(SrvSession sess, TreeConnection tree, int ctrlCode, int fid, DataBuffer dataBuf, boolean isFSCtrl, int filter) throws IOControlNotImplementedException, SMBException {
        NetworkFile netFile = tree.findFile(fid);
        if (netFile == null || !netFile.isDirectory()) {
            throw new SMBException(6, -1073741811);
        }
        if (tree.getContext() instanceof ContentContext) {
            ContentContext ctx = (ContentContext)tree.getContext();
            if (this.ioControlHandler != null) {
                return this.ioControlHandler.processIOControl(sess, tree, ctrlCode, fid, dataBuf, isFSCtrl, filter, this, ctx);
            }
            throw new IOControlNotImplementedException();
        }
        return null;
    }

    @Override
    public void registerContext(DeviceContext ctx) throws DeviceContextException {
        if (ctx instanceof AlfrescoContext) {
            AlfrescoContext alfCtx = (AlfrescoContext)ctx;
            alfCtx.initialize(this);
        }
    }
}

