/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.auth.cifs;

import org.alfresco.filesys.AlfrescoConfigSection;
import org.alfresco.filesys.alfresco.AlfrescoClientInfo;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.CifsAuthenticator;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.smb.server.SMBSrvException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MD4PasswordEncoder;
import org.alfresco.repo.security.authentication.MD4PasswordEncoderImpl;
import org.alfresco.repo.security.authentication.ntlm.NLTMAuthenticator;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.config.ConfigElement;

public abstract class CifsAuthenticatorBase
extends CifsAuthenticator
implements ActivateableBean,
InitializingBean,
DisposableBean {
    protected static final Log logger = LogFactory.getLog(CifsAuthenticatorBase.class);
    protected MD4PasswordEncoder m_md4Encoder = new MD4PasswordEncoderImpl();
    private AuthenticationComponent authenticationComponent;
    private AuthenticationService authenticationService;
    private NodeService nodeService;
    private PersonService personService;
    private TransactionService transactionService;
    private AuthorityService authorityService;
    private DiskInterface diskInterface;
    private boolean active = true;

    public CifsAuthenticatorBase() {
        this.setAccessMode(1);
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setDiskInterface(DiskInterface diskInterface) {
        this.diskInterface = diskInterface;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        AlfrescoConfigSection alfrescoConfig = (AlfrescoConfigSection)config.getConfigSection("Alfresco");
        this.setAuthenticationComponent(alfrescoConfig.getAuthenticationComponent());
        this.setAuthenticationService(alfrescoConfig.getAuthenticationService());
        this.setNodeService(alfrescoConfig.getNodeService());
        this.setPersonService(alfrescoConfig.getPersonService());
        this.setTransactionService(alfrescoConfig.getTransactionService());
        this.setAuthorityService(alfrescoConfig.getAuthorityService());
        this.setDiskInterface(alfrescoConfig.getRepoDiskInterface());
        super.initialize(config, params);
    }

    public void initialize() throws InvalidConfigurationException {
        super.initialize();
        if (this.getAuthenticationComponent() == null) {
            throw new InvalidConfigurationException("Authentication component not available");
        }
        this.setAllowGuest(this.allowGuest() || this.getAuthenticationComponent().guestUserAuthenticationAllowed());
        this.setGuestUserName(this.getAuthenticationComponent().getGuestUserName());
        if (!this.validateAuthenticationMode()) {
            throw new InvalidConfigurationException("Required authentication mode not available");
        }
    }

    public final void afterPropertiesSet() throws InvalidConfigurationException {
        if (this.active) {
            this.initialize();
        }
    }

    protected boolean validateAuthenticationMode() {
        return true;
    }

    protected void doGuestLogon(ClientInfo client, SrvSession sess) {
        if (!(client instanceof AlfrescoClientInfo)) {
            return;
        }
        AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
        this.getAuthenticationService().authenticateAsGuest();
        String ticket = this.getAuthenticationService().getCurrentTicket();
        alfClient.setAuthenticationTicket(ticket);
        client.setUserName(this.getGuestUserName());
        this.getHomeFolderForUser(client);
        client.setGuest(true);
        ContentContext diskCtx = new ContentContext(client.getUserName(), "", "", alfClient.getHomeFolder());
        diskCtx.setDiskInformation(new SrvDiskInfo(2560, 64, 512, 2304));
        sess.addDynamicShare((SharedDevice)new DiskSharedDevice(client.getUserName(), (DeviceInterface)this.diskInterface, (DiskDeviceContext)diskCtx, 8));
    }

    protected final void getHomeFolderForUser(final ClientInfo client) {
        if (!(client instanceof AlfrescoClientInfo) || client.isNullSession()) {
            return;
        }
        final AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
        this.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws SMBSrvException {
                NodeRef homeSpaceRef = (NodeRef)CifsAuthenticatorBase.this.getNodeService().getProperty(CifsAuthenticatorBase.this.getPersonService().getPerson(client.getUserName()), ContentModel.PROP_HOMEFOLDER);
                alfClient.setHomeFolder(homeSpaceRef);
                return null;
            }
        });
    }

    public final String mapUserNameToPerson(final String userName, final boolean checkEnabled) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("mapUserNameToPerson userName:" + userName + ", checkEnabled:" + checkEnabled));
        }
        return (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return CifsAuthenticatorBase.this.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                    @Override
                    public String execute() throws Throwable {
                        String personName = CifsAuthenticatorBase.this.getPersonService().getUserIdentifier(userName);
                        if (personName == null) {
                            CifsAuthenticatorBase.this.getPersonService().getPerson(userName);
                            personName = CifsAuthenticatorBase.this.getPersonService().getUserIdentifier(userName);
                        }
                        if (checkEnabled && personName != null) {
                            boolean isAuthenticationEnabled = CifsAuthenticatorBase.this.getAuthenticationService().getAuthenticationEnabled(personName);
                            if (!isAuthenticationEnabled) {
                                logger.debug((Object)"autentication service says user is not enabled");
                                throw new AuthenticationException("Authentication not enabled for:" + userName);
                            }
                            boolean isEnabled = CifsAuthenticatorBase.this.personService.isEnabled(personName);
                            if (!isEnabled) {
                                logger.debug((Object)"person service says user is not enabled");
                                throw new AuthenticationException("Authentication not enabled for person:" + userName);
                            }
                        }
                        return personName == null ? userName : personName;
                    }
                });
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public void setCurrentUser(final ClientInfo client) {
        if (client == null || client.isNullSession()) {
            this.getAuthenticationComponent().clearCurrentSecurityContext();
            return;
        }
        this.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                if (!client.isGuest() && client instanceof AlfrescoClientInfo) {
                    AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
                    if (alfClient.hasAuthenticationTicket()) {
                        boolean ticketFailed;
                        block10: {
                            ticketFailed = false;
                            try {
                                CifsAuthenticatorBase.this.getAuthenticationService().validate(alfClient.getAuthenticationTicket());
                            }
                            catch (AuthenticationException e) {
                                ticketFailed = true;
                                if (!logger.isDebugEnabled()) break block10;
                                logger.debug((Object)("Failed to validate ticket, user=" + client.getUserName() + ", ticket=" + alfClient.getAuthenticationTicket()));
                            }
                        }
                        if (ticketFailed) {
                            try {
                                String normalized = CifsAuthenticatorBase.this.mapUserNameToPerson(client.getUserName(), false);
                                CifsAuthenticatorBase.this.getAuthenticationComponent().setCurrentUser(normalized);
                                alfClient.setAuthenticationTicket(CifsAuthenticatorBase.this.getAuthenticationService().getCurrentTicket());
                            }
                            catch (AuthenticationException ex) {
                                if (logger.isErrorEnabled()) {
                                    logger.error((Object)("Failed to get new ticket for user=" + client.getUserName()));
                                    logger.error((Object)ex);
                                }
                                alfClient.setAuthenticationTicket(null);
                                CifsAuthenticatorBase.this.getAuthenticationComponent().clearCurrentSecurityContext();
                            }
                        }
                    } else {
                        CifsAuthenticatorBase.this.getAuthenticationComponent().clearCurrentSecurityContext();
                    }
                } else {
                    CifsAuthenticatorBase.this.getAuthenticationComponent().setGuestUserAsCurrentUser();
                }
                return null;
            }
        });
    }

    protected final AuthenticationComponent getAuthenticationComponent() {
        return this.authenticationComponent;
    }

    protected final NLTMAuthenticator getNTLMAuthenticator() {
        if (!(this.authenticationComponent instanceof NLTMAuthenticator)) {
            throw new IllegalStateException("Attempt to use non SSO-enabled authentication component for SSO");
        }
        return (NLTMAuthenticator)this.authenticationComponent;
    }

    protected final AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    protected final NodeService getNodeService() {
        return this.nodeService;
    }

    protected final PersonService getPersonService() {
        return this.personService;
    }

    private final TransactionService getTransactionService() {
        return this.transactionService;
    }

    protected final AuthorityService getAuthorityService() {
        return this.authorityService;
    }

    protected final void checkForAdminUserName(final ClientInfo cInfo) {
        this.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() {
                if (cInfo.getLogonType() == 0 && CifsAuthenticatorBase.this.getAuthorityService().isAdminAuthority(cInfo.getUserName())) {
                    cInfo.setLogonType(3);
                }
                return null;
            }
        });
    }

    protected <T> T doInTransaction(RetryingTransactionHelper.RetryingTransactionCallback<T> callback) {
        TransactionService txService = this.getTransactionService();
        if (txService.isReadOnly() || !txService.getAllowWrite()) {
            return txService.getRetryingTransactionHelper().doInTransaction(callback, true, false);
        }
        return txService.getRetryingTransactionHelper().doInTransaction(callback, false, false);
    }

    public void destroy() throws Exception {
        this.closeAuthenticator();
    }
}

