/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.InputStream;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;

public class AlfrescoCmisStreamInterceptor
implements MethodInterceptor {
    private MimetypeService mimetypeService;

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        Class<?>[] parameterTypes = mi.getMethod().getParameterTypes();
        Object[] arguments = mi.getArguments();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ContentStreamImpl contentStream;
            if (!parameterTypes[i].isAssignableFrom(ContentStreamImpl.class) || (contentStream = (ContentStreamImpl)arguments[i]) == null || contentStream.getMimeType() != null) continue;
            InputStream stream = contentStream.getStream();
            String mimeType = this.mimetypeService.guessMimetype(contentStream.getFileName(), stream);
            contentStream.setMimeType(mimeType);
        }
        return mi.proceed();
    }
}

