/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.util.List;
import org.alfresco.opencmis.ObjectFilter;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;

public class PathObjectFilter
implements ObjectFilter {
    private String rootPath;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private List<String> excludedPaths;

    public void setExcludedPaths(List<String> excludedPaths) {
        this.excludedPaths = excludedPaths;
    }

    public void setRootPath(String path) {
        this.rootPath = path;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    @Override
    public boolean filter(NodeRef nodeRef) {
        try {
            Path path = this.nodeService.getPath(nodeRef);
            String s = path.toPrefixString((NamespacePrefixResolver)this.namespaceService);
            return this.filter(s);
        }
        catch (AccessDeniedException e) {
            return true;
        }
    }

    public boolean filter(String path) {
        if (path.startsWith(this.rootPath)) {
            path = path.substring(this.rootPath.length());
        }
        return this.excludedPaths.contains(path);
    }
}

