/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.dictionary.CMISPropertyAccessor;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

public abstract class AbstractProperty
implements CMISPropertyAccessor {
    private static final String CONTENT_PROPERTY = "::content";
    private ServiceRegistry serviceRegistry;
    protected CMISConnector connector;
    private String propertyName;

    protected AbstractProperty(ServiceRegistry serviceRegistry, CMISConnector connector, String propertyName) {
        this.serviceRegistry = serviceRegistry;
        this.connector = connector;
        this.propertyName = propertyName;
    }

    protected String getGuid(String nodeId) {
        int idx = nodeId.lastIndexOf("/");
        if (idx != -1) {
            return nodeId.substring(idx + 1);
        }
        return nodeId;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public String getName() {
        return this.propertyName;
    }

    public QName getMappedProperty() {
        return null;
    }

    public void setValue(NodeRef nodeRef, Serializable value) {
        throw new UnsupportedOperationException();
    }

    public Serializable getValue(NodeRef nodeRef) {
        return this.getValue(this.createNodeInfo(nodeRef));
    }

    public Serializable getValue(AssociationRef assocRef) {
        return this.getValue(this.createNodeInfo(assocRef));
    }

    public Serializable getValue(CMISNodeInfo nodeInfo) {
        if (nodeInfo.containsPropertyValue(this.propertyName)) {
            Serializable value = nodeInfo.getPropertyValue(this.propertyName);
            return value;
        }
        Serializable value = this.getValueInternal(nodeInfo);
        nodeInfo.putPropertyValue(this.propertyName, value);
        return value;
    }

    protected abstract Serializable getValueInternal(CMISNodeInfo var1);

    public CMISNodeInfo createNodeInfo(NodeRef nodeRef) {
        return this.connector.createNodeInfo(nodeRef);
    }

    public CMISNodeInfo createNodeInfo(AssociationRef assocRef) {
        return this.connector.createNodeInfo(assocRef);
    }

    protected ContentData getContentData(CMISNodeInfo nodeInfo) {
        if (!nodeInfo.isDocument()) {
            return null;
        }
        if (nodeInfo.containsPropertyValue(CONTENT_PROPERTY)) {
            return (ContentData)nodeInfo.getPropertyValue(CONTENT_PROPERTY);
        }
        ContentData contentData = null;
        Serializable value = this.getServiceRegistry().getNodeService().getProperty(nodeInfo.getNodeRef(), ContentModel.PROP_CONTENT);
        if (value != null) {
            contentData = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)value);
        }
        nodeInfo.putPropertyValue(CONTENT_PROPERTY, contentData);
        return contentData;
    }
}

