/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.action.ActionServiceMonitor;
import org.alfresco.repo.action.ActionTransactionListener;
import org.alfresco.repo.action.AsynchronousActionExecutionQueue;
import org.alfresco.repo.action.CompositeActionConditionImpl;
import org.alfresco.repo.action.CompositeActionImpl;
import org.alfresco.repo.action.RunningAction;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.action.evaluator.ActionConditionEvaluator;
import org.alfresco.repo.action.executer.ActionExecuter;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionConditionDefinition;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionList;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.action.ActionServiceTransientException;
import org.alfresco.service.cmr.action.ActionStatus;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.action.CompositeActionCondition;
import org.alfresco.service.cmr.action.ParameterConstraint;
import org.alfresco.service.cmr.action.ParameterizedItem;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ActionServiceImpl
implements ActionService,
RuntimeActionService,
ApplicationContextAware,
CopyServicePolicies.OnCopyNodePolicy,
CopyServicePolicies.OnCopyCompletePolicy {
    private static final String POST_TRANSACTION_PENDING_ACTIONS = "postTransactionPendingActions";
    private static final String ERR_FAIL = "The action failed to execute due to an error.";
    private static Log logger = LogFactory.getLog(ActionServiceImpl.class);
    ThreadLocal<Set<String>> currentActionChain = new ThreadLocal();
    private ApplicationContext applicationContext;
    private NodeService nodeService;
    private SearchService searchService;
    private DictionaryService dictionaryService;
    private AuthenticationContext authenticationContext;
    private ActionTrackingService actionTrackingService;
    private PolicyComponent policyComponent;
    private ActionServiceMonitor monitor;
    private Map<String, AsynchronousActionExecutionQueue> asynchronousActionExecutionQueues = new HashMap<String, AsynchronousActionExecutionQueue>();
    private ActionTransactionListener transactionListener = new ActionTransactionListener(this);
    private Map<String, ActionConditionDefinition> conditionDefinitions = new HashMap<String, ActionConditionDefinition>();
    private Map<String, ActionDefinition> actionDefinitions = new HashMap<String, ActionDefinition>();
    private Map<String, ParameterConstraint> parameterConstraints = new HashMap<String, ParameterConstraint>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setActionTrackingService(ActionTrackingService actionTrackingService) {
        this.actionTrackingService = actionTrackingService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setMonitor(ActionServiceMonitor monitor) {
        this.monitor = monitor;
    }

    public void setAsynchronousActionExecutionQueues(Map<String, AsynchronousActionExecutionQueue> asynchronousActionExecutionQueues) {
        this.asynchronousActionExecutionQueues = asynchronousActionExecutionQueues;
    }

    public void registerAsynchronousActionExecutionQueue(String key, AsynchronousActionExecutionQueue asyncExecQueue) {
        this.asynchronousActionExecutionQueues.put(key, asyncExecQueue);
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), ActionModel.TYPE_ACTION_PARAMETER, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCopyComplete"), ActionModel.TYPE_ACTION_PARAMETER, (Behaviour)new JavaBehaviour(this, "onCopyComplete"));
    }

    private NodeRef getSavedActionFolderRef(NodeRef nodeRef) {
        List assocs = this.nodeService.getChildAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)ActionModel.ASSOC_ACTION_FOLDER);
        if (assocs.size() != 1) {
            throw new ActionServiceException("Unable to retrieve the saved action folder reference.");
        }
        return ((ChildAssociationRef)assocs.get(0)).getChildRef();
    }

    @Override
    public ActionDefinition getActionDefinition(String name) {
        ActionDefinition definition = null;
        Object bean = this.applicationContext.getBean(name);
        if (bean != null && bean instanceof ActionExecuter) {
            ActionExecuter executer = (ActionExecuter)bean;
            definition = executer.getActionDefinition();
        }
        return definition;
    }

    @Override
    public List<ActionDefinition> getActionDefinitions() {
        return new ArrayList<ActionDefinition>(this.actionDefinitions.values());
    }

    @Override
    public List<ActionDefinition> getActionDefinitions(NodeRef nodeRef) {
        if (nodeRef == null) {
            return this.getActionDefinitions();
        }
        QName nodeType = this.nodeService.getType(nodeRef);
        ArrayList<ActionDefinition> result = new ArrayList<ActionDefinition>();
        block0: for (ActionDefinition actionDefinition : this.getActionDefinitions()) {
            Set<QName> applicableTypes = actionDefinition.getApplicableTypes();
            if (applicableTypes != null && !applicableTypes.isEmpty()) {
                if (applicableTypes.contains(nodeType)) {
                    result.add(actionDefinition);
                    continue;
                }
                for (QName applicableType : actionDefinition.getApplicableTypes()) {
                    if (!this.dictionaryService.isSubClass(nodeType, applicableType)) continue;
                    result.add(actionDefinition);
                    continue block0;
                }
                continue;
            }
            result.add(actionDefinition);
        }
        return result;
    }

    @Override
    public ActionConditionDefinition getActionConditionDefinition(String name) {
        return this.conditionDefinitions.get(name);
    }

    @Override
    public List<ActionConditionDefinition> getActionConditionDefinitions() {
        return new ArrayList<ActionConditionDefinition>(this.conditionDefinitions.values());
    }

    @Override
    public ParameterConstraint getParameterConstraint(String name) {
        return this.parameterConstraints.get(name);
    }

    @Override
    public List<ParameterConstraint> getParameterConstraints() {
        return new ArrayList<ParameterConstraint>(this.parameterConstraints.values());
    }

    @Override
    public ActionCondition createActionCondition(String name) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating Action Condition - [" + name + "]"));
        }
        if ("composite-condition".equals(name)) {
            return new CompositeActionConditionImpl(GUID.generate());
        }
        return new ActionConditionImpl(GUID.generate(), name);
    }

    @Override
    public ActionCondition createActionCondition(String name, Map<String, Serializable> params) {
        ActionCondition condition = this.createActionCondition(name);
        condition.setParameterValues(params);
        return condition;
    }

    @Override
    public Action createAction(String name) {
        return new ActionImpl(null, GUID.generate(), name, null);
    }

    @Override
    public Action createAction(String name, Map<String, Serializable> params) {
        Action action = this.createAction(name);
        action.setParameterValues(params);
        return action;
    }

    @Override
    public CompositeAction createCompositeAction() {
        return new CompositeActionImpl(null, GUID.generate());
    }

    @Override
    public CompositeActionCondition createCompositeActionCondition() {
        return new CompositeActionConditionImpl(GUID.generate());
    }

    @Override
    public boolean evaluateAction(Action action, NodeRef actionedUponNodeRef) {
        boolean result = true;
        if (action.hasActionConditions()) {
            List<ActionCondition> actionConditions = action.getActionConditions();
            for (ActionCondition condition : actionConditions) {
                boolean tempresult = this.evaluateActionCondition(condition, actionedUponNodeRef);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\tCondition " + condition.getActionConditionDefinitionName() + " Result - " + tempresult));
                }
                result = result && tempresult;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\tAll Condition Evaluation Result - " + result));
        }
        return result;
    }

    @Override
    public boolean evaluateActionCondition(ActionCondition condition, NodeRef actionedUponNodeRef) {
        if (condition instanceof CompositeActionCondition) {
            CompositeActionCondition compositeCondition = (CompositeActionCondition)condition;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Evaluating Composite Condition - BOOLEAN CONDITION IS " + (compositeCondition.isORCondition() ? "OR" : "AND")));
            }
            if (!compositeCondition.hasActionConditions()) {
                throw new IllegalStateException("CompositeActionCondition has no subconditions.");
            }
            boolean result = !compositeCondition.isORCondition();
            for (ActionCondition simplecondition : compositeCondition.getActionConditions()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Evaluating composite condition " + simplecondition.getActionConditionDefinitionName()));
                }
                if (!(compositeCondition.isORCondition() ? (result = result || this.evaluateSimpleCondition(simplecondition, actionedUponNodeRef)) : !(result = result && this.evaluateSimpleCondition(simplecondition, actionedUponNodeRef)))) continue;
                break;
            }
            if (compositeCondition.getInvertCondition()) {
                return !result;
            }
            return result;
        }
        return this.evaluateSimpleCondition(condition, actionedUponNodeRef);
    }

    private boolean evaluateSimpleCondition(ActionCondition condition, NodeRef actionedUponNodeRef) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Evaluating simple condition " + condition.getActionConditionDefinitionName()));
        }
        ActionConditionEvaluator evaluator = (ActionConditionEvaluator)this.applicationContext.getBean(condition.getActionConditionDefinitionName());
        return evaluator.evaluate(condition, actionedUponNodeRef);
    }

    @Override
    public void executeAction(Action action, NodeRef actionedUponNodeRef, boolean checkConditions) {
        this.executeAction(action, actionedUponNodeRef, checkConditions, action.getExecuteAsychronously());
    }

    @Override
    public void executeAction(Action action, NodeRef actionedUponNodeRef, boolean checkConditions, boolean executeAsychronously) {
        Set<String> actionChain = this.currentActionChain.get();
        if (!executeAsychronously) {
            this.executeActionImpl(action, actionedUponNodeRef, checkConditions, false, actionChain);
        } else {
            this.addPostTransactionPendingAction(action, actionedUponNodeRef, checkConditions, actionChain);
        }
    }

    @Override
    public void postCommit() {
        for (PendingAction pendingAction : this.getPostTransactionPendingActions()) {
            this.queueAction(pendingAction);
        }
    }

    private void queueAction(PendingAction action) {
        AsynchronousActionExecutionQueue queue = this.getQueue(action.action);
        queue.executeAction(this, action.getAction(), action.getActionedUponNodeRef(), action.getCheckConditions(), action.getActionChain());
    }

    private void queueAction(Action compensatingAction, NodeRef actionedUponNodeRef) {
        AsynchronousActionExecutionQueue queue = this.getQueue(compensatingAction);
        queue.executeAction(this, compensatingAction, actionedUponNodeRef, false, null);
    }

    private AsynchronousActionExecutionQueue getQueue(Action action) {
        ActionExecuter executer = (ActionExecuter)this.applicationContext.getBean(action.getActionDefinitionName());
        AsynchronousActionExecutionQueue queue = null;
        String queueName = executer.getQueueName();
        queue = queueName == null ? this.asynchronousActionExecutionQueues.get("") : this.asynchronousActionExecutionQueues.get(queueName);
        if (queue == null) {
            throw new ActionServiceException("Unable to get AsynchronousActionExecutionQueue name: " + queueName);
        }
        return queue;
    }

    private boolean getTrackStatus(Action action) {
        Boolean trackStatusManual = action.getTrackStatus();
        if (trackStatusManual != null) {
            return trackStatusManual;
        }
        ActionDefinition actionDef = this.getActionDefinition(action.getActionDefinitionName());
        if (actionDef == null) {
            return false;
        }
        return actionDef.getTrackStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeActionImpl(Action action, NodeRef actionedUponNodeRef, boolean checkConditions, boolean executedAsynchronously, Set<String> actionChain) {
        block29: {
            if (logger.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder("Execute action impl action chain = ");
                if (actionChain == null) {
                    builder.append("null");
                } else {
                    for (String value : actionChain) {
                        builder.append(value).append(" ");
                    }
                }
                logger.debug((Object)builder.toString());
                logger.debug((Object)("Current action = " + action.getId()));
            }
            String currentUserName = this.authenticationContext.getCurrentUserName();
            if (actionChain == null || !actionChain.contains(action.getId())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Doing executeActionImpl");
                }
                try {
                    HashSet<String> origActionChain = null;
                    if (actionChain == null) {
                        actionChain = new HashSet<String>();
                    } else {
                        origActionChain = new HashSet<String>(actionChain);
                    }
                    actionChain.add(action.getId());
                    this.currentActionChain.set(actionChain);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adding " + action.getActionDefinitionName() + ", " + action.getId() + " to action chain."));
                    }
                    try {
                        if (checkConditions && !this.evaluateAction(action, actionedUponNodeRef)) break block29;
                        if (this.getTrackStatus(action)) {
                            this.actionTrackingService.recordActionExecuting(action, actionedUponNodeRef);
                        }
                        RunningAction runningAction = this.monitor.actionStarted(action);
                        try {
                            this.directActionExecution(action, actionedUponNodeRef);
                        }
                        catch (Throwable e) {
                            runningAction.setException(e);
                            throw e;
                        }
                        finally {
                            this.monitor.actionCompleted(runningAction);
                        }
                        if (this.getTrackStatus(action)) {
                            this.actionTrackingService.recordActionComplete(action);
                        }
                    }
                    finally {
                        if (origActionChain == null) {
                            this.currentActionChain.remove();
                        } else {
                            this.currentActionChain.set(origActionChain);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Resetting the action chain.");
                        }
                    }
                }
                catch (ActionServiceTransientException transientException) {
                    if (this.getTrackStatus(action)) {
                        this.actionTrackingService.recordActionFailure(action, (Throwable)((Object)transientException));
                    }
                }
                catch (Throwable exception) {
                    Action compensatingAction;
                    if (executedAsynchronously && (compensatingAction = action.getCompensatingAction()) != null) {
                        ((ActionImpl)compensatingAction).setRunAsUser(currentUserName);
                        ((ActionImpl)compensatingAction).setTenantId(((ActionImpl)action).getTenantId());
                        this.queueAction(compensatingAction, actionedUponNodeRef);
                    }
                    if (this.getTrackStatus(action)) {
                        this.actionTrackingService.recordActionFailure(action, exception);
                    }
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new ActionServiceException(ERR_FAIL, exception);
                }
            }
        }
    }

    @Override
    public void directActionExecution(Action action, NodeRef actionedUponNodeRef) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The action is being executed as the user: " + this.authenticationContext.getCurrentUserName()));
        }
        ActionExecuter executer = (ActionExecuter)this.applicationContext.getBean(action.getActionDefinitionName());
        executer.execute(action, actionedUponNodeRef);
    }

    @Override
    public void executeAction(Action action, NodeRef actionedUponNodeRef) {
        this.executeAction(action, actionedUponNodeRef, true);
    }

    @Override
    public void registerActionConditionEvaluator(ActionConditionEvaluator actionConditionEvaluator) {
        ActionConditionDefinition cond = actionConditionEvaluator.getActionConditionDefintion();
        this.conditionDefinitions.put(cond.getName(), cond);
    }

    @Override
    public void registerActionExecuter(ActionExecuter actionExecuter) {
        ActionDefinition action = actionExecuter.getActionDefinition();
        this.actionDefinitions.put(action.getName(), action);
    }

    @Override
    public void registerParameterConstraint(ParameterConstraint parameterConstraint) {
        this.parameterConstraints.put(parameterConstraint.getName(), parameterConstraint);
    }

    private NodeRef getActionNodeRefFromId(NodeRef nodeRef, String actionId) {
        NodeRef result = null;
        if (this.nodeService.hasAspect(nodeRef, ActionModel.ASPECT_ACTIONS)) {
            DynamicNamespacePrefixResolver namespacePrefixResolver = new DynamicNamespacePrefixResolver();
            namespacePrefixResolver.registerNamespace("sys", "http://www.alfresco.org/model/system/1.0");
            List nodeRefs = this.searchService.selectNodes(this.getSavedActionFolderRef(nodeRef), "*[@sys:" + ContentModel.PROP_NODE_UUID.getLocalName() + "='" + actionId + "']", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
            if (nodeRefs.size() != 0) {
                result = (NodeRef)nodeRefs.get(0);
            }
        }
        return result;
    }

    @Override
    public void saveAction(NodeRef nodeRef, Action action) {
        NodeRef actionNodeRef = this.getActionNodeRefFromId(nodeRef, action.getId());
        if (actionNodeRef == null) {
            if (!this.nodeService.hasAspect(nodeRef, ActionModel.ASPECT_ACTIONS)) {
                this.nodeService.addAspect(nodeRef, ActionModel.ASPECT_ACTIONS, null);
            }
            actionNodeRef = this.createActionNodeRef(action, this.getSavedActionFolderRef(nodeRef), ContentModel.ASSOC_CONTAINS, ActionModel.ASSOC_NAME_ACTIONS);
        }
        this.saveActionImpl(actionNodeRef, action);
    }

    @Override
    public NodeRef createActionNodeRef(Action action, NodeRef parentNodeRef, QName assocTypeName, QName assocName) {
        HashMap<QName, String> props = new HashMap<QName, String>(2);
        props.put(ActionModel.PROP_DEFINITION_NAME, action.getActionDefinitionName());
        props.put(ContentModel.PROP_NODE_UUID, action.getId());
        QName actionType = ActionModel.TYPE_ACTION;
        if (action instanceof ActionList) {
            actionType = ActionModel.TYPE_COMPOSITE_ACTION;
        }
        NodeRef actionNodeRef = this.nodeService.createNode(parentNodeRef, assocTypeName, assocName, actionType, props).getChildRef();
        ((ActionImpl)action).setCreator((String)((Object)this.nodeService.getProperty(actionNodeRef, ContentModel.PROP_CREATOR)));
        ((ActionImpl)action).setCreatedDate((Date)this.nodeService.getProperty(actionNodeRef, ContentModel.PROP_CREATED));
        ((ActionImpl)action).setNodeRef(actionNodeRef);
        return actionNodeRef;
    }

    @Override
    public void saveActionImpl(NodeRef actionNodeRef, Action action) {
        this.saveActionProperties(actionNodeRef, action);
        this.saveParameters(actionNodeRef, action);
        this.saveConditions(actionNodeRef, action);
        if (action instanceof ActionList) {
            this.saveCompositeActions(actionNodeRef, (ActionList)((Object)action));
        }
        ((ActionImpl)action).setModifier((String)((Object)this.nodeService.getProperty(actionNodeRef, ContentModel.PROP_MODIFIER)));
        ((ActionImpl)action).setModifiedDate((Date)this.nodeService.getProperty(actionNodeRef, ContentModel.PROP_MODIFIED));
    }

    private void saveActionProperties(NodeRef actionNodeRef, Action action) {
        Map props = this.nodeService.getProperties(actionNodeRef);
        props.put(ActionModel.PROP_ACTION_TITLE, action.getTitle());
        props.put(ActionModel.PROP_ACTION_DESCRIPTION, action.getDescription());
        if (action.getTrackStatus() != null) {
            props.put(ActionModel.PROP_TRACK_STATUS, action.getTrackStatus());
        }
        props.put(ActionModel.PROP_EXECUTE_ASYNCHRONOUSLY, action.getExecuteAsychronously());
        props.put(ActionModel.PROP_EXECUTION_START_DATE, action.getExecutionStartDate());
        props.put(ActionModel.PROP_EXECUTION_END_DATE, action.getExecutionEndDate());
        props.put(ActionModel.PROP_EXECUTION_ACTION_STATUS, action.getExecutionStatus());
        props.put(ActionModel.PROP_EXECUTION_FAILURE_MESSAGE, action.getExecutionFailureMessage());
        this.nodeService.setProperties(actionNodeRef, props);
        Action compensatingAction = action.getCompensatingAction();
        List assocs = this.nodeService.getChildAssocs(actionNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)ActionModel.ASSOC_COMPENSATING_ACTION);
        if (assocs.size() == 0) {
            if (compensatingAction != null) {
                NodeRef compensatingActionNodeRef = this.createActionNodeRef(compensatingAction, actionNodeRef, ActionModel.ASSOC_COMPENSATING_ACTION, ActionModel.ASSOC_COMPENSATING_ACTION);
                this.saveActionImpl(compensatingActionNodeRef, compensatingAction);
            }
        } else {
            ChildAssociationRef assoc = (ChildAssociationRef)assocs.get(0);
            if (compensatingAction == null) {
                this.nodeService.removeChild(actionNodeRef, assoc.getChildRef());
            } else {
                this.saveActionImpl(assoc.getChildRef(), compensatingAction);
            }
        }
    }

    private void saveCompositeActions(NodeRef compositeActionNodeRef, ActionList<?> action2) {
        HashMap<String, Action> idToAction = new HashMap<String, Action>();
        ArrayList<String> orderedIds = new ArrayList<String>();
        for (Action action : action2.getActions()) {
            idToAction.put(action.getId(), action);
            orderedIds.add(action.getId());
        }
        List actionRefs = this.nodeService.getChildAssocs(compositeActionNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)ActionModel.ASSOC_ACTIONS);
        for (ChildAssociationRef actionRef : actionRefs) {
            NodeRef actionNodeRef = actionRef.getChildRef();
            if (!idToAction.containsKey(actionNodeRef.getId())) {
                this.nodeService.removeChild(compositeActionNodeRef, actionNodeRef);
                continue;
            }
            Action action = (Action)idToAction.get(actionNodeRef.getId());
            this.saveActionImpl(actionNodeRef, action);
            orderedIds.remove(actionNodeRef.getId());
        }
        for (String actionId : orderedIds) {
            Action action = (Action)idToAction.get(actionId);
            HashMap<QName, String> props = new HashMap<QName, String>(2);
            props.put(ActionModel.PROP_DEFINITION_NAME, action.getActionDefinitionName());
            props.put(ContentModel.PROP_NODE_UUID, action.getId());
            NodeRef actionNodeRef = this.nodeService.createNode(compositeActionNodeRef, ActionModel.ASSOC_ACTIONS, ActionModel.ASSOC_ACTIONS, ActionModel.TYPE_ACTION, props).getChildRef();
            ((ActionImpl)action).setCreator((String)((Object)this.nodeService.getProperty(actionNodeRef, ContentModel.PROP_CREATOR)));
            ((ActionImpl)action).setCreatedDate((Date)this.nodeService.getProperty(actionNodeRef, ContentModel.PROP_CREATED));
            ((ActionImpl)action).setNodeRef(actionNodeRef);
            this.saveActionImpl(actionNodeRef, action);
        }
    }

    private void saveConditions(NodeRef actionNodeRef, Action action) {
        List<ActionCondition> actionConditionsList = action.getActionConditions();
        this.saveActionConditionList(actionNodeRef, actionConditionsList, false);
    }

    private void saveActionConditionList(NodeRef actionNodeRef, List<ActionCondition> actionConditionsList, boolean isComposite) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SaveActionCondition list, " + actionConditionsList.size() + (isComposite ? " Composite" : "") + " conditions to be saved"));
        }
        HashMap<String, ActionCondition> idToCondition = new HashMap<String, ActionCondition>();
        ArrayList<String> orderedIds = new ArrayList<String>();
        for (ActionCondition actionCondition : actionConditionsList) {
            idToCondition.put(actionCondition.getId(), actionCondition);
            orderedIds.add(actionCondition.getId());
        }
        List conditionRefs = this.nodeService.getChildAssocs(actionNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)(!isComposite ? ActionModel.ASSOC_CONDITIONS : ActionModel.ASSOC_COMPOSITE_ACTION_CONDITION));
        for (ChildAssociationRef conditionRef : conditionRefs) {
            NodeRef conditionNodeRef = conditionRef.getChildRef();
            if (!idToCondition.containsKey(conditionNodeRef.getId())) {
                this.nodeService.removeChild(actionNodeRef, conditionNodeRef);
                continue;
            }
            this.saveConditionProperties(conditionNodeRef, (ActionCondition)idToCondition.get(conditionNodeRef.getId()));
            this.saveParameters(conditionNodeRef, (ParameterizedItem)idToCondition.get(conditionNodeRef.getId()));
            orderedIds.remove(conditionNodeRef.getId());
        }
        for (String nextId : orderedIds) {
            NodeRef conditionNodeRef;
            ActionCondition actionCondition = (ActionCondition)idToCondition.get(nextId);
            if (!isComposite && actionCondition instanceof CompositeActionCondition) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Saving Composite Condition");
                }
                conditionNodeRef = this.saveActionCondition(actionNodeRef, actionCondition, ActionModel.ASSOC_CONDITIONS, ActionModel.TYPE_COMPOSITE_ACTION_CONDITION);
                this.saveActionConditionList(conditionNodeRef, ((CompositeActionCondition)actionCondition).getActionConditions(), true);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Saving Condition " + actionCondition.getActionConditionDefinitionName()));
            }
            conditionNodeRef = this.saveActionCondition(actionNodeRef, actionCondition, !isComposite ? ActionModel.ASSOC_CONDITIONS : ActionModel.ASSOC_COMPOSITE_ACTION_CONDITION, ActionModel.TYPE_ACTION_CONDITION);
        }
    }

    private NodeRef saveActionCondition(NodeRef actionNodeRef, ActionCondition actionCondition, QName AssociationQName, QName typeName) {
        HashMap<QName, String> props = new HashMap<QName, String>(2);
        props.put(ActionModel.PROP_DEFINITION_NAME, actionCondition.getActionConditionDefinitionName());
        props.put(ContentModel.PROP_NODE_UUID, actionCondition.getId());
        NodeRef conditionNodeRef = this.nodeService.createNode(actionNodeRef, AssociationQName, AssociationQName, typeName, props).getChildRef();
        this.saveConditionProperties(conditionNodeRef, actionCondition);
        this.saveParameters(conditionNodeRef, actionCondition);
        return conditionNodeRef;
    }

    private void saveConditionProperties(NodeRef conditionNodeRef, ActionCondition condition) {
        this.nodeService.setProperty(conditionNodeRef, ActionModel.PROP_CONDITION_INVERT, (Serializable)Boolean.valueOf(condition.getInvertCondition()));
        if (condition instanceof CompositeActionCondition) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SAVING OR = " + ((CompositeActionCondition)condition).isORCondition()));
            }
            this.nodeService.setProperty(conditionNodeRef, ActionModel.PROP_CONDITION_ANDOR, (Serializable)new Boolean(((CompositeActionCondition)condition).isORCondition()));
        }
    }

    private void saveParameters(NodeRef parameterizedNodeRef, ParameterizedItem item) {
        HashMap<String, Serializable> parameterMap = new HashMap<String, Serializable>();
        parameterMap.putAll(item.getParameterValues());
        List parameters = this.nodeService.getChildAssocs(parameterizedNodeRef, (QNamePattern)ActionModel.ASSOC_PARAMETERS, (QNamePattern)ActionModel.ASSOC_PARAMETERS);
        for (ChildAssociationRef childAssociationRef : parameters) {
            NodeRef paramNodeRef = childAssociationRef.getChildRef();
            Map nodeRefParameterMap = this.nodeService.getProperties(paramNodeRef);
            String paramName = (String)nodeRefParameterMap.get(ActionModel.PROP_PARAMETER_NAME);
            if (!parameterMap.containsKey(paramName)) {
                this.nodeService.removeChild(parameterizedNodeRef, paramNodeRef);
                continue;
            }
            nodeRefParameterMap.put(ActionModel.PROP_PARAMETER_VALUE, parameterMap.get(paramName));
            this.nodeService.setProperties(paramNodeRef, nodeRefParameterMap);
            parameterMap.remove(paramName);
        }
        for (Map.Entry entry : parameterMap.entrySet()) {
            HashMap<QName, Object> nodeRefProperties = new HashMap<QName, Object>(2);
            nodeRefProperties.put(ActionModel.PROP_PARAMETER_NAME, entry.getKey());
            nodeRefProperties.put(ActionModel.PROP_PARAMETER_VALUE, entry.getValue());
            this.nodeService.createNode(parameterizedNodeRef, ActionModel.ASSOC_PARAMETERS, ActionModel.ASSOC_PARAMETERS, ActionModel.TYPE_ACTION_PARAMETER, nodeRefProperties);
        }
    }

    @Override
    public List<Action> getActions(NodeRef nodeRef) {
        ArrayList<Action> result = new ArrayList<Action>();
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ActionModel.ASPECT_ACTIONS)) {
            List actions = this.nodeService.getChildAssocs(this.getSavedActionFolderRef(nodeRef), RegexQNamePattern.MATCH_ALL, (QNamePattern)ActionModel.ASSOC_NAME_ACTIONS);
            for (ChildAssociationRef action : actions) {
                NodeRef actionNodeRef = action.getChildRef();
                result.add(this.createAction(actionNodeRef));
            }
        }
        return result;
    }

    @Override
    public Action createAction(NodeRef actionNodeRef) {
        ActionImpl result = null;
        Map properties = this.nodeService.getProperties(actionNodeRef);
        QName actionType = this.nodeService.getType(actionNodeRef);
        if (ActionModel.TYPE_COMPOSITE_ACTION.equals((Object)actionType)) {
            result = new CompositeActionImpl(actionNodeRef, actionNodeRef.getId());
            this.populateCompositeAction(actionNodeRef, (CompositeAction)((Object)result));
        } else {
            result = new ActionImpl(actionNodeRef, actionNodeRef.getId(), (String)properties.get(ActionModel.PROP_DEFINITION_NAME));
            this.populateAction(actionNodeRef, result);
        }
        return result;
    }

    private void populateAction(NodeRef actionNodeRef, Action action) {
        this.populateActionProperties(actionNodeRef, action);
        this.populateParameters(actionNodeRef, action);
        List conditions = this.nodeService.getChildAssocs(actionNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)ActionModel.ASSOC_CONDITIONS);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving " + (conditions == null ? " null" : Integer.valueOf(conditions.size())) + " conditions"));
        }
        if (conditions != null) {
            for (ChildAssociationRef condition : conditions) {
                NodeRef conditionNodeRef = condition.getChildRef();
                action.addActionCondition(this.createActionCondition(conditionNodeRef));
            }
        }
    }

    private void populateActionProperties(NodeRef actionNodeRef, Action action) {
        Map props = this.nodeService.getProperties(actionNodeRef);
        action.setTitle((String)props.get(ActionModel.PROP_ACTION_TITLE));
        action.setDescription((String)props.get(ActionModel.PROP_ACTION_DESCRIPTION));
        Boolean trackStatusObj = (Boolean)props.get(ActionModel.PROP_TRACK_STATUS);
        action.setTrackStatus(trackStatusObj);
        Boolean executeAsynchObj = (Boolean)props.get(ActionModel.PROP_EXECUTE_ASYNCHRONOUSLY);
        boolean executeAsynch = executeAsynchObj == null ? false : executeAsynchObj;
        action.setExecuteAsynchronously(executeAsynch);
        ((ActionImpl)action).setCreator((String)props.get(ContentModel.PROP_CREATOR));
        ((ActionImpl)action).setCreatedDate((Date)props.get(ContentModel.PROP_CREATED));
        ((ActionImpl)action).setModifier((String)props.get(ContentModel.PROP_MODIFIER));
        ((ActionImpl)action).setModifiedDate((Date)props.get(ContentModel.PROP_MODIFIED));
        ((ActionImpl)action).setExecutionStartDate((Date)props.get(ActionModel.PROP_EXECUTION_START_DATE));
        ((ActionImpl)action).setExecutionEndDate((Date)props.get(ActionModel.PROP_EXECUTION_END_DATE));
        ((ActionImpl)action).setExecutionStatus(ActionStatus.valueOf((Serializable)props.get(ActionModel.PROP_EXECUTION_ACTION_STATUS)));
        ((ActionImpl)action).setExecutionFailureMessage((String)props.get(ActionModel.PROP_EXECUTION_FAILURE_MESSAGE));
        List assocs = this.nodeService.getChildAssocs(actionNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)ActionModel.ASSOC_COMPENSATING_ACTION);
        if (assocs.size() != 0) {
            Action compensatingAction = this.createAction(((ChildAssociationRef)assocs.get(0)).getChildRef());
            action.setCompensatingAction(compensatingAction);
        }
    }

    private void populateParameters(NodeRef parameterizedItemNodeRef, ParameterizedItem parameterizedItem) {
        List parameters = this.nodeService.getChildAssocs(parameterizedItemNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)ActionModel.ASSOC_PARAMETERS);
        for (ChildAssociationRef parameter : parameters) {
            NodeRef parameterNodeRef = parameter.getChildRef();
            Map properties = this.nodeService.getProperties(parameterNodeRef);
            parameterizedItem.setParameterValue((String)properties.get(ActionModel.PROP_PARAMETER_NAME), (Serializable)properties.get(ActionModel.PROP_PARAMETER_VALUE));
        }
    }

    private ActionCondition createActionCondition(NodeRef conditionNodeRef) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\tCreateActionCondition: Retrieving Conditions from repository");
        }
        Map properties = this.nodeService.getProperties(conditionNodeRef);
        QName conditionType = this.nodeService.getType(conditionNodeRef);
        ActionConditionImpl condition = null;
        if (!ActionModel.TYPE_COMPOSITE_ACTION_CONDITION.equals((Object)conditionType)) {
            condition = new ActionConditionImpl(conditionNodeRef.getId(), (String)properties.get(ActionModel.PROP_DEFINITION_NAME));
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"\tRetrieving Composite Condition from repository");
            }
            CompositeActionConditionImpl compositeCondition = new CompositeActionConditionImpl(GUID.generate());
            this.populateCompositeActionCondition(conditionNodeRef, compositeCondition);
            condition = compositeCondition;
        }
        Boolean invert = (Boolean)this.nodeService.getProperty(conditionNodeRef, ActionModel.PROP_CONDITION_INVERT);
        condition.setInvertCondition(invert == null ? false : invert);
        this.populateParameters(conditionNodeRef, condition);
        return condition;
    }

    private void populateCompositeActionCondition(NodeRef compositeNodeRef, CompositeActionCondition compositeActionCondition) {
        List conditions = this.nodeService.getChildAssocs(compositeNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)ActionModel.ASSOC_COMPOSITE_ACTION_CONDITION);
        Boolean OR = (Boolean)this.nodeService.getProperty(compositeNodeRef, ActionModel.PROP_CONDITION_ANDOR);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\tPopulating Composite Condition with subconditions, Condition OR = " + OR));
        }
        compositeActionCondition.setORCondition(OR == null ? false : OR);
        for (ChildAssociationRef conditionNodeRef : conditions) {
            NodeRef actionNodeRef = conditionNodeRef.getChildRef();
            ActionCondition currentCondition = this.createActionCondition(actionNodeRef);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\t\tAdding subcondition " + currentCondition.getActionConditionDefinitionName()));
            }
            compositeActionCondition.addActionCondition(currentCondition);
        }
    }

    public void populateCompositeAction(NodeRef compositeNodeRef, CompositeAction compositeAction) {
        this.populateAction(compositeNodeRef, compositeAction);
        List actions = this.nodeService.getChildAssocs(compositeNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)ActionModel.ASSOC_ACTIONS);
        for (ChildAssociationRef action : actions) {
            NodeRef actionNodeRef = action.getChildRef();
            compositeAction.addAction(this.createAction(actionNodeRef));
        }
    }

    @Override
    public Action getAction(NodeRef nodeRef, String actionId) {
        NodeRef actionNodeRef;
        Action result = null;
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ActionModel.ASPECT_ACTIONS) && (actionNodeRef = this.getActionNodeRefFromId(nodeRef, actionId)) != null) {
            result = this.createAction(actionNodeRef);
        }
        return result;
    }

    @Override
    public void removeAction(NodeRef nodeRef, Action action) {
        NodeRef actionNodeRef;
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ActionModel.ASPECT_ACTIONS) && (actionNodeRef = this.getActionNodeRefFromId(nodeRef, action.getId())) != null) {
            this.nodeService.removeChild(this.getSavedActionFolderRef(nodeRef), actionNodeRef);
        }
    }

    @Override
    public void removeAllActions(NodeRef nodeRef) {
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ActionModel.ASPECT_ACTIONS)) {
            ArrayList actions = new ArrayList(this.nodeService.getChildAssocs(this.getSavedActionFolderRef(nodeRef), RegexQNamePattern.MATCH_ALL, (QNamePattern)ActionModel.ASSOC_NAME_ACTIONS));
            for (ChildAssociationRef action : actions) {
                this.nodeService.removeChild(this.getSavedActionFolderRef(nodeRef), action.getChildRef());
            }
        }
    }

    private void addPostTransactionPendingAction(Action action, NodeRef actionedUponNodeRef, boolean checkConditions, Set<String> actionChain) {
        if (logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("addPostTransactionPendingAction action chain = ");
            if (actionChain == null) {
                builder.append("null");
            } else {
                for (String value : actionChain) {
                    builder.append(value).append(" ");
                }
            }
            logger.debug((Object)builder.toString());
            logger.debug((Object)("Current action = " + action.getId()));
        }
        if (actionChain == null || !actionChain.contains(action.getId())) {
            PendingAction pendingAction;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Doing addPostTransactionPendingAction");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The current user is: " + this.authenticationContext.getCurrentUserName()));
            }
            ((ActionImpl)action).setRunAsUser(this.authenticationContext.getCurrentUserName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The current tenant is: " + TenantUtil.getCurrentDomain()));
            }
            ((ActionImpl)action).setTenantId(TenantUtil.getCurrentDomain());
            AlfrescoTransactionSupport.bindListener(this.transactionListener);
            ArrayList<PendingAction> pendingActions = (ArrayList<PendingAction>)AlfrescoTransactionSupport.getResource(POST_TRANSACTION_PENDING_ACTIONS);
            if (pendingActions == null) {
                pendingActions = new ArrayList<PendingAction>();
                AlfrescoTransactionSupport.bindResource(POST_TRANSACTION_PENDING_ACTIONS, pendingActions);
            }
            if (!pendingActions.contains(pendingAction = new PendingAction(action, actionedUponNodeRef, checkConditions, actionChain))) {
                pendingActions.add(pendingAction);
                if (this.getTrackStatus(action)) {
                    this.actionTrackingService.recordActionPending(action, actionedUponNodeRef);
                }
            }
        }
    }

    private List<PendingAction> getPostTransactionPendingActions() {
        return (List)AlfrescoTransactionSupport.getResource(POST_TRANSACTION_PENDING_ACTIONS);
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return ActionParameterTypeCopyBehaviourCallback.INSTANCE;
    }

    @Override
    public void onCopyComplete(QName classRef, NodeRef sourceNodeRef, NodeRef targetNodeRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copyMap) {
        ActionParameterTypeCopyBehaviourCallback.INSTANCE.repointNodeRefs(sourceNodeRef, targetNodeRef, ActionModel.PROP_PARAMETER_VALUE, copyMap, this.nodeService);
    }

    private static class ActionParameterTypeCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final ActionParameterTypeCopyBehaviourCallback INSTANCE = new ActionParameterTypeCopyBehaviourCallback();

        private ActionParameterTypeCopyBehaviourCallback() {
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            NodeRef sourceNodeRef = copyDetails.getSourceNodeRef();
            this.recordNodeRefsForRepointing(sourceNodeRef, properties, ActionModel.PROP_PARAMETER_VALUE);
            return properties;
        }
    }

    private class PendingAction {
        private Action action;
        private NodeRef actionedUponNodeRef;
        private boolean checkConditions;
        private Set<String> actionChain;

        public PendingAction(Action action, NodeRef actionedUponNodeRef, boolean checkConditions, Set<String> actionChain) {
            this.action = action;
            this.actionedUponNodeRef = actionedUponNodeRef;
            this.checkConditions = checkConditions;
            this.actionChain = actionChain;
        }

        public Action getAction() {
            return this.action;
        }

        public NodeRef getActionedUponNodeRef() {
            return this.actionedUponNodeRef;
        }

        public boolean getCheckConditions() {
            return this.checkConditions;
        }

        public Set<String> getActionChain() {
            return this.actionChain;
        }

        public int hashCode() {
            int hashCode = 37 * this.actionedUponNodeRef.hashCode();
            return hashCode += 37 * this.action.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PendingAction) {
                PendingAction that = (PendingAction)obj;
                return this.action.equals(that.action) && this.actionedUponNodeRef.equals((Object)that.actionedUponNodeRef);
            }
            return false;
        }
    }
}

